/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.declaration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyType;
import org.eclipse.vjet.dsf.jst.declaration.JstWildcardType;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class JstTypeWithArgs
extends JstProxyType {
    private static final long serialVersionUID = 1L;
    private List<IJstType> m_argTypes = new ArrayList<IJstType>();
    private transient HashMap<JstParamType, IJstType> m_argMap = new HashMap();

    public JstTypeWithArgs(IJstType type) {
        super(type);
        this.getModifiers().setPublic();
    }

    public synchronized void addArgType(IJstType argType) {
        if (argType == null) {
            return;
        }
        this.m_argTypes.add(argType);
    }

    public synchronized List<IJstType> getArgTypes() {
        return Collections.unmodifiableList(this.m_argTypes);
    }

    public IJstType getArgType() {
        List<IJstType> argTypes = this.getArgTypes();
        if (argTypes.isEmpty()) {
            return null;
        }
        return argTypes.get(0);
    }

    public String getArgsDecoration() {
        StringBuilder sb = new StringBuilder("<");
        int i = 0;
        for (IJstType p : this.getArgTypes()) {
            if (i++ > 0) {
                sb.append(",");
            }
            if (p instanceof JstWildcardType) {
                sb.append("?");
                if (((JstWildcardType)p).isUpperBound()) {
                    sb.append(" extends ").append(p.getSimpleName());
                } else if (((JstWildcardType)p).isLowerBound()) {
                    sb.append(" super ").append(p.getSimpleName());
                }
            } else {
                sb.append(p.getSimpleName());
            }
            if (!(p instanceof JstTypeWithArgs)) continue;
            sb.append(((JstTypeWithArgs)p).getArgsDecoration());
        }
        sb.append(">");
        return sb.toString();
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    private IJstType getArgTypeFromParam(JstParamType paramType) {
        List<JstParamType> paramTypes = this.getOwnerType().getParamTypes();
        if (!this.m_argMap.isEmpty() && paramTypes != null && !paramTypes.isEmpty() && this.m_argMap.get(paramTypes.get(0)) == null) {
            this.m_argMap.clear();
        }
        if (this.m_argMap.isEmpty()) {
            int paramSize;
            List<IJstType> argTypes = this.getArgTypes();
            if (argTypes == null || paramType == null) {
                return null;
            }
            int argSize = argTypes.size();
            int size = argSize < (paramSize = paramTypes.size()) ? argSize : paramSize;
            int i = 0;
            while (i < size) {
                this.m_argMap.put(paramTypes.get(i), argTypes.get(i));
                ++i;
            }
        }
        return this.m_argMap.get(paramType);
    }

    public IJstType getParamArgType(JstParamType paramType) {
        IJstType argType = this.getArgTypeFromParam(paramType);
        if (argType == null) {
            List<? extends IJstType> listInterfaces;
            IJstType parent = this.getExtend();
            if (parent != null && parent instanceof JstTypeWithArgs) {
                argType = ((JstTypeWithArgs)parent).getParamArgType(paramType);
            }
            if (argType == null && (listInterfaces = this.getSatisfies()) != null && !listInterfaces.isEmpty()) {
                for (IJstType iJstType : listInterfaces) {
                    if (iJstType != null && iJstType instanceof JstTypeWithArgs && (argType = ((JstTypeWithArgs)iJstType).getParamArgType(paramType)) != null) break;
                }
            }
            if (argType != null) {
                IJstType paramArgType = argType;
                while (paramArgType != null && paramArgType instanceof JstParamType) {
                    if ((paramArgType = this.getParamArgType((JstParamType)paramArgType)) == null) continue;
                    if (paramArgType == argType) break;
                    argType = paramArgType;
                }
            }
        }
        return argType;
    }
}

