/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.declaration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstFactory;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstSynthesizedProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeRefType;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;

public class JstVjoProperty
extends JstSynthesizedProperty {
    private static final long serialVersionUID = 1L;
    private transient JstType m_type;
    private boolean m_isInstance;
    private IJstType m_ownerType;

    public JstVjoProperty(String name, IJstType ownerType) {
        this(name, ownerType, false);
    }

    public JstVjoProperty(String name, IJstType ownerType, boolean isInstance) {
        super((IJstType)null, name, (JstIdentifier)null, new JstModifiers());
        this.m_ownerType = ownerType;
        this.m_isInstance = isInstance;
    }

    @Override
    public synchronized IJstType getType() {
        if (this.m_type == null) {
            this.m_type = JstFactory.getInstance().createJstType("Vj$Type", false);
            ArrayList<IJstProperty> list = new ArrayList<IJstProperty>();
            IJstRefType typeRef = this.getTypeRef(this.m_ownerType);
            list.add(new JstProperty(typeRef, "type"));
            if (!this.m_ownerType.isMixin() && !this.m_ownerType.isEmbededType()) {
                list.add(new JstProperty(typeRef, this.m_ownerType.getSimpleName()));
            }
            this.addPropertiesFromType(this.m_ownerType, list);
            if (this.m_ownerType.isEmbededType()) {
                IJstType outerType = this.m_ownerType.getOuterType();
                list.add(new JstProperty(this.getTypeRef(outerType), outerType.getSimpleName()));
                this.addPropertiesFromType(outerType, list);
            }
            if (this.m_isInstance && this.m_ownerType.isEmbededType() && !this.m_ownerType.isMixin() && !this.m_ownerType.getModifiers().isStatic()) {
                list.add(new JstProperty(this.m_ownerType.getOuterType(), "outer"));
            }
            this.addAllProperties(this.m_type, list);
        }
        return this.m_type;
    }

    private void addAllProperties(JstType type, List<IJstProperty> list) {
        for (IJstProperty p : list) {
            p.getModifiers().setPublic();
            type.addProperty(p);
        }
    }

    private void addPropertiesFromType(IJstType type, List<IJstProperty> list) {
        for (Map.Entry<String, ? extends IJstType> entry : type.getImportsMap().entrySet()) {
            if (entry.getKey().equals(entry.getValue().getName()) || this.propertyExists(list, entry.getKey())) continue;
            list.add(new JstProperty(this.getTypeRef(entry.getValue()), entry.getKey()));
        }
        if (!type.isMixin()) {
            for (IJstType iJstType : type.getExtends()) {
                if ("vjo.Object".equals(iJstType.getName()) || this.propertyExists(list, iJstType.getSimpleName())) continue;
                list.add(new JstProperty(this.getTypeRef(iJstType), iJstType.getSimpleName()));
            }
        }
        for (IJstType iJstType : type.getSatisfies()) {
            if (this.propertyExists(list, iJstType.getSimpleName())) continue;
            list.add(new JstProperty(this.getTypeRef(iJstType), iJstType.getSimpleName()));
        }
    }

    private boolean propertyExists(List<IJstProperty> list, String name) {
        if (name == null) {
            return false;
        }
        for (IJstProperty itm : list) {
            if (!name.equals(itm.getName().getName())) continue;
            return true;
        }
        return false;
    }

    private IJstRefType getTypeRef(IJstType type) {
        if (type instanceof IJstRefType) {
            return (IJstRefType)type;
        }
        return new JstTypeRefType(type);
    }
}

