/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.expr;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public final class AssignExpr
extends BaseJstNode
implements IExpr,
IStmt {
    private static final long serialVersionUID = 1L;
    private final ILHS m_lhs;
    private IExpr m_expr;
    private Operator m_op;

    public AssignExpr(ILHS lhs, IExpr expr) {
        this(lhs, expr, Operator.ASSIGN);
    }

    public AssignExpr(ILHS lhs, IExpr expr, String op) {
        this(lhs, expr, Operator.toOperator(op));
    }

    public AssignExpr(ILHS lhs, IExpr expr, Operator op) {
        this.m_lhs = lhs;
        this.m_expr = expr;
        this.m_op = op;
        this.addChild(lhs);
        this.addChild(expr);
    }

    @Override
    public IJstType getResultType() {
        if (this.m_lhs != null) {
            return this.m_lhs.getType();
        }
        if (this.m_expr != null) {
            return this.m_expr.getResultType();
        }
        return null;
    }

    @Override
    public String toExprText() {
        StringBuilder sb = new StringBuilder();
        if (this.m_lhs != null) {
            sb.append(this.m_lhs.toLHSText());
        }
        if (this.m_op != null) {
            sb.append(this.m_op.toString());
        }
        if (this.m_expr != null) {
            sb.append(this.m_expr.toExprText());
        }
        return sb.toString();
    }

    @Override
    public String toStmtText() {
        return String.valueOf(this.toExprText()) + ";";
    }

    public ILHS getLHS() {
        return this.m_lhs;
    }

    public Operator getOprator() {
        return this.m_op;
    }

    public IExpr getExpr() {
        return this.m_expr;
    }

    public void setExpr(IExpr e) {
        this.m_expr = e;
    }

    public void setOp(Operator op) {
        this.m_op = op;
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.toExprText();
    }

    public static class Operator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String op;
        public static final Operator ASSIGN = new Operator("=");
        public static final Operator PLUS_ASSIGN = new Operator("+=");
        public static final Operator MINUS_ASSIGN = new Operator("-=");
        public static final Operator TIMES_ASSIGN = new Operator("*=");
        public static final Operator DIVIDE_ASSIGN = new Operator("/=");
        public static final Operator BIT_AND_ASSIGN = new Operator("&=");
        public static final Operator BIT_OR_ASSIGN = new Operator("|=");
        public static final Operator BIT_XOR_ASSIGN = new Operator("^=");
        public static final Operator REMAINDER_ASSIGN = new Operator("%=");
        public static final Operator LEFT_SHIFT_ASSIGN = new Operator("<<=");
        public static final Operator RIGHT_SHIFT_SIGNED_ASSIGN = new Operator(">>=");
        public static final Operator RIGHT_SHIFT_UNSIGNED_ASSIGN = new Operator(">>>=");
        private static final Map<String, Operator> CODES = new HashMap<String, Operator>(20);

        static {
            Operator[] ops = new Operator[]{ASSIGN, PLUS_ASSIGN, MINUS_ASSIGN, TIMES_ASSIGN, DIVIDE_ASSIGN, BIT_AND_ASSIGN, BIT_OR_ASSIGN, BIT_XOR_ASSIGN, REMAINDER_ASSIGN, LEFT_SHIFT_ASSIGN, RIGHT_SHIFT_SIGNED_ASSIGN, RIGHT_SHIFT_UNSIGNED_ASSIGN};
            int i = 0;
            while (i < ops.length) {
                CODES.put(ops[i].toString(), ops[i]);
                ++i;
            }
        }

        private Operator(String op) {
            this.op = op;
        }

        public String toString() {
            return this.op;
        }

        public static Operator toOperator(String token) {
            return CODES.get(token);
        }
    }
}

