/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.expr;

import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class FieldAccessExpr
extends BaseJstNode
implements ILHS,
IExpr {
    private static final long serialVersionUID = 1L;
    private JstIdentifier m_name;
    private IExpr m_qualifier;
    private IJstType m_type;

    public FieldAccessExpr(JstIdentifier name) {
        this(name, null);
    }

    public FieldAccessExpr(JstIdentifier name, IExpr qualifier) {
        assert (name != null) : "name is null";
        this.m_name = name;
        this.m_qualifier = qualifier;
        this.addChild(name);
        this.addChild(qualifier);
    }

    @Override
    public String toExprText() {
        String text;
        StringBuilder sb = new StringBuilder();
        String n = null;
        if (this.m_name != null) {
            n = this.m_name.toSimpleTermText();
        }
        String q = null;
        if (this.m_qualifier != null) {
            q = this.m_qualifier.toExprText();
        }
        if (q != null) {
            sb.append(q);
        }
        if (q != null && n != null) {
            sb.append(".");
        }
        if (n != null) {
            sb.append(n);
        }
        return (text = sb.toString()).length() > 0 ? text : null;
    }

    @Override
    public String toLHSText() {
        return this.toExprText();
    }

    @Override
    public IJstType getResultType() {
        return this.m_type != null ? this.m_type : this.m_name.getResultType();
    }

    @Override
    public IJstType getType() {
        return this.m_type != null ? this.m_type : this.m_name.getType();
    }

    public void setName(JstIdentifier name) {
        this.removeChild(this.m_name);
        this.addChild(name);
        this.m_name = name;
    }

    public JstIdentifier getName() {
        return this.m_name;
    }

    public void setExpr(IExpr qualifier) {
        this.removeChild(this.m_qualifier);
        this.addChild(qualifier);
        this.m_qualifier = qualifier;
    }

    public IExpr getExpr() {
        return this.m_qualifier;
    }

    public void setType(IJstType type) {
        this.m_type = type;
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.toExprText();
    }
}

