/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.expr;

import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class ObjCreationExpr
extends BaseJstNode
implements IExpr {
    private static final long serialVersionUID = 1L;
    private MtdInvocationExpr m_invocation;
    private IExpr m_expr;
    private IJstType m_anonymousType;

    public ObjCreationExpr(MtdInvocationExpr invocation) {
        this(invocation, null);
    }

    public ObjCreationExpr(MtdInvocationExpr invocation, IJstType anonymousType) {
        assert (invocation != null) : "invocation cannot be null";
        this.m_invocation = invocation;
        this.m_anonymousType = anonymousType;
        this.addChild(invocation);
        this.addChild(anonymousType);
    }

    @Override
    public IJstType getResultType() {
        IJstType result;
        IJstType iJstType = result = this.m_invocation == null ? null : this.m_invocation.getResultType();
        if (result != null && result instanceof IJstRefType) {
            result = ((IJstRefType)result).getReferencedNode();
        }
        return result;
    }

    @Override
    public String toExprText() {
        StringBuilder sb = new StringBuilder();
        sb.append("new ");
        if (this.m_expr != null) {
            sb.append(this.m_expr.toExprText()).append(".");
        }
        if (this.m_invocation != null) {
            sb.append(this.m_invocation.toExprText());
        }
        return sb.toString();
    }

    public String toStmtText() {
        return String.valueOf(this.toExprText()) + ";";
    }

    public MtdInvocationExpr getInvocationExpr() {
        return this.m_invocation;
    }

    public void setExpression(IExpr expr) {
        this.removeChild(this.m_expr);
        this.addChild(expr);
        this.m_expr = expr;
    }

    public IExpr getExpression() {
        return this.m_expr;
    }

    public IJstType getAnonymousType() {
        return this.m_anonymousType;
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.toExprText();
    }
}

