/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.expr;

import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class TextExpr
extends BaseJstNode
implements IExpr {
    private static final long serialVersionUID = 1L;
    private String m_text;
    private IJstType m_resultType;

    public TextExpr(String text) {
        this(text, null);
    }

    public TextExpr(String text, IJstType resultType) {
        assert (text != null) : "text cannot be null";
        this.m_text = text;
        this.m_resultType = resultType;
    }

    @Override
    public String toExprText() {
        return this.m_text;
    }

    @Override
    public IJstType getResultType() {
        return this.m_resultType;
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        if (this.m_resultType == null) {
            return this.m_text;
        }
        return String.valueOf(this.m_text) + ": " + this.m_resultType.getName();
    }
}

