/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.stmt;

import org.eclipse.vjet.dsf.jst.declaration.JstVar;
import org.eclipse.vjet.dsf.jst.stmt.BlockStmt;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class CatchStmt
extends BlockStmt
implements IStmt {
    private static final long serialVersionUID = 1L;
    private JstVar m_exception;

    public CatchStmt(JstVar exception) {
        assert (exception != null) : "exception cannot be null";
        this.m_exception = exception;
        this.addChild(exception);
    }

    public void add(IStmt stmt) {
        this.getBody().addStmt(stmt);
    }

    public JstVar getException() {
        return this.m_exception;
    }

    @Override
    public String toStmtText() {
        StringBuilder sb = new StringBuilder("catch (");
        if (this.m_exception != null) {
            sb.append(this.m_exception.getName()).append("){").append(this.getBody().toBlockText()).append("}");
        }
        return sb.toString();
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return this.toStmtText();
    }
}

