/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.stmt;

import java.text.MessageFormat;
import org.eclipse.vjet.dsf.jst.declaration.JstVar;
import org.eclipse.vjet.dsf.jst.stmt.BlockStmt;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class ForInStmt
extends BlockStmt
implements IStmt {
    private static final long serialVersionUID = 1L;
    public static final String FOR_IN_STMT = "for ({0} in {1})";
    private ILHS m_var;
    private IExpr m_expr;

    public ForInStmt() {
    }

    public ForInStmt(JstVar var, IExpr expr) {
        this((ILHS)var, expr);
    }

    public ForInStmt(JstIdentifier var, IExpr expr) {
        this((ILHS)var, expr);
    }

    public ForInStmt(ILHS var, IExpr expr) {
        assert (var != null) : "var cannot be null";
        assert (expr != null) : "expr cannot be null";
        this.m_var = var;
        this.m_expr = expr;
        this.addChild(var);
        this.addChild(expr);
    }

    public ForInStmt addStmt(IStmt stmt) {
        assert (stmt != null) : "stmt cannot be null";
        this.getBody().addStmt(stmt);
        return this;
    }

    public ILHS getVar() {
        return this.m_var;
    }

    public IExpr getExpr() {
        return this.m_expr;
    }

    @Override
    public String toStmtText() {
        StringBuilder sb = new StringBuilder();
        sb.append(MessageFormat.format(FOR_IN_STMT, this.m_var.toLHSText(), this.m_expr.toExprText())).append(this.getBody().toBlockText());
        return sb.toString();
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return this.toStmtText();
    }
}

