/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.term;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.SynthOlType;
import org.eclipse.vjet.dsf.jst.term.JstLiteral;
import org.eclipse.vjet.dsf.jst.term.NV;
import org.eclipse.vjet.dsf.jst.term.SimpleLiteral;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class ObjLiteral
extends JstLiteral {
    private static final long serialVersionUID = 1L;
    private Map<String, NV> m_nvs = new LinkedHashMap<String, NV>(2);
    private IJstType m_jstType = new SynthOlType(this);

    public void setJstType(IJstType type) {
        this.m_jstType = type;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object obj = in.readObject();
        if (obj instanceof IJstType) {
            this.m_jstType = (IJstType)obj;
        }
        if ((obj = in.readObject()) instanceof List) {
            this.m_nvs = new LinkedHashMap<String, NV>();
            List list = (List)obj;
            for (NV object : list) {
                if (object == null || object.getName() == null) continue;
                this.m_nvs.put(object.getName(), object);
            }
        } else {
            this.m_nvs = (Map)obj;
        }
    }

    @Override
    public String toValueText() {
        StringBuilder sb = new StringBuilder("{");
        List<NV> nvs = this.getNVs();
        int i = 0;
        while (i < nvs.size()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(nvs.get(i));
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public IJstType getResultType() {
        return this.m_jstType;
    }

    public String toParamText() {
        return this.toValueText();
    }

    public String toTermText() {
        return this.toValueText();
    }

    @Override
    public String toSimpleTermText() {
        return this.toValueText();
    }

    public String toRHSText() {
        return this.toValueText();
    }

    @Override
    public String toExprText() {
        return this.toValueText();
    }

    public ObjLiteral add(String name, String value) {
        return this.add(new NV(name, SimpleLiteral.getStringLiteral(value)));
    }

    public ObjLiteral add(String name, boolean value) {
        return this.add(new NV(name, SimpleLiteral.getBooleanLiteral(value)));
    }

    public ObjLiteral add(String name, int value) {
        return this.add(new NV(name, SimpleLiteral.getIntLiteral(value)));
    }

    public ObjLiteral add(String name, IExpr value) {
        return this.add(new NV(name, value));
    }

    public ObjLiteral add(NV nv) {
        assert (nv != null) : "nv is null";
        this.m_nvs.put(nv.getName(), nv);
        this.addChild(nv);
        return this;
    }

    public List<NV> getNVs() {
        ArrayList<NV> list = new ArrayList<NV>(this.m_nvs.values());
        return Collections.unmodifiableList(list);
    }

    public NV getNV(String field) {
        return this.m_nvs.get(field);
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.toValueText();
    }
}

