/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.ts;

import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.ts.JstQueryExecutor;
import org.eclipse.vjet.dsf.ts.ASymbolTableManager;
import org.eclipse.vjet.dsf.ts.TypeSpace;
import org.eclipse.vjet.dsf.ts.graph.DependencyNode;
import org.eclipse.vjet.dsf.ts.index.DependencyIndexNode;
import org.eclipse.vjet.dsf.ts.method.MethodName;
import org.eclipse.vjet.dsf.ts.property.PropertyName;
import org.eclipse.vjet.dsf.ts.type.ISymbolName;
import org.eclipse.vjet.dsf.ts.type.TypeName;

abstract class AJstSymbolTableMgr<T extends ISymbolName>
extends ASymbolTableManager<IJstType, IJstNode> {
    protected final JstQueryExecutor m_qe;
    protected final TypeSpace<IJstType, IJstNode> m_ts;

    protected AJstSymbolTableMgr(TypeSpace<IJstType, IJstNode> ts, JstQueryExecutor executor) {
        assert (ts != null) : "ts cannot be null";
        this.m_ts = ts;
        this.m_qe = executor;
    }

    abstract Map<T, List<IJstNode>> findSymbolUsagesWithinType(IJstType var1);

    @Override
    protected IJstType lookupType(TypeName typeName) {
        IJstType type = this.m_ts.getType(typeName);
        if (type == null) {
            DependencyNode<IJstType> node = this.m_ts.getUnresolvedNodes().get(typeName.typeName());
            type = node.getEntity();
        }
        return type;
    }

    void processTypeAdded(TypeName typeName, IJstType type) {
        if (type == null) {
            return;
        }
        this.fixIndexMap(typeName, type);
        Map<T, List<IJstNode>> map = this.findSymbolUsagesWithinType(type);
        this.addReferencesUsedByType(type, map);
    }

    void processTypeRemoved(TypeName typeName) {
        this.removeIndex(typeName);
        this.removeReferencesToType(typeName, this.m_ts.getAllDependencies(typeName));
    }

    @Override
    protected Map<? extends ISymbolName, List<IJstNode>> getMethodUsages(IJstNode n) {
        return this.m_qe.findMethodUsagesWithinNode(n);
    }

    @Override
    protected Map<? extends ISymbolName, List<IJstNode>> getPropertyUsages(IJstNode n) {
        return this.m_qe.findPropertyUsagesWithinNode(n);
    }

    @Override
    protected String getName(IJstType type) {
        return type.getName();
    }

    @Override
    protected IJstType getOwnerType(IJstNode node) {
        return node.getOwnerType();
    }

    @Override
    protected void removePropertyDependencies(Map<? extends ISymbolName, List<IJstNode>> usage_list) {
        this.m_ts.getPropertySymbolTableManager().remove_dependencies(usage_list);
        this.removeUnresolvedPtyIndexNodeDependencies(usage_list);
    }

    @Override
    protected void removeMethodDependencies(Map<? extends ISymbolName, List<IJstNode>> usage_list) {
        this.m_ts.getMethodSymbolTableManager().remove_dependencies(usage_list);
        this.removeUnresolvedMtdIndexNodeDependencies(usage_list);
    }

    protected void removeUnresolvedPtyIndexNodeDependencies(Map<? extends ISymbolName, List<IJstNode>> usage_list) {
        if (usage_list == null) {
            return;
        }
        for (Map.Entry<? extends ISymbolName, List<IJstNode>> entry : usage_list.entrySet()) {
            ISymbolName symbol = entry.getKey();
            TypeName typeName = new TypeName(symbol.getGroupName(), symbol.getOwnerTypeName());
            DependencyIndexNode<IJstNode> node = this.m_ts.getUnresolvedIndexNode(new PropertyName(typeName, symbol.getLocalName()));
            if (node == null) continue;
            node.removeDependents(entry.getValue());
        }
    }

    protected void removeUnresolvedMtdIndexNodeDependencies(Map<? extends ISymbolName, List<IJstNode>> usage_list) {
        if (usage_list == null) {
            return;
        }
        for (Map.Entry<? extends ISymbolName, List<IJstNode>> entry : usage_list.entrySet()) {
            ISymbolName symbol = entry.getKey();
            TypeName typeName = new TypeName(symbol.getGroupName(), symbol.getOwnerTypeName());
            DependencyIndexNode<IJstNode> node = this.m_ts.getUnresolvedIndexNode(new MethodName(typeName, symbol.getLocalName()));
            if (node == null) continue;
            node.removeDependents(entry.getValue());
        }
    }
}

