/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.ts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyType;
import org.eclipse.vjet.dsf.jst.traversal.IJstVisitor;
import org.eclipse.vjet.dsf.jst.traversal.JstDepthFirstTraversal;
import org.eclipse.vjet.dsf.jst.ts.TypeSpaceLocker;
import org.eclipse.vjet.dsf.jst.ts.util.MethodDependencyVisitor;
import org.eclipse.vjet.dsf.jst.ts.util.PropertyDependencyVisitor;
import org.eclipse.vjet.dsf.ts.TypeSpace;
import org.eclipse.vjet.dsf.ts.graph.DependencyNode;
import org.eclipse.vjet.dsf.ts.group.Group;
import org.eclipse.vjet.dsf.ts.group.GroupDependencyNode;
import org.eclipse.vjet.dsf.ts.group.IGroup;
import org.eclipse.vjet.dsf.ts.method.MethodIndex;
import org.eclipse.vjet.dsf.ts.method.MethodName;
import org.eclipse.vjet.dsf.ts.property.PropertyIndex;
import org.eclipse.vjet.dsf.ts.property.PropertyName;
import org.eclipse.vjet.dsf.ts.type.ISymbolName;
import org.eclipse.vjet.dsf.ts.type.TypeName;

public class JstQueryExecutor {
    private final TypeSpace<IJstType, IJstNode> m_ts;
    private final TypeSpaceLocker m_locker;

    public JstQueryExecutor(TypeSpace<IJstType, IJstNode> ts) {
        if (ts == null) {
            throw new AssertionError((Object)"ts cannot be null");
        }
        this.m_ts = ts;
        this.m_locker = this.m_ts.getLocker();
    }

    public IJstType findType(TypeName typeName) {
        IJstType type = this.m_ts.getType(typeName);
        return type;
    }

    public IJstType findType(TypeName typeName, IGroup<IJstType> fromGroup) {
        return this.m_ts.getVisibleType(typeName, fromGroup);
    }

    public Map<TypeName, IJstType> findAllTypes() {
        return this.m_ts.getTypes();
    }

    public List<String> findAllPackages() {
        return this.m_ts.getPackages();
    }

    public Map<TypeName, IJstType> findAllTypesInPackage(String packageName) {
        return this.m_ts.getTypes(packageName);
    }

    public List<IJstType> findPackageDependents(String packageName) {
        return this.m_ts.getPackageDependents(packageName);
    }

    public List<Group<IJstType>> findGroupDependents(String groupName) {
        GroupDependencyNode<IJstType> node = this.m_ts.getGroupDependencyNode(groupName);
        ArrayList<Group<IJstType>> listGrp = new ArrayList<Group<IJstType>>();
        if (node != null) {
            for (GroupDependencyNode<IJstType> dependent : node.getDependents().values()) {
                listGrp.add(dependent.getGroup());
            }
        }
        return listGrp;
    }

    public List<Group<IJstType>> findGroupDependencies(String groupName) {
        GroupDependencyNode<IJstType> node = this.m_ts.getGroupDependencyNode(groupName);
        ArrayList<Group<IJstType>> listGrp = new ArrayList<Group<IJstType>>();
        if (node != null) {
            for (GroupDependencyNode<IJstType> dependency : node.getDependencies().values()) {
                listGrp.add(dependency.getGroup());
            }
        }
        return listGrp;
    }

    public IJstType findGlobalType(String groupName, String typeName) {
        return this.m_ts.getGlobalType(groupName, typeName);
    }

    public IJstNode findGlobalVar(String groupName, String ptyName, boolean recursive) {
        IJstNode var = this.m_ts.getGlobalVar(groupName, ptyName);
        if (var != null) {
            return var;
        }
        if (!recursive) {
            return null;
        }
        IGroup group = this.m_ts.getGroup(groupName);
        if (group == null) {
            return null;
        }
        for (IGroup depGrp : group.getGroupDependency()) {
            var = this.m_ts.getGlobalVar(depGrp.getName(), ptyName);
            if (var == null) continue;
            return var;
        }
        return null;
    }

    public List<IJstNode> getAllGlobalVars() {
        return this.m_ts.getAllGlobalVars();
    }

    public List<IJstNode> getAllGroupScopedGlobalVars(String groupName) {
        return this.m_ts.getAllVisibleGlobals(this.m_ts.getGroup(groupName));
    }

    public List<IJstNode> getAllGlobalVars(String groupName) {
        return this.m_ts.getAllGlobalVars(groupName);
    }

    public List<IJstType> findNeeded(TypeName typeName) {
        try {
            this.m_locker.lockShared();
            if (typeName == null) {
                List<IJstType> list = Collections.emptyList();
                return list;
            }
            List<IJstType> list = this.m_ts.getDirectDependents(typeName);
            return list;
        }
        finally {
            this.m_locker.releaseShared();
        }
    }

    public List<IJstType> findSubTypes(TypeName typeName) {
        try {
            this.m_locker.lockShared();
            IJstType type = this.m_ts.getType(typeName);
            if (type == null) {
                List<IJstType> list = Collections.emptyList();
                return list;
            }
            List<IJstType> dependents = this.m_ts.getDirectDependents(typeName);
            if (dependents.isEmpty()) {
                List<IJstType> list = Collections.emptyList();
                return list;
            }
            ArrayList<IJstType> subTypes = new ArrayList<IJstType>();
            for (IJstType dType : dependents) {
                if (!this.checkExtendsOrSatisfies(dType.getExtends(), type)) continue;
                subTypes.add(dType);
            }
            ArrayList<IJstType> arrayList = subTypes;
            return arrayList;
        }
        finally {
            this.m_locker.releaseShared();
        }
    }

    public List<IJstType> findAllDependentTypes(TypeName typeName) {
        try {
            this.m_locker.lockShared();
            IJstType type = this.m_ts.getType(typeName);
            List<IJstType> list = this.collectAllSubTypes(type, true);
            return list;
        }
        finally {
            this.m_locker.releaseShared();
        }
    }

    public List<IJstType> findAllSubTypes(TypeName typeName) {
        try {
            this.m_locker.lockShared();
            IJstType type = this.m_ts.getType(typeName);
            List<IJstType> list = this.collectAllSubTypes(type, false);
            return list;
        }
        finally {
            this.m_locker.releaseShared();
        }
    }

    private List<IJstType> collectAllSubTypes(IJstType type, boolean includeDependents) {
        String typeName;
        List<IJstType> dependents;
        String groupName = "";
        if (type.getPackage() != null) {
            groupName = type.getPackage().getGroupName();
        }
        if ((dependents = this.m_ts.getDirectDependents(new TypeName(groupName, typeName = type.getName()))).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IJstType> subTypes = new ArrayList<IJstType>();
        for (IJstType dType : dependents) {
            if (this.checkExtendsOrSatisfies(dType.getExtends(), type) || this.checkExtendsOrSatisfies(dType.getSatisfies(), type)) {
                subTypes.add(dType);
                subTypes.addAll(this.collectAllSubTypes(dType, includeDependents));
                continue;
            }
            if (!includeDependents) continue;
            subTypes.add(dType);
        }
        return subTypes;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkExtendsOrSatisfies(List<? extends IJstType> extendsOrSatisfies, IJstType type) {
        for (IJstType iJstType : extendsOrSatisfies) {
            void var3_4;
            if (iJstType instanceof JstProxyType) {
                IJstType iJstType2 = ((JstProxyType)iJstType).getType();
            }
            if (var3_4 != type) continue;
            return true;
        }
        return false;
    }

    public List<IJstType> findSatisfiers(TypeName typeName) {
        try {
            this.m_locker.lockShared();
            IJstType type = this.m_ts.getType(typeName);
            if (type == null || !type.isInterface()) {
                List<IJstType> list = Collections.emptyList();
                return list;
            }
            List<IJstType> dependents = this.m_ts.getDirectDependents(typeName);
            if (dependents.isEmpty()) {
                List<IJstType> list = Collections.emptyList();
                return list;
            }
            ArrayList<IJstType> satisfiers = new ArrayList<IJstType>();
            for (IJstType dType : dependents) {
                if (!this.checkExtendsOrSatisfies(dType.getSatisfies(), type)) continue;
                satisfiers.add(dType);
            }
            ArrayList<IJstType> arrayList = satisfiers;
            return arrayList;
        }
        finally {
            this.m_locker.releaseShared();
        }
    }

    public List<TypeName> findMissingTypes() {
        try {
            this.m_locker.lockShared();
            ArrayList<TypeName> list = new ArrayList<TypeName>();
            for (Map.Entry<String, DependencyNode<IJstType>> entry : this.m_ts.getUnresolvedNodes().entrySet()) {
                DependencyNode<IJstType> node = entry.getValue();
                String groupName = null;
                if (node.getEntity().getPackage() != null) {
                    groupName = node.getEntity().getPackage().getGroupName();
                }
                if (entry == null || entry.getKey() == null) continue;
                list.add(new TypeName(groupName, entry.getKey()));
            }
            ArrayList<TypeName> arrayList = list;
            return arrayList;
        }
        finally {
            this.m_locker.releaseShared();
        }
    }

    public Map<TypeName, List<IJstType>> findUnresolvedDependents() {
        try {
            this.m_locker.lockShared();
            LinkedHashMap<TypeName, List<IJstType>> map = new LinkedHashMap<TypeName, List<IJstType>>();
            for (Map.Entry<String, DependencyNode<IJstType>> entry : this.m_ts.getUnresolvedNodes().entrySet()) {
                ArrayList<IJstType> list = (ArrayList<IJstType>)map.get(entry.getKey());
                if (list == null) {
                    list = new ArrayList<IJstType>();
                    DependencyNode<IJstType> node = entry.getValue();
                    String groupName = null;
                    if (node.getEntity().getPackage() != null) {
                        groupName = node.getEntity().getPackage().getGroupName();
                    }
                    map.put(new TypeName(groupName, entry.getKey()), list);
                }
                for (DependencyNode<IJstType> dNode : entry.getValue().getDependents().values()) {
                    list.add(dNode.getEntity());
                }
            }
            LinkedHashMap<TypeName, List<IJstType>> linkedHashMap = map;
            return linkedHashMap;
        }
        finally {
            this.m_locker.releaseShared();
        }
    }

    public Map<PropertyName, List<IJstNode>> findPropertyUsagesWithinNode(IJstNode jstNode) {
        try {
            this.m_locker.lockShared();
            if (jstNode == null) {
                Map<PropertyName, List<IJstNode>> map = Collections.emptyMap();
                return map;
            }
            PropertyDependencyVisitor visitor = new PropertyDependencyVisitor();
            visitor.setTypeSpace(this.m_ts);
            JstDepthFirstTraversal.accept(jstNode, (IJstVisitor)visitor);
            Map<PropertyName, List<IJstNode>> map = visitor.getPropertyDependencies();
            return map;
        }
        finally {
            this.m_locker.releaseShared();
        }
    }

    public List<IJstNode> findPropertyDependentNodes(PropertyName name) {
        try {
            this.m_locker.lockShared();
            if (name == null) {
                List<IJstNode> list = Collections.emptyList();
                return list;
            }
            PropertyIndex<IJstType, IJstNode> index = this.m_ts.getPropertyIndex(name.typeName());
            if (index == null) {
                List<IJstNode> list = Collections.emptyList();
                return list;
            }
            ArrayList<IJstNode> list = new ArrayList<IJstNode>();
            for (IJstNode dNode : index.getDependents(name.propertyName())) {
                if (list.contains(dNode)) continue;
                list.add(dNode);
            }
            ArrayList<IJstNode> arrayList = list;
            return arrayList;
        }
        finally {
            this.m_locker.releaseShared();
        }
    }

    public List<IJstType> findPropertyDependentTypes(PropertyName name) {
        try {
            this.m_locker.lockShared();
            if (name == null) {
                List<IJstType> list = Collections.emptyList();
                return list;
            }
            PropertyIndex<IJstType, IJstNode> index = this.m_ts.getPropertyIndex(name.typeName());
            if (index == null) {
                List<IJstType> list = Collections.emptyList();
                return list;
            }
            ArrayList<IJstType> list = new ArrayList<IJstType>();
            for (IJstNode dNode : index.getDependents(name.propertyName())) {
                IJstType ownerType = dNode.getOwnerType();
                if (ownerType == null || list.contains(ownerType)) continue;
                list.add(ownerType);
            }
            ArrayList<IJstType> arrayList = list;
            return arrayList;
        }
        finally {
            this.m_locker.releaseShared();
        }
    }

    public List<PropertyName> findUnresolvedProperties(TypeName typeName) {
        try {
            this.m_locker.lockShared();
            if (typeName == null) {
                List<PropertyName> list = Collections.emptyList();
                return list;
            }
            ArrayList<PropertyName> list = new ArrayList<PropertyName>();
            block4: for (Map.Entry<PropertyName, List<IJstNode>> entry : this.m_ts.getUnresolvedPropertyDependents().entrySet()) {
                for (IJstNode dNode : entry.getValue()) {
                    if (!typeName.typeName().equals(dNode.getOwnerType().getName())) continue;
                    list.add(entry.getKey());
                    continue block4;
                }
            }
            ArrayList<PropertyName> arrayList = list;
            return arrayList;
        }
        finally {
            this.m_locker.releaseShared();
        }
    }

    public Map<MethodName, List<IJstNode>> findMethodUsagesWithinNode(IJstNode jstNode) {
        try {
            this.m_locker.lockShared();
            if (jstNode == null) {
                Map<MethodName, List<IJstNode>> map = Collections.emptyMap();
                return map;
            }
            MethodDependencyVisitor visitor = new MethodDependencyVisitor();
            visitor.setTypeSpace(this.m_ts);
            JstDepthFirstTraversal.accept(jstNode, (IJstVisitor)visitor);
            Map<MethodName, List<IJstNode>> map = visitor.getMethodDependencies();
            return map;
        }
        finally {
            this.m_locker.releaseShared();
        }
    }

    public List<IJstNode> findMethodDependentNodes(MethodName name) {
        try {
            this.m_locker.lockShared();
            if (name == null) {
                List<IJstNode> list = Collections.emptyList();
                return list;
            }
            MethodIndex<IJstType, IJstNode> index = this.m_ts.getMethodIndex(name.typeName());
            if (index == null) {
                List<IJstNode> list = Collections.emptyList();
                return list;
            }
            ArrayList<IJstNode> list = new ArrayList<IJstNode>();
            for (IJstNode dNode : index.getDependents(name.methodName())) {
                if (list.contains(dNode)) continue;
                list.add(dNode);
            }
            ArrayList<IJstNode> arrayList = list;
            return arrayList;
        }
        finally {
            this.m_locker.releaseShared();
        }
    }

    public List<IJstType> findMethodDependentTypes(MethodName name) {
        try {
            this.m_locker.lockShared();
            if (name == null) {
                List<IJstType> list = Collections.emptyList();
                return list;
            }
            MethodIndex<IJstType, IJstNode> index = this.m_ts.getMethodIndex(name.typeName());
            if (index == null) {
                List<IJstType> list = Collections.emptyList();
                return list;
            }
            ArrayList<IJstType> list = new ArrayList<IJstType>();
            for (IJstNode dNode : index.getDependents(name.methodName())) {
                IJstType ownerType = dNode.getOwnerType();
                if (ownerType == null || list.contains(ownerType)) continue;
                list.add(ownerType);
            }
            ArrayList<IJstType> arrayList = list;
            return arrayList;
        }
        finally {
            this.m_locker.releaseShared();
        }
    }

    public List<MethodName> findUnresolvedMethods(TypeName typeName) {
        try {
            this.m_locker.lockShared();
            if (typeName == null) {
                List<MethodName> list = Collections.emptyList();
                return list;
            }
            ArrayList<MethodName> list = new ArrayList<MethodName>();
            block4: for (Map.Entry<MethodName, List<IJstNode>> entry : this.m_ts.getUnresolvedMethodDependents().entrySet()) {
                for (IJstNode dNode : entry.getValue()) {
                    if (!typeName.typeName().equals(dNode.getOwnerType().getName())) continue;
                    list.add(entry.getKey());
                    continue block4;
                }
            }
            ArrayList<MethodName> arrayList = list;
            return arrayList;
        }
        finally {
            this.m_locker.releaseShared();
        }
    }

    public Map<MethodName, List<IJstNode>> buildReferencesForTypeMethods(IJstType type) {
        HashMap<MethodName, List<IJstNode>> usages = new HashMap<MethodName, List<IJstNode>>();
        this.build_references_for_type_symbols(type, usages, true);
        return usages;
    }

    public Map<PropertyName, List<IJstNode>> buildReferencesForTypeProperties(IJstType type) {
        HashMap<PropertyName, List<IJstNode>> usages = new HashMap<PropertyName, List<IJstNode>>();
        this.build_references_for_type_symbols(type, usages, false);
        return usages;
    }

    private <T extends ISymbolName> void build_references_for_type_symbols(IJstType type, Map<T, List<IJstNode>> map, boolean for_methods) {
        for (IJstType t : this.m_ts.enumerateTypes()) {
            Map<ISymbolName, List<IJstNode>> usages = for_methods ? this.findMethodUsagesWithinNode(t) : this.findPropertyUsagesWithinNode(t);
            for (Map.Entry<ISymbolName, List<IJstNode>> entry : usages.entrySet()) {
                ISymbolName symbol = entry.getKey();
                if (!symbol.getOwnerTypeName().equals(type.getName())) continue;
                List<IJstNode> l = map.get(symbol);
                if (l == null) {
                    l = new ArrayList<IJstNode>();
                    map.put(symbol, l);
                }
                l.addAll((Collection<IJstNode>)entry.getValue());
            }
        }
    }

    public boolean hasGlobalExtension(String globalVarName) {
        return this.m_ts.hasGlobalExtension(globalVarName);
    }

    public List<IJstNode> getGlobalExtensions(String globalVarName) {
        return this.m_ts.getGlobalExtensions(globalVarName);
    }

    public Map<String, IJstType> findAllVisibleAliasNames(String groupName) {
        IGroup fromGroup = this.m_ts.getGroup(groupName);
        return this.m_ts.getAllVisibleAliasNames(fromGroup);
    }
}

