/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.ts.event.dispatch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.jst.ts.TypeSpaceConfig;
import org.eclipse.vjet.dsf.ts.event.EventListenerStatus;
import org.eclipse.vjet.dsf.ts.event.ITypeSpaceEvent;
import org.eclipse.vjet.dsf.ts.event.ITypeSpaceEventListener;

public class TypeSpaceEventDispatcher {
    private List<ITypeSpaceEventListener> m_tsEventListeners = new ArrayList<ITypeSpaceEventListener>();
    private boolean m_synchronous_events = false;

    public synchronized void addListener(ITypeSpaceEventListener listener) {
        if (listener != null && !this.m_tsEventListeners.contains(listener)) {
            this.m_tsEventListeners.add(listener);
        }
    }

    public synchronized void removeListener(ITypeSpaceEventListener listener) {
        this.m_tsEventListeners.remove(listener);
    }

    public void dispatch(ITypeSpaceEvent event, EventListenerStatus status) {
        for (ITypeSpaceEventListener listener : this.getListeners(true)) {
            if (!event.isAppropriateListener(listener)) continue;
            this.run(event, listener, status);
        }
    }

    private synchronized List<ITypeSpaceEventListener> getListeners(boolean readOnly) {
        if (readOnly) {
            return Collections.unmodifiableList(this.m_tsEventListeners);
        }
        return this.m_tsEventListeners;
    }

    private void run(final ITypeSpaceEvent event, final ITypeSpaceEventListener listener, final EventListenerStatus status) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    event.dispatch(listener, status);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        if (this.m_synchronous_events) {
            r.run();
        } else {
            new Thread(r).start();
        }
    }

    public void setConfig(TypeSpaceConfig config) {
        this.m_synchronous_events = config.isSynchronousEvents();
    }
}

