/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.ts.group;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.ts.group.Group;

public class GroupDependencyNode<T> {
    private Map<String, GroupDependencyNode<T>> m_dependencyGroups = new LinkedHashMap<String, GroupDependencyNode<T>>();
    private Map<String, GroupDependencyNode<T>> m_dependentGroups = new LinkedHashMap<String, GroupDependencyNode<T>>();
    private Group<T> m_group;
    private String m_groupName;

    public GroupDependencyNode(String name) {
        this.m_groupName = name;
        this.m_group = null;
    }

    public void setGroup(Group<T> group) {
        this.m_group = group;
    }

    public Group<T> getGroup() {
        return this.m_group;
    }

    public String getGroupName() {
        return this.m_groupName;
    }

    public synchronized void addDependency(GroupDependencyNode<T> node) {
        this.m_dependencyGroups.put(node.getGroupName(), node);
    }

    public synchronized void addDependent(GroupDependencyNode<T> node) {
        this.m_dependentGroups.put(node.getGroupName(), node);
    }

    public synchronized Map<String, GroupDependencyNode<T>> getDependencies() {
        if (this.m_dependencyGroups == null || this.m_dependencyGroups.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.m_dependencyGroups);
    }

    public synchronized Map<String, GroupDependencyNode<T>> getDependents() {
        if (this.m_dependentGroups == null || this.m_dependentGroups.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.m_dependentGroups);
    }

    public synchronized void removeDependency(GroupDependencyNode<T> node) {
        assert (node != null) : "node cannot be null";
        if (this.m_dependencyGroups != null) {
            this.m_dependencyGroups.remove(node.getGroupName());
        }
    }

    public synchronized void removeDependent(GroupDependencyNode<T> node) {
        assert (node != null) : "node cannot be null";
        if (this.m_dependentGroups != null) {
            this.m_dependentGroups.remove(node.getGroupName());
        }
    }
}

