/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StringUtils {
    public static List<String> splitStr(String str, char delimiter) {
        return StringUtils.splitStr(str, delimiter, false);
    }

    public static List<String> splitStr(String str, char delimiter, boolean trim) {
        int startPos = 0;
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == delimiter) {
                String subStr = str.substring(startPos, i);
                if (trim) {
                    subStr = subStr.trim();
                }
                result.add(subStr);
                startPos = i + 1;
            }
            ++i;
        }
        if (startPos < str.length()) {
            String subStr = str.substring(startPos, str.length());
            if (trim) {
                subStr = subStr.trim();
            }
            result.add(subStr);
        }
        return result;
    }

    public static String join(Iterable<String> iterable, String joinString) {
        return StringUtils.join(iterable.iterator(), joinString);
    }

    public static String join(Iterator<String> iterator, String joinString) {
        StringBuilder buf = new StringBuilder();
        StringUtils.join(iterator, joinString, buf);
        String resultString = buf.toString();
        return resultString;
    }

    public static void join(Iterable<String> iterator, String joinString, StringBuilder stringStream) {
        StringUtils.join(iterator.iterator(), joinString, stringStream);
    }

    public static void join(Iterator<String> iterator, String joinString, StringBuilder stringStream) {
        while (iterator.hasNext()) {
            String string = iterator.next();
            stringStream.append(string);
            if (!iterator.hasNext()) continue;
            stringStream.append(joinString);
        }
    }
}

