/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.trace.introspect;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.vjet.dsf.common.trace.introspect.ITraceObjectIntrospector;
import org.eclipse.vjet.dsf.common.trace.introspect.ITraceable;
import org.eclipse.vjet.dsf.common.xml.IXmlStreamWriter;
import org.eclipse.vjet.dsf.common.xml.XmlEncoder;

public class DefaultTraceIntrospector
implements ITraceObjectIntrospector {
    public static final int MAX_DEPTH_THROTTLE = 10;
    public static final int MAX_COLLECTION_SIZE_THROTTLE = 50;
    private static Logger s_logger = Logger.getLogger(DefaultTraceIntrospector.class.getName());
    protected static final List<Class> s_primitiveTypes = new ArrayList<Class>(10);
    private static final List<String> s_includeStartWith;
    private static final List<String> s_excludedContainWith;
    protected static final String TAG_ENTRY = "Entry";
    protected static final String TAG_ARRAY = "Array";
    protected static final String ATTR_SIZE = "size";
    protected static final String CROSS_REF = "CROSS_REF";
    protected static final String INTROSPECT_CUTOFF = "INTROSPECT_CUTOFF";
    protected static final String CHILD_CUTOFF = "CHILD_CUTOFF";
    protected static final String SUPER_CUTOFF = "SUPER_CUTOFF";
    protected static final String ITEM_MORE = "...";
    protected static final String NULL_MARK = "null";
    protected static final String NULL_TAG = "NULL";
    protected int m_maxDepth = 10;
    protected List<Object> m_objs = new ArrayList<Object>(10);

    static {
        s_primitiveTypes.add(String.class);
        s_primitiveTypes.add(Boolean.class);
        s_primitiveTypes.add(Integer.class);
        s_primitiveTypes.add(Long.class);
        s_primitiveTypes.add(Float.class);
        s_primitiveTypes.add(Double.class);
        s_primitiveTypes.add(Date.class);
        s_includeStartWith = new ArrayList<String>(10);
        s_includeStartWith.add("m_");
        s_includeStartWith.add("s_");
        s_excludedContainWith = new ArrayList<String>(10);
        s_excludedContainWith.add("Logger");
        s_excludedContainWith.add("logger");
        s_excludedContainWith.add("Helper");
        s_excludedContainWith.add("helper");
    }

    public DefaultTraceIntrospector() {
    }

    public DefaultTraceIntrospector(int maxDepth) {
        if (maxDepth > 0 && maxDepth < 10) {
            this.m_maxDepth = maxDepth;
        }
    }

    @Override
    public void writeState(Object obj, IXmlStreamWriter writer) {
        try {
            this.m_objs.clear();
            this.writeObjectValue(obj, writer, 0);
        }
        catch (Throwable t) {
            s_logger.log(Level.SEVERE, "could not write state", t);
        }
    }

    private void writeObjectValue(Object obj, IXmlStreamWriter writer, int curDepth) {
        if (obj == null) {
            return;
        }
        if (this.m_objs.contains(obj)) {
            writer.writeRaw(CROSS_REF);
            return;
        }
        if (curDepth >= this.m_maxDepth) {
            writer.writeStartElement(CHILD_CUTOFF);
            writer.writeEndElement();
            return;
        }
        if (obj.getClass().isArray()) {
            return;
        }
        this.m_objs.add(obj);
        Class<?> type = obj.getClass();
        writer.writeStartElement(type.getSimpleName());
        if (obj instanceof ITraceable) {
            ((ITraceable)obj).writeState(writer);
        } else if (type.isPrimitive() || s_primitiveTypes.contains(type)) {
            writer.writeCharacters(XmlEncoder.encode(obj.toString()));
        } else if (List.class.isAssignableFrom(type)) {
            List list = (List)obj;
            int size = list.size();
            writer.writeAttribute(ATTR_SIZE, String.valueOf(size));
            int counter = 0;
            for (Object item : list) {
                if (counter > 50) {
                    writer.writeCharacters(ITEM_MORE);
                    break;
                }
                this.writeObjectValue(item, writer, curDepth + 1);
                ++counter;
            }
        } else if (Map.class.isAssignableFrom(type)) {
            Map map = (Map)obj;
            int size = map.size();
            int counter = 0;
            writer.writeAttribute(ATTR_SIZE, String.valueOf(size));
            for (Map.Entry entry : map.entrySet()) {
                if (counter > 50) {
                    writer.writeCharacters(ITEM_MORE);
                    break;
                }
                writer.writeStartElement(TAG_ENTRY);
                this.writeObjectValue(entry.getKey(), writer, curDepth + 1);
                this.writeObjectValue(entry.getValue(), writer, curDepth + 1);
                writer.writeEndElement();
                ++counter;
            }
        } else {
            Field[] fields = type.getDeclaredFields();
            if (fields != null && fields.length > 0) {
                Field[] fieldArray = fields;
                int entry = fields.length;
                int counter = 0;
                while (counter < entry) {
                    Field f = fieldArray[counter];
                    this.writeFieldValue(f, obj, writer, curDepth);
                    ++counter;
                }
            }
            Class<?> superType = type.getSuperclass();
            int superLevel = 0;
            while (superType != null && superType != Object.class) {
                if (++superLevel > this.m_maxDepth) {
                    writer.writeStartElement(SUPER_CUTOFF);
                    writer.writeEndElement();
                    break;
                }
                fields = superType.getDeclaredFields();
                if (fields != null && fields.length > 0) {
                    Field[] fieldArray = fields;
                    int n = fields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Field f = fieldArray[n2];
                        this.writeFieldValue(f, obj, writer, curDepth);
                        ++n2;
                    }
                }
                superType = superType.getSuperclass();
            }
        }
        writer.writeEndElement();
    }

    private void writeFieldValue(Field field, Object obj, IXmlStreamWriter writer, int curDepth) {
        String name = field.getName();
        if (!this.includeField(name)) {
            return;
        }
        Class<?> type = field.getType();
        writer.writeStartElement(name);
        field.setAccessible(true);
        try {
            try {
                Object value = field.get(obj);
                if (value == null) {
                    writer.writeRaw(NULL_MARK);
                } else if (type.isPrimitive() || s_primitiveTypes.contains(type)) {
                    writer.writeCharacters(XmlEncoder.encode(value.toString()));
                } else {
                    this.writeObjectValue(value, writer, curDepth + 1);
                }
            }
            catch (IllegalArgumentException e) {
                s_logger.log(Level.SEVERE, "", e);
                writer.writeEndElement();
            }
            catch (IllegalAccessException e) {
                s_logger.log(Level.SEVERE, "", e);
                writer.writeEndElement();
            }
        }
        finally {
            writer.writeEndElement();
        }
    }

    private boolean includeField(String name) {
        if (name == null) {
            return false;
        }
        for (String fragment : s_excludedContainWith) {
            if (!name.contains(fragment)) continue;
            return false;
        }
        for (String prefix : s_includeStartWith) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

