/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.logger;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ErrorsInfo
implements Serializable {
    private List<String> m_errorsLogged = null;
    private boolean m_errorPage = false;
    private boolean m_isErrorEventLogged = false;
    private static final long serialVersionUID = -7404801190649016889L;

    public void addErrorLog(String error) {
        if (error == null || error.length() == 0) {
            return;
        }
        if (this.getErrorsList().size() < 5 && !this.getErrorsList().contains(error)) {
            this.getErrorsList().add(error);
        }
    }

    public void setErrorPage() {
        this.m_errorPage = true;
    }

    public boolean isErrorPage() {
        return this.m_errorPage;
    }

    public boolean isErrorEventLogged() {
        return this.m_isErrorEventLogged;
    }

    public String getFirstErrorLogged() {
        String first;
        String firstErrorLogged = "";
        List<String> errorsLogged = this.getErrorsList();
        if (errorsLogged != null && errorsLogged.size() > 0 && (first = errorsLogged.get(0)) != null) {
            firstErrorLogged = first;
        }
        return firstErrorLogged;
    }

    public String getAllErrorsLogged() {
        StringBuilder buffer = this.getAllErrorsLoggedRB();
        if (buffer != null && buffer.length() > 0) {
            return buffer.toString();
        }
        return "";
    }

    public String getAllErrorsLoggedStatusForCAL() {
        String allErrorsLogged = "NoErrorLogged";
        StringBuilder buffer = this.getAllErrorsLoggedRB();
        if (buffer == null) {
            return allErrorsLogged;
        }
        int bLen = buffer.length();
        if (bLen > 128) {
            allErrorsLogged = buffer.substring(0, 128);
        } else if (bLen > 0) {
            allErrorsLogged = buffer.toString();
        }
        return allErrorsLogged;
    }

    private StringBuilder getAllErrorsLoggedRB() {
        int size = this.getErrorsList().size();
        if (size == 0) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < size) {
            buffer.append(this.getErrorsList().get(i)).append(";");
            ++i;
        }
        return buffer;
    }

    public boolean hasErrors() {
        return this.getErrorsList().size() > 0;
    }

    private List<String> getErrorsList() {
        if (this.m_errorsLogged == null) {
            this.m_errorsLogged = new ArrayList<String>(3);
        }
        return this.m_errorsLogged;
    }
}

