/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.logger;

import java.util.logging.Level;

public enum LogLevel {
    DEFAULT(-1, null),
    DEBUG(0, Level.FINE),
    INFO(1, Level.INFO),
    WARN(2, Level.WARNING),
    ERROR(3, Level.SEVERE),
    FATAL(4, EbayLogLevelExtension.FATAL),
    CONFIG(5, Level.CONFIG),
    FINE(6, Level.FINE),
    FINER(7, Level.FINER),
    FINEST(8, Level.FINEST),
    ALL(9, Level.ALL),
    OFF(10, Level.OFF);

    private Level m_level;
    private int m_ebayLevel;

    private LogLevel(int ebayLevel, Level level) {
        this.m_ebayLevel = ebayLevel;
        this.m_level = level;
    }

    public Level getLevel() {
        return this.m_level;
    }

    public int getLevelValue() {
        return this.m_level.intValue();
    }

    public int getEbayLevelValue() {
        return this.m_ebayLevel;
    }

    private static class EbayLogLevelExtension
    extends Level {
        public static final Level FATAL = new EbayLogLevelExtension("FATAL", 1100);
        private static final long serialVersionUID = 9149560934874662806L;

        protected EbayLogLevelExtension(String name, int value) {
            super(name, value, null);
        }
    }
}

