/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.logger;

import org.eclipse.vjet.dsf.logger.ErrorsInfo;
import org.eclipse.vjet.dsf.logger.LoggingInfo;

public class LoggingContext {
    private static final String DEFAULT_CONTEXT = "context is not set";
    private static ThreadLocalContext s_context = new ThreadLocalContext();
    private LoggingInfo m_primary = null;
    private LoggingInfo m_secondary = null;
    private ErrorsInfo m_errorsInfo = null;
    private String m_lastLoggedMessage = null;
    private String m_calStatus = null;
    private String m_sourceName = null;
    private ContextLoggingOption m_contextLoggingOption = ContextLoggingOption.DEFAULT;
    private boolean m_isSuccessCalTransactionTree = true;

    private LoggingContext() {
    }

    public static void resetContext() {
        LoggingContext loggingContext = LoggingContext.getContext();
        loggingContext.m_primary = null;
        loggingContext.m_secondary = null;
        loggingContext.m_errorsInfo = null;
        loggingContext.m_lastLoggedMessage = null;
        loggingContext.m_contextLoggingOption = ContextLoggingOption.DEFAULT;
        loggingContext.m_calStatus = null;
        loggingContext.m_sourceName = null;
        loggingContext.m_isSuccessCalTransactionTree = true;
    }

    public static void setPrimary(LoggingInfo info) {
        LoggingContext loggingContext = LoggingContext.getContext();
        loggingContext.m_primary = info;
        loggingContext.m_secondary = null;
    }

    public static void setSecondary(LoggingInfo info) {
        LoggingContext loggingContext = LoggingContext.getContext();
        loggingContext.m_secondary = info;
    }

    public static boolean isDefaultContext(String context) {
        return context == DEFAULT_CONTEXT;
    }

    public static String getContextInfo() {
        LoggingContext loggingContext = LoggingContext.getContext();
        if (loggingContext.m_secondary != null) {
            return loggingContext.m_secondary.getContent();
        }
        if (loggingContext.m_primary != null) {
            return loggingContext.m_primary.getContent();
        }
        return DEFAULT_CONTEXT;
    }

    public static ErrorsInfo getErrorsInfo() {
        LoggingContext loggingContext = LoggingContext.getContext();
        if (loggingContext != null) {
            if (loggingContext.m_errorsInfo == null) {
                loggingContext.m_errorsInfo = new ErrorsInfo();
            }
            return loggingContext.m_errorsInfo;
        }
        return new ErrorsInfo();
    }

    public static void clearErrorsInfo() {
        LoggingContext loggingContext = LoggingContext.getContext();
        if (loggingContext != null) {
            loggingContext.m_errorsInfo = null;
        }
    }

    public static LoggingInfo getPrimary() {
        LoggingInfo loggingInfo = null;
        LoggingContext loggingContext = LoggingContext.getContext();
        if (loggingContext != null) {
            loggingInfo = loggingContext.m_primary;
        }
        return loggingInfo;
    }

    public static String getLastLoggedMessage() {
        LoggingContext loggingContext = LoggingContext.getContext();
        return loggingContext.m_lastLoggedMessage;
    }

    public static void setLastLoggedMessage(String lastLoggedMessage) {
        LoggingContext loggingContext = LoggingContext.getContext();
        loggingContext.m_lastLoggedMessage = lastLoggedMessage;
    }

    public static ContextLoggingOption getContextLoggingOption() {
        LoggingContext loggingContext = LoggingContext.getContext();
        return loggingContext.m_contextLoggingOption;
    }

    public static void setContextLoggingOption(ContextLoggingOption state) {
        LoggingContext loggingContext = LoggingContext.getContext();
        loggingContext.m_contextLoggingOption = state;
    }

    public static String getCalStatus() {
        LoggingContext loggingContext = LoggingContext.getContext();
        return loggingContext.m_calStatus;
    }

    public static void setCalStatus(String calStatus) {
        LoggingContext loggingContext = LoggingContext.getContext();
        loggingContext.m_calStatus = calStatus;
    }

    public static String getSourceName() {
        LoggingContext loggingContext = LoggingContext.getContext();
        return loggingContext.m_sourceName;
    }

    public static void setSourceName(String sourceName) {
        LoggingContext loggingContext = LoggingContext.getContext();
        loggingContext.m_sourceName = sourceName;
    }

    public static void setFailureOnCalTransactionTree() {
        LoggingContext loggingContext = LoggingContext.getContext();
        if (loggingContext != null) {
            loggingContext.m_isSuccessCalTransactionTree = false;
        }
    }

    public static boolean isSuccessCalTransactionTree() {
        LoggingContext loggingContext = LoggingContext.getContext();
        if (loggingContext != null) {
            return loggingContext.m_isSuccessCalTransactionTree;
        }
        return true;
    }

    private static LoggingContext getContext() {
        return (LoggingContext)s_context.get();
    }

    public static String getCommandName() {
        String COMMAND_NAME = "Command Name: ";
        String NO_COMMAND = "NO_COMMAND";
        String context = LoggingContext.getContextInfo();
        if (context == null) {
            return NO_COMMAND;
        }
        int pCommand = context.indexOf(COMMAND_NAME);
        if (pCommand == -1) {
            return NO_COMMAND;
        }
        if (pCommand + COMMAND_NAME.length() >= context.length()) {
            return NO_COMMAND;
        }
        int pNewline = context.indexOf("\n", pCommand);
        if (pNewline == -1) {
            return context.substring(pCommand + COMMAND_NAME.length());
        }
        return context.substring(pCommand + COMMAND_NAME.length(), pNewline);
    }

    /* synthetic */ LoggingContext(LoggingContext loggingContext) {
        this();
    }

    public static enum ContextLoggingOption {
        DEFAULT,
        ON,
        OFF;

    }

    private static class ThreadLocalContext
    extends InheritableThreadLocal<LoggingContext> {
        private ThreadLocalContext() {
        }

        @Override
        protected LoggingContext initialValue() {
            return new LoggingContext(null);
        }

        @Override
        protected LoggingContext childValue(LoggingContext parentValue) {
            LoggingContext parentContext = parentValue;
            LoggingContext childContext = new LoggingContext(null);
            childContext.m_primary = parentContext.m_primary;
            childContext.m_secondary = parentContext.m_secondary;
            return childContext;
        }
    }
}

