/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.lib;

import org.eclipse.vjet.dsf.jst.IJstGlobalVar;
import org.eclipse.vjet.dsf.jst.IJstLib;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.ts.JstTypeSpaceMgr;
import org.eclipse.vjet.dsf.ts.ITypeSpace;
import org.eclipse.vjet.dsf.ts.type.TypeName;
import org.eclipse.vjet.vjo.lib.LibManager;

public class TsLibLoader {
    public static void loadDefaultLibs(JstTypeSpaceMgr tsMgr) {
        TsLibLoader.loadJavaPrimitiveLib(tsMgr);
        TsLibLoader.loadJsNativeGlobalLib(tsMgr);
        TsLibLoader.loadBrowserTypesLib(tsMgr);
        TsLibLoader.loadVjoLib(tsMgr);
        TsLibLoader.promoteGlobals(tsMgr);
    }

    private static void promoteGlobals(JstTypeSpaceMgr jstTypeSpaceMgr) {
        ITypeSpace typeSpace = jstTypeSpaceMgr.getTypeSpace();
        typeSpace.addAllGlobalTypeMembers(new TypeName("JsNativeLib", "Global"));
        typeSpace.addAllGlobalTypeMembers(new TypeName("JsBrowserLib", "Window"));
        IJstType window = (IJstType)typeSpace.getType(new TypeName("JsBrowserLib", "Window"));
        for (IJstGlobalVar gvar : window.getGlobalVars()) {
            String groupName = window.getPackage().getGroupName();
            typeSpace.addToGlobalSymbolMap(groupName, gvar.getName().getName(), gvar.getOwnerType().getName(), (Object)gvar);
        }
    }

    public static boolean isDefaultLibName(String libName) {
        return libName.equals("JsNativeLib") || libName.equals("JavaPrimitive") || libName.equals("JsBrowserLib") || libName.equals("VjoSelfDescribed");
    }

    private static void loadVjoLib(JstTypeSpaceMgr tsMgr) {
        IJstLib lib = LibManager.getInstance().getVjoSelfDescLib();
        JstCache.getInstance().addLib(lib);
        tsMgr.loadLibrary(lib, "VjoSelfDescribed");
    }

    private static void loadVjoLangLib(JstTypeSpaceMgr tsMgr) {
        IJstLib lib = LibManager.getInstance().getVjoSelfDescLib();
        JstCache.getInstance().addLib(lib);
        tsMgr.loadLibrary(lib, "VjoJavaLib");
    }

    public static void loadJavaPrimitiveLib(JstTypeSpaceMgr tsMgr) {
        IJstLib lib = LibManager.getInstance().getJavaPrimitiveLib();
        JstCache.getInstance().addLib(lib);
        tsMgr.loadLibrary(lib, "JavaPrimitive");
    }

    public static void loadBrowserTypesLib(JstTypeSpaceMgr tsMgr) {
        IJstLib lib = LibManager.getInstance().getBrowserTypesLib();
        JstCache.getInstance().addLib(lib);
        tsMgr.loadLibrary(lib, "JsBrowserLib");
    }

    public static void loadJsNativeGlobalLib(JstTypeSpaceMgr tsMgr) {
        IJstLib lib = LibManager.getInstance().getJsNativeGlobalLib();
        JstCache.getInstance().addLib(lib);
        tsMgr.loadLibrary(lib, "JsNativeLib");
    }

    public static String[] getDefaultLibNames() {
        return new String[]{"JavaPrimitive", "JsNativeLib", "JsBrowserLib", "VjoSelfDescribed"};
    }

    public static String[] getJsNativeGroups() {
        return new String[]{"JavaPrimitive", "JsNativeLib"};
    }

    public static String[] getBrowserGroups() {
        return new String[]{"JsBrowserLib"};
    }

    public static String[] getVjoGroups() {
        return new String[]{"VjoSelfDescribed"};
    }
}

