/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.tool.codecompletion.advisor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;
import org.eclipse.vjet.vjo.tool.codecompletion.CodeCompletionUtils;
import org.eclipse.vjet.vjo.tool.codecompletion.IVjoCcAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.VjoCcCtx;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.AbstractVjoCcAdvisor;

public class VjoCcOuterPropMethodProposalAdvisor
extends AbstractVjoCcAdvisor
implements IVjoCcAdvisor {
    public static final String ID = VjoCcOuterPropMethodProposalAdvisor.class.getName();

    @Override
    public void advise(VjoCcCtx ctx) {
        String token = ctx.getActingToken();
        IJstType callingType = ctx.getActingType();
        IJstType calledType = ctx.getCalledType();
        if (calledType != null && callingType != calledType) {
            return;
        }
        IJstNode outer = callingType.getParentNode();
        if (outer == null || !(outer instanceof IJstType)) {
            return;
        }
        String innerName = callingType.getName();
        boolean isStatic = callingType.getModifiers().isStatic();
        calledType = callingType = (IJstType)outer;
        this.appendStaticMembers(calledType, callingType, token, innerName, ctx);
        if (!isStatic) {
            this.appendInstanceMembers(calledType, callingType, token, innerName, ctx);
        }
    }

    private void appendInstanceMembers(IJstType calledType, IJstType callingType, String token, String innerName, VjoCcCtx ctx) {
        boolean isNative = CodeCompletionUtils.isNativeType(calledType);
        IJstType tempCalledType = calledType;
        int[] levels = this.getCallLevel(callingType, calledType);
        ArrayList<String> tempString = new ArrayList<String>();
        List methods = JstTypeHelper.getSignatureMethods((IJstType)calledType, (boolean)false, (boolean)true);
        for (IJstMethod method : methods) {
            boolean exactMatch;
            if (tempCalledType != method.getOwnerType()) {
                tempCalledType = method.getOwnerType();
                if (tempCalledType == null) {
                    tempCalledType = calledType;
                }
                levels = this.getCallLevel(callingType, tempCalledType);
                isNative = CodeCompletionUtils.isNativeType(tempCalledType);
            }
            boolean basicMatch = exactMatch = this.exactMatch(method.getName().getName(), token);
            if (!exactMatch) {
                basicMatch = this.basicMatch(method.getName().getName(), token);
            }
            if (!exactMatch && !basicMatch) continue;
            this.addMethod(method, levels, isNative, ctx, tempString, exactMatch);
        }
        List properties = calledType.getAllPossibleProperties(false, true);
        for (IJstProperty property : properties) {
            boolean exactMatch;
            if (tempCalledType != property.getOwnerType()) {
                tempCalledType = property.getOwnerType();
                levels = this.getCallLevel(callingType, tempCalledType);
                isNative = CodeCompletionUtils.isNativeType(tempCalledType);
            }
            boolean basicMatch = exactMatch = this.exactMatch(property.getName().getName(), token);
            if (!exactMatch) {
                basicMatch = this.basicMatch(property.getName().getName(), token);
            }
            if (!this.levelCheck(property.getModifiers(), levels) || !exactMatch && !basicMatch || isNative && property.getName().getName().startsWith("_")) continue;
            this.appendData(ctx, (IJstNode)property, exactMatch && basicMatch);
        }
    }

    private void appendStaticMembers(IJstType calledType, IJstType callingType, String token, String innerName, VjoCcCtx ctx) {
        IJstType tempCalledType = calledType;
        int[] levels = this.getCallLevel(callingType, calledType);
        List methods = JstTypeHelper.getSignatureMethods((IJstType)calledType, (boolean)true, (boolean)true);
        for (IJstMethod method : methods) {
            boolean exactMatch;
            if (tempCalledType != method.getOwnerType()) {
                tempCalledType = method.getOwnerType();
                if (tempCalledType == null) {
                    tempCalledType = calledType;
                }
                levels = this.getCallLevel(callingType, tempCalledType);
            }
            boolean basicMatch = exactMatch = this.exactMatch(method.getName().getName(), token);
            if (!exactMatch) {
                basicMatch = this.basicMatch(method.getName().getName(), token);
            }
            if (!this.levelCheck(method.getModifiers(), levels) || !exactMatch && !basicMatch) continue;
            this.appendData(ctx, (IJstNode)method, exactMatch && basicMatch);
        }
        List properties = calledType.getAllPossibleProperties(true, true);
        for (IJstProperty property : properties) {
            boolean exactMatch;
            if (tempCalledType != property.getOwnerType()) {
                tempCalledType = property.getOwnerType();
                levels = this.getCallLevel(callingType, tempCalledType);
            }
            boolean basicMatch = exactMatch = this.exactMatch(property.getName().getName(), token);
            if (!exactMatch) {
                basicMatch = this.basicMatch(property.getName().getName(), token);
            }
            if (!this.levelCheck(property.getModifiers(), levels) || !exactMatch && !basicMatch) continue;
            this.appendData(ctx, (IJstNode)property, exactMatch && basicMatch);
        }
    }

    private void addMethod(IJstMethod method, int[] levels, boolean isNative, VjoCcCtx ctx, List<String> tempString, boolean exactMatch) {
        String str;
        if (!(method.isConstructor() || !this.levelCheck(method.getModifiers(), levels) || isNative && method.getName().getName().startsWith("_") || tempString.contains(str = CodeCompletionUtils.getMthodsStr(method)))) {
            tempString.add(str);
            this.appendData(ctx, (IJstNode)method, exactMatch);
        }
    }

    @Override
    protected int[] getCallLevel(IJstType callingType, IJstType calledType) {
        return CodeCompletionUtils.getGeneralFieldCallLevel(callingType, calledType);
    }
}

