/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.tool.codecompletion.advisor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;
import org.eclipse.vjet.vjo.tool.codecompletion.CodeCompletionUtils;
import org.eclipse.vjet.vjo.tool.codecompletion.VjoCcCtx;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.AbstractVjoCcAdvisor;

public class VjoCcOverrideProposalAdvisor
extends AbstractVjoCcAdvisor {
    public static final String ID = VjoCcOverrideProposalAdvisor.class.getName();

    @Override
    public void advise(VjoCcCtx ctx) {
        String token = ctx.getToken();
        IJstType callingType = ctx.getJstType();
        List<String> tempList = this.getMethodsString(callingType);
        ArrayList<IJstType> interfaceList = new ArrayList<IJstType>();
        int[] levels = this.getCallLevel(null, null);
        IJstType parentType2 = callingType.getExtend();
        this.appendInterface(interfaceList, callingType);
        if (parentType2 != null) {
            this.addMethods(parentType2, levels, tempList, token, ctx, interfaceList);
        }
        if (!interfaceList.isEmpty()) {
            for (IJstType parentType2 : interfaceList) {
                this.addMethods(parentType2, levels, tempList, token, ctx, interfaceList);
            }
        }
    }

    private void appendInterface(List<IJstType> interfaceList, IJstType callingType) {
        if (callingType.isInterface()) {
            return;
        }
        List list = callingType.getSatisfies();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (IJstType temp : list) {
            if (interfaceList.contains(temp)) continue;
            interfaceList.add(temp);
        }
    }

    private void addMethods(IJstType parentType, int[] levels, List<String> tempList, String token, VjoCcCtx ctx, List<IJstType> interfaceList) {
        IJstType tempCalledType = parentType;
        this.appendInterface(interfaceList, tempCalledType);
        boolean isNative = CodeCompletionUtils.isNativeType(tempCalledType);
        List methods = JstTypeHelper.getSignatureMethods((IJstType)parentType, (boolean)false, (boolean)true);
        for (IJstMethod method : methods) {
            if (tempCalledType != method.getOwnerType()) {
                tempCalledType = method.getOwnerType();
                isNative = CodeCompletionUtils.isNativeType(tempCalledType);
                this.appendInterface(interfaceList, tempCalledType);
            }
            if (!method.getName().getName().startsWith(token) || method.isFinal() || method.isStatic()) continue;
            this.addMethod(method, tempList, levels, token, ctx, isNative);
        }
    }

    private void addMethod(IJstMethod method, List<String> tempList, int[] levels, String token, VjoCcCtx ctx, boolean isNative) {
        String tempStr;
        if (!(method.isConstructor() || !this.levelCheck(method.getModifiers(), levels) || isNative && method.getName().getName().startsWith("_") || tempList.contains(tempStr = CodeCompletionUtils.getMthodsStr(method)))) {
            tempList.add(tempStr);
            this.appendData(ctx, (IJstNode)method);
            if (token.equals(method.getName().getName())) {
                ctx.exactMatch(ID);
            }
        }
    }

    private List<String> getMethodsString(IJstType type) {
        List methods = type.getMethods(false, false);
        Iterator it = methods.iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            List overloads;
            IJstMethod method = (IJstMethod)it.next();
            String methodStr = CodeCompletionUtils.getMthodsStr(method);
            if (!list.contains(methodStr)) {
                list.add(methodStr);
            }
            if ((overloads = method.getOverloaded()) == null) continue;
            Iterator it1 = overloads.iterator();
            while (it1.hasNext()) {
                methodStr = CodeCompletionUtils.getMthodsStr((IJstMethod)it1.next());
                if (list.contains(methodStr)) continue;
                list.add(methodStr);
            }
        }
        return list;
    }

    @Override
    protected int[] getCallLevel(IJstType callingType, IJstType calledType) {
        return new int[]{1, 4};
    }
}

