/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.tool.codecompletion.advisor;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.declaration.VarTable;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jstojava.controller.JstExpressionTypeLinkerHelper;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.vjo.tool.codecompletion.IVjoCcAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.VjoCcCtx;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.AbstractVjoCcAdvisor;

public class VjoCcVariableProposalAdvisor
extends AbstractVjoCcAdvisor
implements IVjoCcAdvisor {
    public static final String ID = VjoCcVariableProposalAdvisor.class.getName();

    @Override
    public void advise(VjoCcCtx ctx) {
        List<IJstNode> selectedNodes = ctx.getSelectedJstNodes();
        if (selectedNodes.size() == 0) {
            IJstMethod method = ctx.getSelectedJstMethod();
            if (method == null) {
                return;
            }
            List<JstVars> vars = ctx.getJstVars(method);
            if (vars.isEmpty()) {
                return;
            }
            Iterator<JstVars> it = vars.iterator();
            List<String> argList = VjoCcCtx.getArgStringList(method);
            while (it.hasNext()) {
                JstVars var = it.next();
                List ass = var.getInitializer().getAssignments();
                if (ass == null) continue;
                for (AssignExpr assign : ass) {
                    ILHS lhs = assign.getLHS();
                    if (!lhs.toLHSText().startsWith(ctx.getActingToken()) || argList.contains(lhs.toLHSText())) continue;
                    this.appendData(ctx, (IJstNode)lhs);
                }
            }
            return;
        }
        IJstNode innerMostSelectedNode = null;
        while ((innerMostSelectedNode = selectedNodes.remove(selectedNodes.size() - 1)) == null && selectedNodes.size() > 0) {
        }
        if (innerMostSelectedNode == null) {
            return;
        }
        List varTables = JstExpressionTypeLinkerHelper.getVarTablesBottomUp((IJstNode)innerMostSelectedNode);
        HashSet<String> proposedVarNames = new HashSet<String>();
        for (VarTable varTable : varTables) {
            for (Map.Entry varEntry : varTable.getVarNodes().entrySet()) {
                String varName = (String)varEntry.getKey();
                if (varName.equals(ctx.getActingToken()) || !varName.startsWith(ctx.getActingToken()) || proposedVarNames.contains(varName)) continue;
                proposedVarNames.add(varName);
                IJstNode varBinding = (IJstNode)varEntry.getValue();
                if (varBinding == null || varBinding instanceof JstArg) continue;
                varBinding = this.renameBindings(varName, varBinding);
                this.appendData(ctx, varBinding);
            }
        }
    }

    private IJstNode renameBindings(String varName, IJstNode varBinding) {
        IJstMethod varBindingMtd;
        if (varBinding instanceof IJstProperty) {
            IJstProperty varBindingPty = (IJstProperty)varBinding;
            if (!varName.equals(varBindingPty.getName().getName())) {
                return new TranslateHelper.RenameableSynthJstProxyProp(varBindingPty, varName);
            }
        } else if (varBinding instanceof IJstMethod && !varName.equals((varBindingMtd = (IJstMethod)varBinding).getName().getName())) {
            return new TranslateHelper.RenameableSynthJstProxyMethod(varBindingMtd, varName);
        }
        return varBinding;
    }
}

