/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.tool.codecompletion.comment;

import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jsgen.shared.validation.common.ScopeId;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCommentCompletion;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.keyword.IVjoKeywordCompletionData;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.keyword.VjoKeywordFactory;

public class VjoCcCommentUtil {
    public static boolean isInactiveNeed(JstCommentCompletion completion) {
        if (completion == null) {
            return false;
        }
        String commentBeforCursor = completion.getCommentBeforeCursor();
        return commentBeforCursor.contains("needs");
    }

    public static boolean needProposal(JstCommentCompletion completion) {
        String commentBeforCursor = completion.getCommentBeforeCursor();
        return commentBeforCursor.contains("(") && !commentBeforCursor.contains(")");
    }

    public static ScopeId getScope(JstCommentCompletion completion) {
        if (completion.getScopeStack().isEmpty()) {
            return ScopeIds.GLOBAL;
        }
        return (ScopeId)completion.getScopeStack().peek();
    }

    public static boolean containsKeyword(JstCommentCompletion completion, IVjoKeywordCompletionData keyword) {
        String comment = completion.getCommentBeforeCursor();
        if (comment.contains(keyword.getName())) {
            return true;
        }
        if (VjoCcCommentUtil.isModifierKeyword(keyword)) {
            return VjoCcCommentUtil.checkModifierKeyword(comment);
        }
        if (VjoCcCommentUtil.isFinalKeyword(keyword)) {
            return VjoCcCommentUtil.checkFinalKeyword(comment);
        }
        return false;
    }

    public static boolean isAfterTypeRefKeyword(JstCommentCompletion completion) {
        String s = completion.getCommentBeforeCursor();
        return s.toLowerCase().contains(VjoKeywordFactory.KWD_TYPE.getName().toLowerCase());
    }

    private static boolean checkFinalKeyword(String comment) {
        return comment.contains(VjoKeywordFactory.KWD_ABSTRACT.getName()) || comment.contains(VjoKeywordFactory.KWD_FINAL.getName());
    }

    private static boolean isFinalKeyword(IVjoKeywordCompletionData keyword) {
        String name = keyword.getName();
        return VjoKeywordFactory.KWD_ABSTRACT.getName().equals(name) || VjoKeywordFactory.KWD_FINAL.getName().equals(name);
    }

    private static boolean checkModifierKeyword(String comment) {
        return comment.contains(VjoKeywordFactory.KWD_PUBLIC.getName()) || comment.contains(VjoKeywordFactory.KWD_PROTECTED.getName()) || comment.contains(VjoKeywordFactory.KWD_PRIVATE.getName()) || comment.contains(VjoKeywordFactory.KWD_NEEDS.getName());
    }

    private static boolean isModifierKeyword(IVjoKeywordCompletionData keyword) {
        String name = keyword.getName();
        return VjoKeywordFactory.KWD_PUBLIC.getName().equals(name) || VjoKeywordFactory.KWD_PROTECTED.getName().equals(name) || VjoKeywordFactory.KWD_PRIVATE.getName().equals(name) || VjoKeywordFactory.KWD_NEEDS.getName().equals(name);
    }

    public static boolean isVjoComment(String commentTxt, int relativeCursorPos) {
        int pos1 = commentTxt.indexOf("//");
        int pos2 = commentTxt.indexOf(">");
        int pos3 = commentTxt.indexOf("<");
        if (pos2 == -1 && pos3 == -1) {
            return false;
        }
        if (pos1 >= relativeCursorPos || pos2 >= relativeCursorPos || pos3 >= relativeCursorPos) {
            return false;
        }
        if (pos1 >= pos2 && pos2 != -1) {
            return false;
        }
        return pos1 < pos3 || pos3 == -1;
    }
}

