/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.integration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstFuncType;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.SynthOlType;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.vjo.tool.codecompletion.CodeCompletionUtils;
import org.eclipse.vjet.vjo.tool.codecompletion.IVjoCcProposalData;
import org.eclipse.vjet.vjo.tool.codecompletion.StringUtils;
import org.eclipse.vjet.vjo.tool.codecompletion.VjoCcCtx;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoAttributedProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCCVjoUtilityAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcAliasProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcCTypeProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcConstructorGenProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcDerivedPropMethodAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcEnumElementAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcFunctionArgumentAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcFunctionGenProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcGlobalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcGlobalExtensionAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcInterfaceProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcKeywordAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcKeywordInCommentProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcKeywordInMethodProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcMTypeProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcNeedsItemProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcObjLiteralAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcOuterPropMethodProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcOverrideProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcOwnerTypeProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcPackageProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcParameterHintAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcParameterProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcPropMethodProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcStaticPropMethodProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcThisProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcTypeNameAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcTypeNameAliasProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcTypeProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcVariableProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.keyword.IVjoKeywordCompletionData;
import org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.AbstractVjoProposalPresenter;
import org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.VjoCcAliasProposalData;
import org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.integration.IVjoEclipseCompletionProposal;
import org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.integration.IVjoEclipseContextInformationFactory;
import org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.integration.IVjoMethodCompletionProposalFactory;
import org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.integration.IVjoProposalAditionalInfoGeneratorAdapter;
import org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.integration.IVjoProposalLabelProviderAdapter;
import org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.integration.IVjoProposalLabelUtilAdapter;
import org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.integration.IVjoTypeCompletionProposalFactory;
import org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.integration.VjoEclipseCompletionProposalAdapter;

public class VjoProposalEclipsePresenterAdapter<DOCUMENT, POINT, IMAGE_DESCRIPTOR, IMAGE, CONTEXT_INFO, INDENTER>
extends AbstractVjoProposalPresenter {
    private DOCUMENT m_document;
    private POINT m_selectedRange;
    private VjoCcCtx m_vjoCcCtx;
    private int m_replaceOffset;
    private int m_replaceLength;
    private int m_replacePOffset;
    private int m_replacePLength;
    private int m_offset;
    private String m_lineSeperator;
    private IVjoProposalAditionalInfoGeneratorAdapter m_additionalInfoGenerator;
    private IVjoProposalLabelProviderAdapter<IMAGE_DESCRIPTOR, IMAGE> m_labelProvider;
    private IVjoProposalLabelUtilAdapter<DOCUMENT, INDENTER> m_labelUtil;
    private IVjoEclipseContextInformationFactory<IMAGE, CONTEXT_INFO> m_contextInfoFactory;
    private IVjoMethodCompletionProposalFactory<IMAGE, CONTEXT_INFO> m_methodProposalFactory;
    private IVjoTypeCompletionProposalFactory<IMAGE, CONTEXT_INFO> m_typeProposalFactory;
    private String m_indent;

    public VjoProposalEclipsePresenterAdapter(VjoCcCtx vjoCcCtx, int offset, POINT selectedRange, DOCUMENT document, IVjoProposalAditionalInfoGeneratorAdapter additionalInfoGenerator, IVjoProposalLabelProviderAdapter<IMAGE_DESCRIPTOR, IMAGE> labelProvider, IVjoProposalLabelUtilAdapter<DOCUMENT, INDENTER> labelUtil, IVjoEclipseContextInformationFactory<IMAGE, CONTEXT_INFO> contextInfoFactory, IVjoMethodCompletionProposalFactory<IMAGE, CONTEXT_INFO> methodProposalFactory, IVjoTypeCompletionProposalFactory<IMAGE, CONTEXT_INFO> typeProposalFactory) {
        this.m_vjoCcCtx = vjoCcCtx;
        this.m_offset = offset;
        this.m_selectedRange = selectedRange;
        this.m_document = document;
        if (additionalInfoGenerator == null || labelProvider == null || labelUtil == null || contextInfoFactory == null || methodProposalFactory == null || typeProposalFactory == null) {
            throw new IllegalArgumentException("{additionalInfoGenerator, labelProvider, labelUtil, contextInfoFactory, methodProposalFactory, typeProposalFactory}, none of them could be null, please check");
        }
        this.m_additionalInfoGenerator = additionalInfoGenerator;
        this.m_labelProvider = labelProvider;
        this.m_labelUtil = labelUtil;
        this.m_contextInfoFactory = contextInfoFactory;
        this.m_methodProposalFactory = methodProposalFactory;
        this.m_typeProposalFactory = typeProposalFactory;
    }

    public List<? extends IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO>> doPresenter(List<IVjoCcProposalData> datas) {
        ArrayList<IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO>> result = new ArrayList<IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO>>();
        for (IVjoCcProposalData data : datas) {
            IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO> proposal = this.genProposal(data);
            if (proposal != null) {
                result.add(proposal);
                continue;
            }
            List<IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO>> list = this.genProposals(data);
            if (list.isEmpty()) continue;
            result.addAll(list);
        }
        return result;
    }

    public IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO> genProposal(IVjoCcProposalData data) {
        String advisor = data.getAdvisor();
        if (VjoCcKeywordAdvisor.ID.equals(advisor) || VjoCcKeywordInCommentProposalAdvisor.ID.equals(advisor) || VjoCcKeywordInMethodProposalAdvisor.ID.equals(advisor) || VjoCcThisProposalAdvisor.ID.equals(advisor) || VjoCCVjoUtilityAdvisor.ID.equals(advisor)) {
            return this.genKeywordProposal(data);
        }
        if (VjoCcFunctionArgumentAdvisor.ID.equals(advisor)) {
            return this.genFunctionArgumentProposal(data);
        }
        if (VjoCcTypeProposalAdvisor.ID.equals(advisor) || VjoCcOwnerTypeProposalAdvisor.ID.equals(advisor) || VjoCcCTypeProposalAdvisor.ID.equals(advisor) || VjoCcNeedsItemProposalAdvisor.ID.equals(advisor) || VjoCcMTypeProposalAdvisor.ID.equals(advisor) || VjoCcInterfaceProposalAdvisor.ID.equals(advisor)) {
            return this.genTypeProposal(data);
        }
        if (VjoCcPropMethodProposalAdvisor.ID.equals(advisor) || VjoCcDerivedPropMethodAdvisor.ID.equals(advisor) || VjoCcStaticPropMethodProposalAdvisor.ID.equals(advisor) || VjoCcEnumElementAdvisor.ID.equals(advisor) || VjoCcGlobalAdvisor.ID.equals(advisor)) {
            return this.genPropMethodProposal(data, VjoCcGlobalAdvisor.ID.equals(advisor));
        }
        if (VjoCcOverrideProposalAdvisor.ID.equals(advisor)) {
            return this.genOverrideProposal(data);
        }
        if (VjoCcParameterProposalAdvisor.ID.equals(advisor)) {
            return this.genArgumentProposal(data);
        }
        if (VjoCcVariableProposalAdvisor.ID.equals(advisor)) {
            return this.genVariableProposal(data);
        }
        if (VjoCcPackageProposalAdvisor.ID.equals(advisor)) {
            return this.genPackageProposal(data);
        }
        if (VjoCcTypeNameAdvisor.ID.equals(advisor) || VjoCcTypeNameAliasProposalAdvisor.ID.equals(advisor)) {
            return this.genTypeNameProposal(data);
        }
        if (VjoCcConstructorGenProposalAdvisor.ID.equals(advisor)) {
            return this.genConstructorGenProposal(data);
        }
        if (VjoCcAliasProposalAdvisor.ID.equals(advisor)) {
            return this.genAliasProposalAdvisor(data);
        }
        if (VjoCcParameterHintAdvisor.ID.equals(advisor)) {
            return this.getParameterHintAdvisor(data);
        }
        if (VjoCcOuterPropMethodProposalAdvisor.ID.equals(advisor)) {
            return this.genOutPropMethodAdvisor(data);
        }
        if (VjoCcGlobalExtensionAdvisor.ID.equals(advisor)) {
            return this.genPropMethodProposal(data, true);
        }
        if (VjoCcObjLiteralAdvisor.ID.equals(advisor)) {
            return this.genObjLiteralProposal(data);
        }
        if (VjoAttributedProposalAdvisor.ID.equals(advisor)) {
            return this.genAttributedProposal(data);
        }
        return null;
    }

    public IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO> genFunctionArgumentProposal(IVjoCcProposalData data) {
        Object node = data.getData();
        if (node instanceof IJstMethod) {
            IJstMethod method = (IJstMethod)node;
            String displayString = CodeCompletionUtils.getFullMethodString(method, method.getOwnerType(), false);
            String replaceString = CodeCompletionUtils.getFullFunctionWithoutOverloadingOrNaming(method, this.getIndent());
            replaceString = replaceString.replaceAll("<<Line_Seperator>>", this.getLineSeperator());
            replaceString = this.m_labelUtil.evaluateIndent(replaceString, this.m_document, this.m_replaceOffset);
            int cursorPosition = this.getCursorPosition(replaceString);
            replaceString = this.replaceCursorPositionToken(replaceString);
            return new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(replaceString, this.m_replaceOffset, this.m_replaceLength, cursorPosition, this.m_labelProvider.getMethodImage(this.m_labelUtil.translateModifers(method.getModifiers().getFlags())), displayString, null, null);
        }
        return null;
    }

    public IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO> genOutPropMethodAdvisor(IVjoCcProposalData data) {
        Object node = data.getData();
        if (node instanceof IJstMethod) {
            IJstMethod method = (IJstMethod)node;
            if (this.m_additionalInfoGenerator.isBrowserNoneNode((IJstNode)method)) {
                return null;
            }
            String replaceString = this.getOuterMethodProposalReplaceStr(method);
            String displayString = CodeCompletionUtils.getFullMethodString(method);
            String externalInfo = this.m_additionalInfoGenerator.getAdditionalPropesalInfo((IJstNode)method);
            int cursorPosition = this.getCursorPosition(replaceString);
            if (cursorPosition != replaceString.length()) {
                replaceString = this.replaceCursorPositionToken(replaceString);
            }
            IMAGE image = this.m_labelProvider.getScriptImage((IJstNode)method);
            String contextArgInfo = CodeCompletionUtils.getJstArgsString(method);
            Object proposalContext = StringUtils.isBlankOrEmpty(contextArgInfo) ? null : (Object)this.m_contextInfoFactory.buildContextInfo(image, displayString, contextArgInfo);
            IVjoEclipseCompletionProposal<IMAGE, Object> proposal = null;
            List args = method.getArgs();
            if (this.m_vjoCcCtx.isVjoMethod(method) || args == null || args.isEmpty()) {
                replaceString = this.m_labelUtil.evaluateIndent(replaceString, this.m_document, this.m_replaceOffset);
                proposal = new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(replaceString, this.m_replaceOffset, this.m_replaceLength, cursorPosition, image, displayString, proposalContext, externalInfo, method);
            } else {
                proposal = this.m_methodProposalFactory.createMethodCompletionProposal(replaceString, this.m_replaceOffset, this.m_replaceLength, cursorPosition, image, displayString, proposalContext, externalInfo, method);
            }
            return proposal;
        }
        if (node instanceof IJstProperty) {
            IJstProperty property = (IJstProperty)node;
            if (this.m_additionalInfoGenerator.isBrowserNoneNode((IJstNode)property)) {
                return null;
            }
            String replaceString = this.getOuterPropertyProposalReplaceStr(property);
            String externalInfo = this.m_additionalInfoGenerator.getAdditionalPropesalInfo((IJstNode)property);
            String displayString = CodeCompletionUtils.getPropertyString(property);
            int kcursorPostion = replaceString.length();
            if (replaceString.endsWith("})") || replaceString.endsWith("'')")) {
                kcursorPostion -= 2;
            }
            VjoEclipseCompletionProposalAdapter<IMAGE, Object> proposal = new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(replaceString, this.m_replaceOffset, this.m_replaceLength, kcursorPostion, this.m_labelProvider.getScriptImage((IJstNode)property), displayString, null, externalInfo, property);
            return proposal;
        }
        if (node instanceof IJstType) {
            IJstType type = (IJstType)node;
            String replaceString = this.getOuterInnerTypeAsPropertyProposalReplaceStr(type);
            String externalInfo = "";
            VjoEclipseCompletionProposalAdapter<IMAGE, Object> proposal = new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(replaceString, this.m_replaceOffset, this.m_replaceLength, replaceString.length(), this.m_labelProvider.getScriptImage((IJstNode)type), CodeCompletionUtils.getTypeDispalyString(type), null, externalInfo);
            return proposal;
        }
        return null;
    }

    public IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO> getParameterHintAdvisor(IVjoCcProposalData data) {
        Object node = data.getData();
        if (node instanceof IJstMethod) {
            IJstMethod method = (IJstMethod)node;
            if (this.m_additionalInfoGenerator.isBrowserNoneNode((IJstNode)method)) {
                return null;
            }
            String displayString = CodeCompletionUtils.getFullMethodString(method);
            String externalInfo = this.m_additionalInfoGenerator.getAdditionalPropesalInfo((IJstNode)method);
            String replaceString = "";
            IMAGE image = this.m_labelProvider.getScriptImage((IJstNode)method);
            String contextArgInfo = CodeCompletionUtils.getJstArgsString(method);
            Object proposalContext = StringUtils.isBlankOrEmpty(contextArgInfo) ? null : (Object)this.m_contextInfoFactory.buildContextInfo(image, displayString, contextArgInfo);
            VjoEclipseCompletionProposalAdapter<IMAGE, Object> proposal = new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(replaceString, 0, 0, this.m_offset, image, displayString, proposalContext, externalInfo, method);
            return proposal;
        }
        return null;
    }

    public List<IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO>> genProposals(IVjoCcProposalData data) {
        String advisor = data.getAdvisor();
        if (VjoCcFunctionGenProposalAdvisor.ID.equals(advisor) && this.m_vjoCcCtx.needAdvisor(VjoCcFunctionGenProposalAdvisor.ID)) {
            return this.genFunctionProposal(data);
        }
        return Collections.emptyList();
    }

    public List<IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO>> genFunctionProposal(IVjoCcProposalData data) {
        IJstType type = this.m_vjoCcCtx.getActingType();
        boolean isInterface = type.isInterface() || type.isMetaType();
        String token = this.m_vjoCcCtx.getActingToken();
        if ("main".equals(token) && !isInterface && this.m_vjoCcCtx.isInStatic()) {
            return this.genMainFunctionProposals(data);
        }
        int[] identifiers = null;
        identifiers = isInterface ? new int[]{1} : new int[]{1, 4, 2};
        ArrayList<IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO>> list = new ArrayList<IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO>>();
        int[] nArray = identifiers;
        int n = identifiers.length;
        int n2 = 0;
        while (n2 < n) {
            int identifier = nArray[n2];
            String replaceString = this.getFunctionString(identifier, token, isInterface, this.getIndent());
            String sidentifier = CodeCompletionUtils.getModifierStr(identifier);
            String name = String.valueOf(token) + " " + sidentifier + " Function";
            replaceString = this.m_labelUtil.evaluateIndent(replaceString, this.m_document, this.m_replaceOffset);
            int cursorPosition = this.getCursorPosition(replaceString);
            replaceString = this.replaceCursorPositionToken(replaceString);
            VjoEclipseCompletionProposalAdapter<IMAGE, Object> proposal = new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(replaceString, this.m_replaceOffset, this.m_replaceLength, cursorPosition, this.m_labelProvider.getMethodImage(this.m_labelUtil.translateModifers(identifier)), name, null, null);
            list.add(proposal);
            ++n2;
        }
        return list;
    }

    private String getIndent() {
        return this.m_indent;
    }

    public void setIndent(String indent) {
        this.m_indent = indent;
    }

    public List<IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO>> genMainFunctionProposals(IVjoCcProposalData data) {
        ArrayList<IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO>> list = new ArrayList<IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO>>();
        int identifier = 1;
        String replaceString = this.getMainFunctionString(this.getIndent());
        String sidentifier = CodeCompletionUtils.getModifierStr(identifier);
        String name = "main " + sidentifier + " Function";
        replaceString = this.m_labelUtil.evaluateIndent(replaceString, this.m_document, this.m_replaceOffset);
        int cursorPosition = this.getCursorPosition(replaceString);
        replaceString = this.replaceCursorPositionToken(replaceString);
        VjoEclipseCompletionProposalAdapter<IMAGE, Object> proposal = new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(replaceString, this.m_replaceOffset, this.m_replaceLength, cursorPosition, this.m_labelProvider.getMethodImage(this.m_labelUtil.translateModifers(identifier)), name, null, null);
        list.add(proposal);
        return list;
    }

    public IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO> genAliasProposalAdvisor(IVjoCcProposalData data) {
        String alias;
        VjoCcAliasProposalData adata = (VjoCcAliasProposalData)data;
        IJstType type = adata.getType();
        String replaceString = alias = adata.getAlias();
        if (!CodeCompletionUtils.isNativeType(type) && this.m_vjoCcCtx.getPositionType() != 2) {
            replaceString = "this.vj$." + replaceString;
        }
        String externalInfo = "";
        VjoEclipseCompletionProposalAdapter<IMAGE, Object> proposal = new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(replaceString, this.m_replaceOffset, this.m_replaceLength, replaceString.length(), this.m_labelProvider.getScriptImage((IJstNode)type), alias, null, externalInfo);
        return proposal;
    }

    public IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO> genConstructorGenProposal(IVjoCcProposalData data) {
        String name = "constructs";
        IJstType type = this.m_vjoCcCtx.getActingType();
        String modifier = "public";
        if (type != null && type.isEnum()) {
            modifier = "private";
        }
        String cString = this.getConstructorString(modifier, this.getIndent());
        String replaceString = this.m_labelUtil.evaluateIndent(cString, this.m_document, this.m_replaceOffset);
        int cursorPosition = this.getCursorPosition(replaceString);
        replaceString = this.replaceCursorPositionToken(replaceString);
        VjoEclipseCompletionProposalAdapter<Object, Object> proposal = new VjoEclipseCompletionProposalAdapter<Object, Object>(replaceString, this.m_replaceOffset, this.m_replaceLength, cursorPosition, null, name, null, null);
        return proposal;
    }

    public IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO> genTypeNameProposal(IVjoCcProposalData data) {
        String name = (String)data.getData();
        VjoEclipseCompletionProposalAdapter proposal = new VjoEclipseCompletionProposalAdapter(name, this.m_replaceOffset, this.m_replaceLength, name.length() - this.m_replaceLength);
        return proposal;
    }

    public IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO> genPackageProposal(IVjoCcProposalData data) {
        JstPackage packge = (JstPackage)data.getData();
        String replaceString = packge.getName();
        VjoEclipseCompletionProposalAdapter<IMAGE, Object> proposal = new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(replaceString, this.m_replacePOffset, this.m_replacePLength, replaceString.length(), this.m_labelProvider.getScriptImage((IJstNode)packge), packge.getName(), null, null);
        return proposal;
    }

    public IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO> genVariableProposal(IVjoCcProposalData data) {
        IJstNode proposed = (IJstNode)data.getData();
        if (proposed instanceof JstArg) {
            JstArg arg = (JstArg)data.getData();
            String displayString = arg.getName();
            displayString = arg.getType() != null ? String.valueOf(displayString) + " " + arg.getType().getSimpleName() : String.valueOf(displayString) + " " + "Object";
            String name = arg.getName();
            String externalInfo = "";
            return new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(arg.getName(), this.m_replaceOffset, this.m_replaceLength, name.length(), this.m_labelProvider.getScriptImage((IJstNode)arg), displayString, null, externalInfo);
        }
        if (proposed instanceof ILHS) {
            ILHS local = (ILHS)data.getData();
            String displayString = local.toLHSText();
            displayString = local.getType() != null ? String.valueOf(displayString) + " " + local.getType().getSimpleName() : String.valueOf(displayString) + " " + "Object";
            String name = local.toLHSText();
            String externalInfo = "";
            return new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(local.toLHSText(), this.m_replaceOffset, this.m_replaceLength, name.length(), this.m_labelProvider.getScriptImage((IJstNode)local), displayString, null, externalInfo);
        }
        if (proposed instanceof IJstMethod) {
            IJstMethod method = (IJstMethod)proposed;
            if (this.m_additionalInfoGenerator.isBrowserNoneNode((IJstNode)method)) {
                return null;
            }
            String displayString = CodeCompletionUtils.getFullMethodString(method);
            String externalInfo = this.m_additionalInfoGenerator.getAdditionalPropesalInfo((IJstNode)method);
            String replaceString = this.getMethodProposalReplaceStr(true, method, this.m_vjoCcCtx);
            int cursorPosition = this.getCursorPosition(replaceString);
            if (cursorPosition != replaceString.length()) {
                replaceString = this.replaceCursorPositionToken(replaceString);
            }
            IMAGE image = this.m_labelProvider.getScriptImage((IJstNode)method);
            String contextArgInfo = CodeCompletionUtils.getJstArgsString(method);
            Object proposalContext = StringUtils.isBlankOrEmpty(contextArgInfo) ? null : (Object)this.m_contextInfoFactory.buildContextInfo(image, displayString, contextArgInfo);
            IVjoEclipseCompletionProposal<IMAGE, Object> proposal = null;
            List args = method.getArgs();
            if (this.m_vjoCcCtx.isVjoMethod(method) || args == null || args.isEmpty()) {
                replaceString = this.m_labelUtil.evaluateIndent(replaceString, this.m_document, this.m_replaceOffset);
                proposal = new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(replaceString, this.m_replaceOffset, this.m_replaceLength, cursorPosition, image, displayString, proposalContext, externalInfo, method);
            } else {
                proposal = this.m_methodProposalFactory.createMethodCompletionProposal(replaceString, this.m_replaceOffset, this.m_replaceLength, cursorPosition, image, displayString, proposalContext, externalInfo, method);
            }
            return proposal;
        }
        return null;
    }

    public IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO> genObjLiteralProposal(IVjoCcProposalData data) {
        Object node = data.getData();
        String displayString = null;
        String name = null;
        String externalInfo = "";
        if (node instanceof TranslateHelper.RenameableSynthJstProxyProp) {
            TranslateHelper.RenameableSynthJstProxyProp pty = (TranslateHelper.RenameableSynthJstProxyProp)node;
            String ptyName = pty.getName().getName();
            if (pty.getDoc() != null) {
                externalInfo = pty.getDoc().getComment();
            }
            displayString = CodeCompletionUtils.getPropertyString((IJstProperty)pty);
            int cursorPosition = ptyName.length();
            IJstType ptyType = pty.getType();
            if (ptyType instanceof SynthOlType || ptyType instanceof JstObjectLiteralType) {
                --cursorPosition;
            }
            if (ptyType instanceof JstFuncType) {
                displayString = CodeCompletionUtils.getFullMethodString(((JstFuncType)ptyType).getFunction(), pty.getOwnerType(), displayString.contains("?"));
            }
            return new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(ptyName, this.getReplacementOffset(data), this.getReplacementLength(data), cursorPosition, this.m_labelProvider.getScriptImage((IJstNode)pty), displayString, null, externalInfo);
        }
        if (node instanceof IJstMethod) {
            IJstMethod method = (IJstMethod)node;
            if (method.getDoc() != null) {
                externalInfo = method.getDoc().getComment();
            }
            String replaceString = CodeCompletionUtils.getFullFunctionWithoutOverloading(method, this.getIndent());
            replaceString = replaceString.replaceAll("<<Line_Seperator>>", this.getLineSeperator());
            replaceString = this.m_labelUtil.evaluateIndent(replaceString, this.m_document, this.m_replaceOffset);
            int cursorPosition = this.getCursorPosition(replaceString);
            replaceString = this.replaceCursorPositionToken(replaceString);
            return new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(replaceString, this.m_replaceOffset, this.m_replaceLength, cursorPosition, this.m_labelProvider.getMethodImage(this.m_labelUtil.translateModifers(method.getModifiers().getFlags())), name, null, externalInfo);
        }
        return null;
    }

    public IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO> genAttributedProposal(IVjoCcProposalData data) {
        Object node = data.getData();
        if (node instanceof IJstProperty) {
            IJstProperty pty = (IJstProperty)node;
            String ptyName = pty.getName().getName();
            String displayString = CodeCompletionUtils.getPropertyString(pty);
            String paddingColon = this.addColon(data, ptyName);
            VjoEclipseCompletionProposalAdapter<IMAGE, Object> proposal = new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(paddingColon, this.getReplacementOffset(data), this.getReplacementLength(data), paddingColon.length(), this.m_labelProvider.getScriptImage((IJstNode)pty), displayString, null, "");
            return proposal;
        }
        if (node instanceof IJstMethod) {
            IJstMethod mtd = (IJstMethod)node;
            String mtdName = mtd.getName().getName();
            String displayString = CodeCompletionUtils.getFullMethodString(mtd);
            String paddingColon = this.addColon(data, mtdName);
            VjoEclipseCompletionProposalAdapter<IMAGE, Object> proposal = new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(paddingColon, this.getReplacementOffset(data), this.getReplacementLength(data), paddingColon.length(), this.m_labelProvider.getScriptImage((IJstNode)mtd), displayString, null, "");
            return proposal;
        }
        return null;
    }

    private int getReplacementOffset(IVjoCcProposalData proposalData) {
        return this.m_replaceOffset;
    }

    private int getReplacementLength(IVjoCcProposalData proposalData) {
        return this.m_replaceLength;
    }

    private String addColon(IVjoCcProposalData data, String ptyName) {
        return data.isAccurateMatch() ? ptyName : "::" + ptyName;
    }

    public IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO> genArgumentProposal(IVjoCcProposalData data) {
        String replaceString;
        JstArg arg = (JstArg)data.getData();
        String displayString = replaceString = arg.getName();
        displayString = arg.getType() != null ? String.valueOf(displayString) + " - " + arg.getType().getSimpleName() : String.valueOf(displayString) + " - " + "Object";
        String externalInfo = "";
        VjoEclipseCompletionProposalAdapter<IMAGE, Object> proposal = new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(replaceString, this.m_replaceOffset, this.m_replaceLength, replaceString.length(), this.m_labelProvider.getScriptImage((IJstNode)arg), displayString, null, externalInfo);
        return proposal;
    }

    public IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO> genPropMethodProposal(IVjoCcProposalData data, boolean isGlobal) {
        IJstProperty pty;
        IJstType ptyType;
        Object node = data.getData();
        String methodName = null;
        if (node instanceof IJstProperty && (ptyType = (pty = (IJstProperty)node).getType()) instanceof JstFuncType) {
            node = ((JstFuncType)ptyType).getFunction();
            methodName = pty.getName().getName();
        }
        if (node instanceof IJstMethod) {
            IJstMethod method = (IJstMethod)node;
            if (methodName == null) {
                methodName = method.getName().getName();
            }
            if (this.m_additionalInfoGenerator.isBrowserNoneNode((IJstNode)method)) {
                return null;
            }
            String displayString = CodeCompletionUtils.getFullMethodString(methodName, method, method.getOwnerType(), false);
            String externalInfo = this.m_additionalInfoGenerator.getAdditionalPropesalInfo((IJstNode)method);
            String replaceString = this.getMethodProposalReplaceStr(isGlobal, method, methodName, this.m_vjoCcCtx);
            int cursorPosition = this.getCursorPosition(replaceString);
            if (cursorPosition != replaceString.length()) {
                replaceString = this.replaceCursorPositionToken(replaceString);
            }
            IMAGE image = this.m_labelProvider.getScriptImage((IJstNode)method);
            String contextArgInfo = CodeCompletionUtils.getJstArgsString(method);
            Object proposalContext = StringUtils.isBlankOrEmpty(contextArgInfo) ? null : (Object)this.m_contextInfoFactory.buildContextInfo(image, displayString, contextArgInfo);
            IVjoEclipseCompletionProposal<IMAGE, Object> proposal = null;
            List args = method.getArgs();
            if (this.m_vjoCcCtx.isVjoMethod(method) || args == null || args.isEmpty()) {
                replaceString = this.m_labelUtil.evaluateIndent(replaceString, this.m_document, this.m_replaceOffset);
                proposal = new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(replaceString, this.m_replaceOffset, this.m_replaceLength, cursorPosition, image, displayString, proposalContext, externalInfo, method);
            } else {
                proposal = this.m_methodProposalFactory.createMethodCompletionProposal(replaceString, this.m_replaceOffset, this.m_replaceLength, cursorPosition, image, displayString, proposalContext, externalInfo, method);
            }
            return proposal;
        }
        if (node instanceof IJstProperty) {
            boolean noneIdentifierPropertyAccess;
            IJstProperty property = (IJstProperty)node;
            if (this.m_additionalInfoGenerator.isBrowserNoneNode((IJstNode)property)) {
                return null;
            }
            String externalInfo = this.m_additionalInfoGenerator.getAdditionalPropesalInfo((IJstNode)property);
            String displayString = CodeCompletionUtils.getPropertyString(property);
            String replaceString = this.getPropertyProposalReplaceStr(isGlobal, property, this.m_vjoCcCtx);
            int kcursorPostion = replaceString.length();
            if (replaceString.endsWith("})") || replaceString.endsWith("'')")) {
                kcursorPostion -= 2;
            }
            VjoEclipseCompletionProposalAdapter<IMAGE, Object> proposal = new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(replaceString, (noneIdentifierPropertyAccess = replaceString.endsWith("]")) ? this.m_replaceOffset - 1 : this.m_replaceOffset, noneIdentifierPropertyAccess ? this.m_replaceLength + 1 : this.m_replaceLength, kcursorPostion, this.m_labelProvider.getScriptImage((IJstNode)property), displayString, null, externalInfo, property);
            return proposal;
        }
        if (node instanceof IJstType) {
            IJstType type = (IJstType)node;
            String replaceString = this.getInnerTypeAsPropertyProposalReplaceStr(isGlobal, type, this.m_vjoCcCtx);
            String externalInfo = "";
            VjoEclipseCompletionProposalAdapter<IMAGE, Object> proposal = new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(replaceString, this.m_replaceOffset, this.m_replaceLength, replaceString.length(), this.m_labelProvider.getScriptImage((IJstNode)type), CodeCompletionUtils.getTypeDispalyString(type), null, externalInfo);
            return proposal;
        }
        return null;
    }

    public IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO> genOverrideProposal(IVjoCcProposalData data) {
        Object obj = data.getData();
        if (!(obj instanceof IJstMethod)) {
            return null;
        }
        IJstMethod method = (IJstMethod)obj;
        String displayString = CodeCompletionUtils.getMethodStringForOverrideProposal(method);
        String replaceString = this.getReplaceStringForOverrideProposal(method, this.getIndent());
        replaceString = this.m_labelUtil.evaluateIndent(replaceString, this.m_document, this.m_replaceOffset);
        int cursorPosition = this.getCursorPosition(replaceString);
        replaceString = this.replaceCursorPositionToken(replaceString);
        VjoEclipseCompletionProposalAdapter<IMAGE, Object> proposal = new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(replaceString, this.m_replaceOffset, this.m_replaceLength, cursorPosition, this.m_labelProvider.getScriptImage((IJstNode)method), displayString, null, null);
        return proposal;
    }

    public IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO> genTypeProposal(IVjoCcProposalData data) {
        Object obj = data.getData();
        if (!(obj instanceof IJstType)) {
            return null;
        }
        IJstType type = (IJstType)obj;
        String replaceString = this.getTypeReplaceString(type, this.m_vjoCcCtx);
        String externalInfo = "";
        if (this.m_vjoCcCtx.isInSyntaxScope() || this.m_vjoCcCtx.getPositionType() == 2) {
            return new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(replaceString, this.m_replaceOffset, this.m_replaceLength, replaceString.length(), this.m_labelProvider.getScriptImage((IJstNode)type), CodeCompletionUtils.getTypeDispalyString(type), null, externalInfo);
        }
        if (this.m_vjoCcCtx.isInCommentArea()) {
            if (!this.m_vjoCcCtx.isInInactiveArea()) {
                replaceString = this.getCommentTypeReplaceString(type, this.m_vjoCcCtx);
            }
            if (!this.m_vjoCcCtx.isInInactiveArea() && this.m_vjoCcCtx.needInsertInactiveNeedsExpr(type)) {
                String insertStr = "";
                return this.m_typeProposalFactory.createTypeCompletionProposal(replaceString, this.m_replaceOffset, this.m_replaceLength, replaceString.length() + insertStr.length(), this.m_vjoCcCtx.getNeedsPosition() - 1, insertStr, this.m_labelProvider.getScriptImage((IJstNode)type), CodeCompletionUtils.getTypeDispalyString(type), null, externalInfo);
            }
            return new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(replaceString, this.m_replaceOffset, this.m_replaceLength, replaceString.length(), this.m_labelProvider.getScriptImage((IJstNode)type), CodeCompletionUtils.getTypeDispalyString(type), null, externalInfo);
        }
        String ptoken = this.m_vjoCcCtx.getActingPackageToken();
        String token = this.m_vjoCcCtx.getActingToken();
        int tempReplaceOffset = this.m_replaceOffset;
        int tempReplaceLength = this.m_replaceLength;
        if (ptoken != null && token != null && !ptoken.equals(token)) {
            tempReplaceLength = this.m_replaceLength + ptoken.length() - token.length();
            tempReplaceOffset = this.m_replaceOffset + token.length() - ptoken.length();
        }
        return new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(replaceString, tempReplaceOffset, tempReplaceLength, replaceString.length(), this.m_labelProvider.getScriptImage((IJstNode)type), CodeCompletionUtils.getTypeDispalyString(type), null, externalInfo);
    }

    public IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO> genEmbedTypeData(IVjoCcProposalData data) {
        Object obj = data.getData();
        if (!(obj instanceof IJstType)) {
            return null;
        }
        IJstType type = (IJstType)obj;
        String replaceString = type.getSimpleName();
        String externalInfo = "";
        VjoEclipseCompletionProposalAdapter<IMAGE, Object> proposal = new VjoEclipseCompletionProposalAdapter<IMAGE, Object>(replaceString, this.m_replaceOffset, this.m_replaceLength, replaceString.length(), this.m_labelProvider.getScriptImage((IJstNode)type), CodeCompletionUtils.getTypeDispalyString(type), null, externalInfo);
        return proposal;
    }

    public IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO> genKeywordProposal(IVjoCcProposalData data) {
        IVjoKeywordCompletionData keyword = (IVjoKeywordCompletionData)data;
        String replaceString = this.getKeywordReplaceString(keyword.getName(), this.m_vjoCcCtx.getTypeName(), this.m_vjoCcCtx.isInCommentArea(), this.getIndent());
        int cursorPosition = this.getCursorPosition(replaceString);
        replaceString = this.replaceCursorPositionToken(replaceString);
        VjoEclipseCompletionProposalAdapter<Object, Object> proposal = new VjoEclipseCompletionProposalAdapter<Object, Object>(replaceString, this.m_replaceOffset, this.m_replaceLength, cursorPosition, null, keyword.getName(), null, null);
        return proposal;
    }

    @Deprecated
    public IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO> createProposal(int kind, int completionOffset) {
        IVjoEclipseCompletionProposal<IMAGE, CONTEXT_INFO> proposal = null;
        return proposal;
    }

    public void setDocument(DOCUMENT mDocument) {
        this.m_document = mDocument;
    }

    public void setSelectedRange(POINT mSelectedRange) {
        this.m_selectedRange = mSelectedRange;
    }

    public void setVjoCcCtx(VjoCcCtx mVjoCcCtx) {
        this.m_vjoCcCtx = mVjoCcCtx;
    }

    public void setReplaceOffset(int mReplaceOffset) {
        this.m_replaceOffset = mReplaceOffset;
    }

    public void setReplaceLength(int mReplaceLength) {
        this.m_replaceLength = mReplaceLength;
    }

    public void setReplacePOffset(int mReplacePOffset) {
        this.m_replacePOffset = mReplacePOffset;
    }

    public void setReplacePLength(int mReplacePLength) {
        this.m_replacePLength = mReplacePLength;
    }

    public void setOffset(int mOffset) {
        this.m_offset = mOffset;
    }

    public void setLineSeperator(String mLineSeperator) {
        this.m_lineSeperator = mLineSeperator;
    }

    public void setAdditionalInfoGenerator(IVjoProposalAditionalInfoGeneratorAdapter mAdditionalInfoGenerator) {
        this.m_additionalInfoGenerator = mAdditionalInfoGenerator;
    }

    public void setLabelProvider(IVjoProposalLabelProviderAdapter<IMAGE_DESCRIPTOR, IMAGE> mLabelProvider) {
        this.m_labelProvider = mLabelProvider;
    }

    public void setLabelUtil(IVjoProposalLabelUtilAdapter<DOCUMENT, INDENTER> mLabelUtil) {
        this.m_labelUtil = mLabelUtil;
    }

    public void setContextInfoFactory(IVjoEclipseContextInformationFactory<IMAGE, CONTEXT_INFO> mContextInfoFactory) {
        this.m_contextInfoFactory = mContextInfoFactory;
    }

    public void setMethodProposalFactory(IVjoMethodCompletionProposalFactory<IMAGE, CONTEXT_INFO> mMethodProposalFactory) {
        this.m_methodProposalFactory = mMethodProposalFactory;
    }

    public void setTypeProposalFactory(IVjoTypeCompletionProposalFactory<IMAGE, CONTEXT_INFO> mTypeProposalFactory) {
        this.m_typeProposalFactory = mTypeProposalFactory;
    }

    public DOCUMENT getDocument() {
        return this.m_document;
    }

    public POINT getSelectedRange() {
        return this.m_selectedRange;
    }

    public VjoCcCtx getVjoCcCtx() {
        return this.m_vjoCcCtx;
    }

    public int getReplaceOffset() {
        return this.m_replaceOffset;
    }

    public int getReplaceLength() {
        return this.m_replaceLength;
    }

    public int getReplacePOffset() {
        return this.m_replacePOffset;
    }

    public int getReplacePLength() {
        return this.m_replacePLength;
    }

    public int getOffset() {
        return this.m_offset;
    }

    @Override
    public String getLineSeperator() {
        if (this.m_lineSeperator != null) {
            return this.m_lineSeperator;
        }
        return super.getLineSeperator();
    }

    public IVjoProposalAditionalInfoGeneratorAdapter getAdditionalInfoGenerator() {
        return this.m_additionalInfoGenerator;
    }

    public IVjoProposalLabelProviderAdapter<IMAGE_DESCRIPTOR, IMAGE> getLabelProvider() {
        return this.m_labelProvider;
    }

    public IVjoProposalLabelUtilAdapter<DOCUMENT, INDENTER> getLabelUtil() {
        return this.m_labelUtil;
    }

    public IVjoEclipseContextInformationFactory<IMAGE, CONTEXT_INFO> getContextInfoFactory() {
        return this.m_contextInfoFactory;
    }

    public IVjoMethodCompletionProposalFactory<IMAGE, CONTEXT_INFO> getMethodProposalFactory() {
        return this.m_methodProposalFactory;
    }

    public IVjoTypeCompletionProposalFactory<IMAGE, CONTEXT_INFO> getTypeProposalFactory() {
        return this.m_typeProposalFactory;
    }
}

