/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.mod.compiler.problem.IProblemReporter;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IBuffer;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IModelStatus;
import org.eclipse.dltk.mod.core.IOpenable;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceElementParser;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.SourceParserUtil;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.AccumulatingProblemReporter;
import org.eclipse.dltk.mod.internal.core.JSSourceModule;
import org.eclipse.dltk.mod.internal.core.JSSourceModuleElementInfo;
import org.eclipse.dltk.mod.internal.core.ModelElement;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.ModelStatus;
import org.eclipse.dltk.mod.internal.core.OpenableElementInfo;
import org.eclipse.dltk.mod.internal.core.ScriptFolder;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.internal.core.StructureBuilder;
import org.eclipse.dltk.mod.internal.core.VjoSourceHelper;
import org.eclipse.dltk.mod.internal.core.VjoSourceModuleStructureRequestor;
import org.eclipse.dltk.mod.internal.core.VjoSourceType;
import org.eclipse.dltk.mod.internal.core.builder.StandardScriptBuilder;
import org.eclipse.dltk.mod.utils.CorePrinter;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IScriptProblem;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jstojava.translator.JstUtil;
import org.eclipse.vjet.dsf.ts.type.TypeName;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.core.parser.VjoParserToJstAndIType;
import org.eclipse.vjet.eclipse.internal.compiler.VjoSourceElementParser;
import org.eclipse.vjet.vjo.tool.typespace.ITypeSpaceRunnable;
import org.eclipse.vjet.vjo.tool.typespace.SourceTypeName;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceListener;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class VjoSourceModule
extends JSSourceModule
implements TypeSpaceListener,
IVjoSourceModule {
    private TypeSpaceMgr mgr = TypeSpaceMgr.getInstance();
    protected IJstType jstType;
    private boolean isConsistent = false;

    public VjoSourceModule(ScriptFolder parent, String name, WorkingCopyOwner owner) {
        super(parent, name, owner);
    }

    protected Object openWhenClosed(Object info, IProgressMonitor monitor) throws ModelException {
        return super.openWhenClosed(info, monitor);
    }

    @Override
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor progressMonitor, Map newElements, IResource underlyingResource) throws ModelException {
        SourceStructureBuilder builder = new SourceStructureBuilder(underlyingResource, info, newElements, progressMonitor);
        this.mgr.run((ITypeSpaceRunnable)builder);
        return builder.isStructureKnown();
    }

    private boolean doBuild(OpenableElementInfo info, IProgressMonitor progressMonitor, Map newElements, IResource underlyingResource) throws ModelException {
        try {
            JSSourceModuleElementInfo moduleInfo = (JSSourceModuleElementInfo)info;
            VjoSourceModuleStructureRequestor requestor = new VjoSourceModuleStructureRequestor(this, moduleInfo, newElements);
            String natureId = this.getNatureId();
            if (natureId == null) {
                throw new ModelException((IModelStatus)new ModelStatus(983));
            }
            SourceTypeName stName = this.getTypeName();
            IResource resource = this.getResource();
            VjoSourceElementParser parser = (VjoSourceElementParser)this.getSourceElementParser(natureId);
            if (!this.isReadOnly()) {
                parser.setScriptProject(this.getScriptProject());
            }
            parser.setRequestor(requestor);
            AccumulatingProblemReporter problemReporter = this.getAccumulatingProblemReporter();
            parser.setReporter((IProblemReporter)problemReporter);
            boolean reparsed = false;
            if (problemReporter != null) {
                if (!problemReporter.hasErrors()) {
                    StructureBuilder.build((String)natureId, (ISourceModule)this, (AccumulatingProblemReporter)problemReporter);
                    reparsed = true;
                }
                problemReporter.reportToRequestor();
            }
            if (this.jstType == null && this.isVirtualTypeResource(resource)) {
                this.jstType = TypeSpaceMgr.QE().findType((TypeName)stName);
            } else if (this.jstType == null || !reparsed) {
                if ("".equals(stName.groupName().trim()) && (resource == null || !resource.exists())) {
                    this.jstType = CodeassistUtils.findNativeJstType(stName.typeName());
                } else {
                    char[] contents = this.getContents(progressMonitor, moduleInfo);
                    this.processType(contents);
                }
            }
            SourceParserUtil.parseSourceModule((ISourceModule)this, (ISourceElementParser)parser);
            if (DLTKCore.DEBUG_PRINT_MODEL) {
                System.out.println("Source Module Debug print:");
                CorePrinter printer = new CorePrinter((OutputStream)System.out);
                this.printNode(printer);
                printer.flush();
            }
            if (underlyingResource == null) {
                underlyingResource = this.getResource();
            }
            if (underlyingResource != null) {
                moduleInfo.setTimestamp(((IFile)underlyingResource).getModificationStamp());
            }
            this.isConsistent = true;
            return moduleInfo.isStructureKnown();
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    private char[] getContents(IProgressMonitor progressMonitor, JSSourceModuleElementInfo moduleInfo) throws ModelException {
        IBuffer buffer = null;
        if (this.hasBuffer() && (buffer = this.getBufferManager().getBuffer((IOpenable)this)) == null) {
            buffer = this.openBuffer(progressMonitor, moduleInfo);
        }
        char[] contents = buffer == null ? null : buffer.getCharacters();
        return contents;
    }

    private boolean isVirtualTypeResource(IResource fileSystemLoc) {
        URI location;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember(fileSystemLoc.getFullPath());
        return resource != null && (location = resource.getLocationURI()) != null && location.getScheme().equals("typespace");
    }

    public IModelElement[] getChildren(IProgressMonitor monitor) throws ModelException {
        return super.getChildren(monitor);
    }

    public IModelElement[] getChildren() throws ModelException {
        return super.getChildren();
    }

    public boolean isConsistent() {
        return super.isConsistent() && this.isConsistent;
    }

    private void processType(char[] contents) {
        if (contents == null) {
            return;
        }
        SourceTypeName typeName = this.getTypeName();
        String source = new String(contents);
        typeName.setSource(source);
        if (this.isConsistent) {
            this.jstType = this.parseAndResolve(typeName);
        } else {
            this.jstType = this.mgr.findType((TypeName)typeName);
            if (this.jstType == null) {
                this.jstType = this.parseAndResolve(typeName);
            }
        }
    }

    private IJstType parseAndResolve(SourceTypeName typeName) {
        IJstType jstType = null;
        try {
            IJstType scriptUnit;
            VjoParserToJstAndIType parser = new VjoParserToJstAndIType();
            if (VjetPlugin.TRACE_PARSER) {
                System.out.println("parsing for " + this.getClass().getName());
            }
            if ((scriptUnit = parser.parse(typeName.groupName(), this.getTypeName().typeName(), typeName.source())) != null) {
                jstType = scriptUnit;
            }
        }
        catch (Exception e) {
            DLTKCore.error((String)e.getMessage(), (Throwable)e);
        }
        return jstType;
    }

    public SourceTypeName getTypeName() {
        IResource path = this.getResource();
        return CodeassistUtils.getTypeName(path);
    }

    public String getGroupName() {
        IResource path = this.getResource();
        String group = path.getProject().getName();
        return group;
    }

    protected IBuffer getBuffer(IProgressMonitor progressMonitor, JSSourceModuleElementInfo moduleInfo) throws ModelException {
        IBuffer buffer = this.getBufferManager().getBuffer((IOpenable)this);
        if (buffer == null) {
            buffer = this.openBuffer(progressMonitor, moduleInfo);
        }
        return buffer;
    }

    private void check(IResource underlyingResource) throws CoreException, ModelException {
        IStatus status;
        if (!this.isWorkingCopy() && !(status = this.validateSourceModule(underlyingResource)).isOK()) {
            throw this.newModelException(status);
        }
        this.preventReopen();
    }

    @Override
    public IType getType(String typeName) {
        return new VjoSourceType((ModelElement)this, typeName);
    }

    public void loadTypesFinished() {
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            this.isConsistent = false;
            this.reconcile(true, null, (IProgressMonitor)monitor);
            try {
                try {
                    List dependents;
                    if (this.jstType != null && this.jstType.getPackage() != null && this.jstType.getPackage().getGroupName() != null && this.jstType.getName() != null && (dependents = this.mgr.getTypeSpace().getAllDependents(new TypeName(this.jstType.getPackage().getGroupName(), this.jstType.getName()))) != null) {
                        LinkedList<ISourceModule> selectedSourceModules = new LinkedList<ISourceModule>();
                        StandardScriptBuilder scriptBuild = new StandardScriptBuilder();
                        ScriptProject scriptProject = CodeassistUtils.getScriptProject(this.jstType.getPackage().getGroupName());
                        VjoSourceHelper.getAllSourceModulesFromJst(selectedSourceModules, dependents, scriptProject);
                        if (selectedSourceModules.size() > 0) {
                            scriptBuild.initialize((IScriptProject)scriptProject);
                            scriptBuild.buildModelElements((IScriptProject)scriptProject, selectedSourceModules, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 1), 1);
                        }
                    }
                }
                catch (Exception e) {
                    DLTKCore.error((String)e.toString(), (Throwable)e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
        catch (CoreException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
    }

    @Override
    public IJstType getJstType() {
        if (this.jstType == null) {
            this.jstType = this.mgr.getController().getJstTypeSpaceMgr().getQueryExecutor().findType((TypeName)this.getTypeName());
        }
        return this.jstType;
    }

    public void refreshFinished(List<SourceTypeName> list) {
        if (list.contains(this.getTypeName())) {
            this.loadTypesFinished();
        }
    }

    public boolean refreshSourceFields() throws ModelException {
        if (this.jstType == null || !this.jstType.hasMixins()) {
            return false;
        }
        ModelManager manager = ModelManager.getModelManager();
        try {
            String natureId = this.getNatureId();
            VjoSourceElementParser parser = (VjoSourceElementParser)this.getSourceElementParser(natureId);
            HashMap newElements = new HashMap();
            JSSourceModuleElementInfo info = (JSSourceModuleElementInfo)this.createElementInfo();
            VjoSourceModuleStructureRequestor requestor = new VjoSourceModuleStructureRequestor(this, info, newElements);
            if (!this.isReadOnly()) {
                parser.setScriptProject(this.getScriptProject());
            }
            parser.setRequestor(requestor);
            AccumulatingProblemReporter problemReporter = this.getAccumulatingProblemReporter();
            parser.setReporter((IProblemReporter)problemReporter);
            SourceParserUtil.parseSourceModule((ISourceModule)this, (ISourceElementParser)parser);
            manager.putInfos((IModelElement)this, newElements);
            return true;
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    public void updateScriptUnit(JstBlock block, List<JstBlock> blockList, IJstType type, List<IScriptProblem> probs) {
        this.jstType = type;
    }

    public IJstNode getNode(int startOffset) {
        return JstUtil.getLeafNode((IJstType)this.jstType, (int)startOffset, (int)startOffset);
    }

    private final class SourceStructureBuilder
    implements ITypeSpaceRunnable {
        private final IResource underlyingResource;
        private final OpenableElementInfo info;
        private final Map newElements;
        private final IProgressMonitor progressMonitor;
        private boolean isStructureKnown = false;

        private SourceStructureBuilder(IResource underlyingResource, OpenableElementInfo info, Map newElements, IProgressMonitor progressMonitor) {
            this.underlyingResource = underlyingResource;
            this.info = info;
            this.newElements = newElements;
            this.progressMonitor = progressMonitor;
        }

        public void run() {
            try {
                this.isStructureKnown = VjoSourceModule.this.doBuild(this.info, this.progressMonitor, this.newElements, this.underlyingResource);
            }
            catch (ModelException e) {
                DLTKCore.error((String)e.toString(), (Throwable)e);
            }
        }

        public boolean isStructureKnown() {
            return this.isStructureKnown;
        }
    }
}

