/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.search;

import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstName;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.search.AbstractVjoOccurrenceVisitor;
import org.eclipse.vjet.eclipse.internal.codeassist.select.JstNodeDLTKElementResolver;

public class VjoFieldOccurrenceVisitor
extends AbstractVjoOccurrenceVisitor {
    private boolean m_isLocalVar;
    private boolean m_isMethodArg;
    private boolean m_isTypeProp;

    public VjoFieldOccurrenceVisitor(int fieldType, IJstNode matchNode) {
        super(matchNode);
        this.m_isMethodArg = fieldType == 0;
        this.m_isLocalVar = fieldType == 1;
        this.m_isTypeProp = fieldType == 2;
        this.setMatchName(this.getFieldName());
    }

    @Override
    public void visit(JstArg node) {
        if (!this.m_isMethodArg) {
            return;
        }
        if (!this.matchName(node.getName())) {
            return;
        }
        if (this.matchNode((IJstNode)node)) {
            this.addMatch((IJstNode)node);
        }
    }

    @Override
    public void visit(JstIdentifier node) {
        boolean add;
        if (!this.matchName(node.getName())) {
            return;
        }
        IJstNode jstBinding = JstNodeDLTKElementResolver.lookupBinding((IJstNode)node);
        boolean doMatch = false;
        if (this.m_isLocalVar && jstBinding instanceof JstVars) {
            doMatch = true;
        } else if (this.m_isMethodArg && jstBinding instanceof JstArg) {
            doMatch = true;
        } else if (this.m_isTypeProp && jstBinding instanceof IJstProperty) {
            doMatch = true;
        }
        boolean bl = add = doMatch ? this.matchNode(jstBinding) : false;
        if (add) {
            this.addMatch((IJstNode)node);
        }
    }

    @Override
    public void visit(JstName node) {
        if (!this.m_isTypeProp) {
            return;
        }
        if (!this.matchName(node.getName())) {
            return;
        }
        BaseJstNode parentNode = node.getParentNode();
        if (parentNode instanceof IJstProperty && this.matchNode((IJstNode)parentNode)) {
            this.addMatch((IJstNode)node);
        }
    }

    private String getFieldName() {
        String tempName = null;
        tempName = this.m_isLocalVar ? this.getLocalVariableName() : (this.m_isMethodArg ? this.getMethodArgName() : this.getTypePropName());
        return tempName;
    }

    private String getLocalVariableName() {
        return CodeassistUtils.getFirstVariableName((JstVars)this.getMatchNode());
    }

    private String getMethodArgName() {
        return ((JstArg)this.getMatchNode()).getName();
    }

    private String getTypePropName() {
        return ((IJstProperty)this.getMatchNode()).getName().getName();
    }
}

