/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IPackageDeclaration;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.search.SearchPattern;
import org.eclipse.dltk.mod.internal.core.VjoSourceModule;
import org.eclipse.dltk.mod.internal.core.search.matching.PackageReferencePattern;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.traversal.IJstVisitor;
import org.eclipse.vjet.dsf.jst.traversal.JstDepthFirstTraversal;
import org.eclipse.vjet.dsf.ts.TypeSpace;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.core.search.AbstractVjoElementSearcher;
import org.eclipse.vjet.eclipse.core.search.SearchQueryParameters;
import org.eclipse.vjet.eclipse.core.search.VjoMatch;
import org.eclipse.vjet.eclipse.core.search.VjoPackageReferencesVisitor;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class VjoPackageReferenceSearcher
extends AbstractVjoElementSearcher {
    @Override
    public Class<? extends SearchPattern> getSearchPatternClass() {
        return PackageReferencePattern.class;
    }

    @Override
    protected void searchDeclarations(SearchQueryParameters params, List<VjoMatch> result) {
    }

    @Override
    protected void searchReferences(SearchQueryParameters params, List<VjoMatch> result) {
        IScriptFolder pkg = null;
        if (params.getElement() instanceof IPackageDeclaration) {
            IPackageDeclaration pkgDeclaration = (IPackageDeclaration)params.getElement();
            IVjoSourceModule vjoSourceModule = (IVjoSourceModule)pkgDeclaration.getParent();
            pkg = (IScriptFolder)vjoSourceModule.getParent();
        } else {
            pkg = (IScriptFolder)params.getElement();
        }
        System.out.println("Searching for references of " + pkg.getElementName());
        List<IJstType> dependents = new ArrayList();
        dependents = ((TypeSpace)this.mgr.getTypeSpace()).getPackageDependents(pkg.getElementName());
        try {
            ISourceModule[] sourceModules;
            ISourceModule[] iSourceModuleArray = sourceModules = pkg.getSourceModules();
            int n = sourceModules.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceModule sourceModule = iSourceModuleArray[n2];
                if (sourceModule instanceof VjoSourceModule) {
                    IJstType type = ((IVjoSourceModule)sourceModule).getJstType();
                    if (type == null) {
                        type = TypeSpaceMgr.getInstance().findType(((IVjoSourceModule)sourceModule).getTypeName());
                    }
                    if (!dependents.contains(type)) {
                        dependents.add(type);
                    }
                }
                ++n2;
            }
        }
        catch (ModelException e) {
            DLTKCore.error((String)("find source modules of scriptfolder:" + pkg.getElementName() + " failed."), (Throwable)e);
        }
        for (IJstType dependentType : dependents) {
            this.findRefs(pkg, dependentType, result);
        }
    }

    private void findRefs(IScriptFolder pkg, IJstType dependentType, List<VjoMatch> result) {
        VjoPackageReferencesVisitor typeRefVisitor = new VjoPackageReferencesVisitor(pkg, dependentType, result);
        JstDepthFirstTraversal.accept((IJstNode)dependentType, (IJstVisitor)typeRefVisitor);
    }
}

