/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.ts;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.dltk.mod.compiler.util.Util;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.vjet.dsf.jsgroup.bootstrap.JsLibBootstrapLoader;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.ts.IJstTypeLoader;
import org.eclipse.vjet.dsf.jst.ts.util.JstSrcFileCollector;
import org.eclipse.vjet.dsf.jst.ts.util.JstTypeSerializer;
import org.eclipse.vjet.dsf.jstojava.parser.VjoParser;
import org.eclipse.vjet.dsf.ts.event.group.AddGroupEvent;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class VjoJstTypeLoader
implements IJstTypeLoader {
    protected IJstTypeLoader.SourceType createType(String groupName, String actualGroupFolderName, String srcPath, File file) throws IOException, URISyntaxException {
        String typeName = this.getTypeName(srcPath, file);
        FileInputStream stream = new FileInputStream(file);
        byte[] bs = new byte[stream.available()];
        stream.read(bs);
        stream.close();
        String absolutePath = file.getAbsolutePath();
        absolutePath = absolutePath.replace("\\", "/");
        URI fileURI = null;
        if (absolutePath.contains(groupName)) {
            String substring = absolutePath.substring(absolutePath.indexOf(groupName));
            fileURI = new URI(URLEncoder.encode(substring, "utf-8"));
        } else if (absolutePath.contains(actualGroupFolderName)) {
            String replace = absolutePath.substring(absolutePath.indexOf(actualGroupFolderName)).replace(actualGroupFolderName, groupName);
            fileURI = new URI(URLEncoder.encode(replace, "utf-8"));
        } else {
            fileURI = new URI(URLEncoder.encode(absolutePath, "utf-8"));
        }
        String typekey = String.valueOf(groupName) + "#" + typeName;
        TypeSpaceMgr.getInstance().getTypeToFileMap().put(typekey, fileURI);
        IJstTypeLoader.SourceType srcType = new IJstTypeLoader.SourceType(groupName, typeName, new String(bs), file);
        return srcType;
    }

    public List<IJstTypeLoader.SourceType> loadJstTypes(List<AddGroupEvent> groupList) {
        ArrayList<IJstTypeLoader.SourceType> typeList = new ArrayList<IJstTypeLoader.SourceType>();
        for (AddGroupEvent group : groupList) {
            String groupName = group.getGroupName();
            String groupPath = group.getGroupPath();
            String actualGroupFolderName = groupPath.substring(groupPath.lastIndexOf("\\") + 1);
            List srcPathList = group.getSourcePathList();
            File groupFolderOrFile = this.getGroupSrcFolder(groupPath, null);
            List bootStrapPath = group.getBootStrapList();
            if (bootStrapPath != null && bootStrapPath.size() != 0) {
                String bootstrapJS = this.getBootStrapJs(groupFolderOrFile, bootStrapPath);
                JsLibBootstrapLoader.load((String)bootstrapJS, (String)groupName);
            }
            if (srcPathList == null || srcPathList.size() == 0) continue;
            for (String srcPath : srcPathList) {
                File srcFolder = this.getGroupSrcFolder(groupPath, srcPath);
                typeList.addAll(this.loadJstTypesFromGroup(groupName, actualGroupFolderName, srcFolder, group.getSrcPathInclusionPatterns(), group.getSrcPathExclusionPatterns()));
            }
        }
        return typeList;
    }

    private String getBootStrapJs(File groupFolder, List<String> bootStrapPath) {
        StringBuilder bootStrapJs = new StringBuilder();
        for (String root : bootStrapPath) {
            try {
                bootStrapJs.append(this.createType("bootstrap", "", String.valueOf(root) + "bootstrap.js", new File(groupFolder, String.valueOf(root) + File.separatorChar + "bootstrap.js")).getSource());
            }
            catch (IOException iOException) {
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return bootStrapJs.toString();
    }

    private File getGroupSrcFolder(String groupPath, String srcPath) {
        File srcFolder;
        if (groupPath != null) {
            File groupFile = new File(groupPath = this.decodePath(groupPath));
            if (groupFile.exists()) {
                if (!groupFile.isDirectory() || srcPath == null) {
                    return groupFile;
                }
                File srcFolder2 = new File(groupFile, srcPath);
                return srcFolder2;
            }
        } else if (srcPath != null && (srcFolder = new File(srcPath = this.decodePath(srcPath))).exists() && srcFolder.isDirectory()) {
            return srcFolder;
        }
        return null;
    }

    private String decodePath(String groupPath) {
        try {
            groupPath = URLDecoder.decode(groupPath, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            VjetPlugin.getDefault();
            VjetPlugin.error("could not decode " + groupPath, e);
        }
        return groupPath;
    }

    private List<IJstTypeLoader.SourceType> loadJstTypesFromGroup(String groupName, String actualGroupFolderName, File groupFolderOrFile, List<String> inclusionPatterns, List<String> exclusionPatterns) {
        ArrayList<IJstTypeLoader.SourceType> srcTypeList = new ArrayList<IJstTypeLoader.SourceType>();
        if (groupFolderOrFile != null) {
            if (groupFolderOrFile.isDirectory()) {
                return this.loadJstTypesFromProject(groupName, actualGroupFolderName, groupFolderOrFile, inclusionPatterns, exclusionPatterns);
            }
            if (!TypeSpaceMgr.getInstance().existGroup(groupName)) {
                return this.loadJstTypesFromLibrary(groupName, groupFolderOrFile);
            }
        }
        return srcTypeList;
    }

    private String getTypeName(String srcPath, File file) {
        String fileName = file.getPath();
        fileName = fileName.replace("\\", ".");
        fileName = fileName.replace("/", ".");
        String srcFolder = srcPath;
        srcFolder = srcFolder.replace("\\", ".");
        srcFolder = srcFolder.replace("/", ".");
        int start = fileName.lastIndexOf(srcFolder);
        int end = fileName.lastIndexOf(".js");
        String typeName = fileName.substring(start += srcFolder.length() + 1, end);
        return typeName;
    }

    protected List<IJstTypeLoader.SourceType> loadJstTypesFromProject(String groupName, String actualGroupFolderName, File srcFolder, List<String> inclusionPatterns, List<String> exclusionPatterns) {
        JstSrcFileCollector fileColl = new JstSrcFileCollector();
        ArrayList<IJstTypeLoader.SourceType> srcTypeList = new ArrayList<IJstTypeLoader.SourceType>();
        if (srcFolder != null) {
            List list = fileColl.getJsSrcFiles(srcFolder);
            for (File file : list) {
                try {
                    if (!this.isVjoFile(file) || this.isExcluded(srcFolder, file, inclusionPatterns, exclusionPatterns)) continue;
                    srcTypeList.add(this.createType(groupName, actualGroupFolderName, srcFolder.getPath(), file));
                }
                catch (IOException iOException) {
                }
                catch (URISyntaxException e) {
                    DLTKCore.error((String)e.toString(), (Throwable)e);
                }
            }
        }
        return srcTypeList;
    }

    private boolean isExcluded(File srcFolder, File file, List<String> inclusionPatterns, List<String> exclusionPatterns) {
        if (inclusionPatterns.size() == 0 && exclusionPatterns.size() == 0) {
            return false;
        }
        Object inclusionPatternsChar = new char[][]{};
        inclusionPatternsChar = this.processPatterns(srcFolder, inclusionPatterns);
        Object exclusionPatternsChar = new char[][]{};
        exclusionPatternsChar = this.processPatterns(srcFolder, exclusionPatterns);
        boolean excluded = Util.isExcluded((char[])file.toString().toCharArray(), (char[][])inclusionPatternsChar, (char[][])exclusionPatternsChar, (boolean)file.isDirectory());
        if (excluded) {
            System.out.println("file excluded :" + file);
        }
        return excluded;
    }

    private char[][] processPatterns(File srcFolder, List<String> patterns) {
        int length = patterns.size();
        char[][] patternsChar = new char[length][];
        int i = 0;
        while (i < length) {
            patternsChar[i] = new File(srcFolder, patterns.get(i)).getAbsolutePath().toString().toCharArray();
            ++i;
        }
        return patternsChar;
    }

    private boolean isVjoFile(File file) {
        if (file.exists()) {
            return file.getName().endsWith(".js");
        }
        return false;
    }

    protected List<IJstTypeLoader.SourceType> loadJstTypesFromLibrary(String groupName, File libFile) {
        ArrayList<IJstTypeLoader.SourceType> typeList = new ArrayList<IJstTypeLoader.SourceType>();
        String libFileName = libFile.getName().toLowerCase();
        if (CodeassistUtils.isBinaryPath(libFileName)) {
            ZipFile jarFile = null;
            try {
                try {
                    jarFile = new ZipFile(libFile);
                    ZipEntry bootstrapEntry = jarFile.getEntry("bootstrap.js");
                    if (bootstrapEntry != null) {
                        InputStream stream = jarFile.getInputStream(bootstrapEntry);
                        JsLibBootstrapLoader.load((String)VjoParser.load((InputStream)stream, (String)"bootstrap.js"), (String)groupName);
                    }
                    Enumeration<? extends ZipEntry> enumeration = jarFile.entries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry elem = enumeration.nextElement();
                        if (elem.getName().endsWith(".ser")) {
                            typeList.addAll(this.loadAllTypes(groupName, jarFile, elem));
                            continue;
                        }
                        if (elem.getName().contains("bootstrap.js")) continue;
                        typeList.add(this.createType(groupName, jarFile, elem));
                    }
                }
                catch (IOException iOException) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return typeList;
    }

    protected List<IJstTypeLoader.SourceType> loadAllTypes(String groupName, ZipFile jarFile, ZipEntry elem) throws IOException {
        InputStream stream = jarFile.getInputStream(elem);
        List jstTypes = JstTypeSerializer.getInstance().deserialize(stream);
        ArrayList<IJstTypeLoader.SourceType> srcTypes = new ArrayList<IJstTypeLoader.SourceType>();
        for (IJstType type : jstTypes) {
            if (JstCache.getInstance().getType(type.getName()) == null) {
                JstCache.getInstance().addType((JstType)type);
                if (type.getAliasTypeName() != null && type instanceof JstObjectLiteralType) {
                    JstCache.getInstance().addAliasType(type.getAliasTypeName(), (JstObjectLiteralType)type);
                }
            }
            srcTypes.add(new IJstTypeLoader.SourceType(groupName, type));
        }
        return srcTypes;
    }

    protected IJstTypeLoader.SourceType createType(String groupName, ZipFile jarFile, ZipEntry elem) throws IOException {
        String typeName = elem.getName();
        if (!CodeassistUtils.isVjetFileName(typeName)) {
            return null;
        }
        int end = typeName.lastIndexOf(".js");
        typeName = typeName.substring(0, end);
        typeName = typeName.replace("\\", ".");
        typeName = typeName.replace("/", ".");
        InputStream stream = jarFile.getInputStream(elem);
        byte[] bs = new byte[stream.available()];
        stream.read(bs);
        stream.close();
        String source = new String(bs);
        File f = null;
        f = new File(String.valueOf(jarFile.getName()) + "!" + elem.getName());
        IJstTypeLoader.SourceType srcType = new IJstTypeLoader.SourceType(groupName, typeName, source, f);
        return srcType;
    }
}

