/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.validation;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class Vjet2CorePreferences {
    private final String propertyNamespace;
    private IEclipsePreferences preferences;

    private Vjet2CorePreferences(IProject project, String qualifier) {
        this.propertyNamespace = String.valueOf(qualifier) + '.';
        this.preferences = this.getEclipsePreferences(project, qualifier);
    }

    public static Vjet2CorePreferences getProjectPreferences(IProject project) {
        return Vjet2CorePreferences.getProjectPreferences(project, "org.eclipse.vjet.eclipse.core");
    }

    public static Vjet2CorePreferences getProjectPreferences(IProject project, String qualifier) {
        return new Vjet2CorePreferences(project, qualifier);
    }

    private IEclipsePreferences getEclipsePreferences(IProject project, String qualifier) {
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode(qualifier);
        return node;
    }

    public void putString(String key, String value) {
        try {
            this.preferences.put(String.valueOf(this.propertyNamespace) + key, value);
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public void putBoolean(String key, boolean value) {
        try {
            this.preferences.putBoolean(String.valueOf(this.propertyNamespace) + key, value);
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public String getString(String key, String defaultValue) {
        return this.preferences.get(String.valueOf(this.propertyNamespace) + key, defaultValue);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.preferences.getBoolean(String.valueOf(this.propertyNamespace) + key, defaultValue);
    }

    public IEclipsePreferences getProjectPreferences() {
        return this.preferences;
    }
}

