/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.debug.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.vjet.eclipse.debug.ui.VjetDebugUIPlugin;

public final class DBGPScriptCacheManager {
    private static DBGPScriptCacheManager m_instance;
    private Map<IBreakpoint, IStorage> m_cache = new HashMap<IBreakpoint, IStorage>();

    private DBGPScriptCacheManager() {
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener(new IBreakpointListener(){

            public void breakpointAdded(IBreakpoint breakpoint) {
            }

            public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
            }

            public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
                DBGPScriptCacheManager.this.remove(breakpoint);
            }
        });
        PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                IBreakpoint[] breakpoints = breakpointManager.getBreakpoints("org.eclipse.vjet.eclipse.debug.vjetModel");
                try {
                    IBreakpoint[] iBreakpointArray = breakpoints;
                    int n = breakpoints.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBreakpoint bp = iBreakpointArray[n2];
                        String location = bp.getMarker().getAttribute("location", "");
                        if (location != null && location.startsWith("dbgp")) {
                            breakpointManager.removeBreakpoint(bp, true);
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    VjetDebugUIPlugin.error(e.getLocalizedMessage(), e);
                }
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        });
    }

    public static synchronized DBGPScriptCacheManager getDefault() {
        if (m_instance == null) {
            m_instance = new DBGPScriptCacheManager();
        }
        return m_instance;
    }

    public void add(IBreakpoint key, IStorage value) {
        this.m_cache.put(key, value);
    }

    public void clear() {
        this.m_cache.clear();
    }

    public boolean contains(IBreakpoint key) {
        return this.m_cache.containsKey(key);
    }

    public IStorage get(IBreakpoint breakpoint) {
        return this.m_cache.get(breakpoint);
    }

    public void remove(IBreakpoint key) {
        this.m_cache.remove(key);
    }
}

