/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.javatojs.core;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.vjet.core.codegen.bootstrap.CodeGenInputEntity;
import org.eclipse.vjet.core.codegen.bootstrap.CodeGenOutputEntity;
import org.eclipse.vjet.core.codegen.bootstrap.CodeGenOutputType;
import org.eclipse.vjet.core.codegen.bootstrap.CodeGenStatus;
import org.eclipse.vjet.core.codegen.bootstrap.CodeGeneratorMarker;
import org.eclipse.vjet.core.codegen.bootstrap.ICodeGenTool;
import org.eclipse.vjet.core.codegen.bootstrap.ICodeGeneratorInput;
import org.eclipse.vjet.core.codegen.bootstrap.ICodeGeneratorMarker;
import org.eclipse.vjet.core.codegen.bootstrap.IJava2JsCodeGenInput;
import org.eclipse.vjet.core.codegen.bootstrap.IJava2JsCodeGenOutput;
import org.eclipse.vjet.core.codegen.bootstrap.IJava2JsCodeGenTool;
import org.eclipse.vjet.core.codegen.bootstrap.IToolMonitor;
import org.eclipse.vjet.core.codegen.bootstrap.Java2JsCodeGenInput;
import org.eclipse.vjet.core.codegen.bootstrap.Java2JsCodeGenOutput;
import org.eclipse.vjet.core.codegen.bootstrap.ResourceValidationException;
import org.eclipse.vjet.core.codegen.bootstrap.StatusCode;
import org.eclipse.vjet.dsf.javatojs.control.ICodeGenPathResolver;
import org.eclipse.vjet.dsf.javatojs.trace.TranslateError;
import org.eclipse.vjet.dsf.javatojs.translate.config.CodeGenConfig;
import org.eclipse.vjet.dsf.javatojs.util.VjoFiler;
import org.eclipse.vjet.dsf.jsgen.shared.generate.CodeStyle;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.logger.LogLevel;
import org.eclipse.vjet.dsf.util.JavaSourceLocator;
import org.eclipse.vjet.eclipse.javatojs.core.PluginCodeGenHelper;

public class JavaToJsCodeGenTool
implements IJava2JsCodeGenTool,
ICodeGenTool {
    private static final String VJO_FILE_EXT = ".js";
    private static final String JSR_FILE_EXT = "Jsr.java";
    private static final String JAVA_FILE_EXT = ".java";
    public static final String JAVA_SOURCE_PATH = "java.source.path";

    public List<CodeGenStatus> validate(CodeGenInputEntity arg0) {
        CodeGenStatus status = null;
        try {
            status = new CodeGenStatus(StatusCode.Success);
        }
        catch (ResourceValidationException e) {
            status = new CodeGenStatus(StatusCode.Error);
            status.setThrowable((Throwable)e);
            status.setMessage(e.getMessage());
        }
        ArrayList<CodeGenStatus> statusCollection = new ArrayList<CodeGenStatus>();
        statusCollection.add(status);
        return statusCollection;
    }

    public List<CodeGenStatus> generate(CodeGenInputEntity inputEntity, List<CodeGenOutputEntity> outputCollection) {
        ArrayList<CodeGenStatus> statusCollection = new ArrayList<CodeGenStatus>(outputCollection.size());
        try {
            URL inputURL = (URL)inputEntity.getData();
            if (inputURL == null) {
                throw new RuntimeException("inputEntity.getData() is null");
            }
            CodeGenConfig config = new CodeGenConfig();
            PluginCodeGenHelper helper = new PluginCodeGenHelper(config);
            List<JstType> jstTypes = helper.toJst(inputURL);
            if (!helper.getAllErrors().isEmpty()) {
                List<TranslateError> errors = helper.getAllErrors();
                CodeGenStatus status = null;
                for (TranslateError error : errors) {
                    if (error.getLevel().equals((Object)LogLevel.ERROR)) {
                        status = new CodeGenStatus(StatusCode.Error);
                    } else if (error.getLevel().equals((Object)LogLevel.WARN)) {
                        status = new CodeGenStatus(StatusCode.Warning);
                    } else {
                        if (!error.getLevel().equals((Object)LogLevel.FATAL)) continue;
                        status = new CodeGenStatus(StatusCode.FatalError);
                    }
                    status.setMessage(error.getMsg());
                    status.setLineNumber((int)error.getSrcLineNo());
                    statusCollection.add(status);
                }
            }
            for (CodeGenOutputEntity output : outputCollection) {
                try {
                    if (output.getType() == CodeGenOutputType.Vjo) {
                        output.getOutputStream().write(helper.toVjo(jstTypes.get(0), CodeStyle.PRETTY));
                    } else if (output.getType() == CodeGenOutputType.Jsr && config.shouldGenJsr()) {
                        output.getOutputStream().write(helper.toJsr(jstTypes.get(0), CodeStyle.PRETTY, true));
                    } else {
                        output.getOutputStream().write("Invalid codegen type:" + output.getType());
                    }
                    output.getOutputStream().flush();
                    output.getOutputStream().close();
                    CodeGenStatus status = new CodeGenStatus(StatusCode.Success);
                    status.setLineNumber(1);
                    status.setMessage("Successfully generated: " + output.getName());
                    statusCollection.add(status);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CodeGenStatus status = new CodeGenStatus(StatusCode.Error);
                    status.setMessage(e.getMessage());
                    status.setLineNumber(1);
                    status.setThrowable((Throwable)e);
                    statusCollection.add(status);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CodeGenStatus status = new CodeGenStatus(StatusCode.Error);
            status.setMessage(e.getMessage());
            status.setLineNumber(1);
            status.setThrowable((Throwable)e);
            statusCollection.add(status);
        }
        return statusCollection;
    }

    public List<CodeGenOutputEntity> getOutputEntities(CodeGenInputEntity inputEntity) {
        ArrayList<CodeGenOutputEntity> outputEntities = new ArrayList<CodeGenOutputEntity>();
        String inFileName = inputEntity.getName();
        if (!JavaToJsCodeGenTool.isValidInputFile(inFileName)) {
            throw new IllegalArgumentException("Unknown input file type: " + inFileName);
        }
        CodeGenOutputEntity vjoOut = new CodeGenOutputEntity();
        String vjoFileName = JavaToJsCodeGenTool.formatGeneratedName(inFileName, VJO_FILE_EXT);
        vjoOut.setName(vjoFileName);
        vjoOut.setType(CodeGenOutputType.Vjo);
        outputEntities.add(vjoOut);
        CodeGenOutputEntity jsrOut = new CodeGenOutputEntity();
        String jsrFileName = JavaToJsCodeGenTool.formatGeneratedName(inFileName, JSR_FILE_EXT);
        jsrOut.setName(jsrFileName);
        jsrOut.setType(CodeGenOutputType.Jsr);
        outputEntities.add(jsrOut);
        return outputEntities;
    }

    private static boolean isValidInputFile(String fileName) {
        return fileName.endsWith(JAVA_FILE_EXT);
    }

    private static String formatGeneratedName(String name, String ext) {
        String s = name;
        int index = s.indexOf(".");
        if (index > 0) {
            s = s.substring(0, index);
        }
        if (s.length() > 0 && !Character.isUpperCase(s.charAt(0))) {
            char c = Character.toUpperCase(s.charAt(0));
            s = s.length() > 1 ? String.valueOf(c) + s.substring(1) : String.valueOf(c);
        }
        return String.valueOf(s) + ext;
    }

    public List<IJava2JsCodeGenOutput> generate(List<IJava2JsCodeGenInput> input, IToolMonitor monitor) {
        monitor.beginTask("Java to JS code generation", input.size());
        ArrayList<IJava2JsCodeGenOutput> output = new ArrayList<IJava2JsCodeGenOutput>();
        for (IJava2JsCodeGenInput codeGenInput : input) {
            try {
                this.generate(codeGenInput, monitor, output);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        monitor.done();
        return output;
    }

    private void generate(IJava2JsCodeGenInput input, IToolMonitor monitor, List<IJava2JsCodeGenOutput> output) throws MalformedURLException {
        URL inputURL;
        if (input != null && input.getJavaSourcePath() != null) {
            System.setProperty(JAVA_SOURCE_PATH, input.getJavaSourcePath());
            JavaSourceLocator.getInstance().reset();
        }
        if ((inputURL = input.getUrl()) == null) {
            throw new RuntimeException("IJava2JsCodeGenInput.getUrl() is null");
        }
        if (inputURL.toExternalForm().endsWith(JSR_FILE_EXT)) {
            return;
        }
        Properties configProp = input.getJava2JsProperties();
        if (configProp == null) {
            throw new RuntimeException("IJava2JsCodeGenInput.getJava2JsProperties() is null");
        }
        CodeGenConfig config = new CodeGenConfig(configProp);
        PluginCodeGenHelper helper = new PluginCodeGenHelper(config, monitor);
        List<JstType> jstTypes = helper.toJst(inputURL);
        List<IJava2JsCodeGenInput> inputs = this.write(jstTypes, helper, output);
        if (!helper.getAllErrors().isEmpty()) {
            output.addAll(this.processErrors(inputs, helper.getAllErrors()));
        }
    }

    private List<IJava2JsCodeGenOutput> processErrors(List<IJava2JsCodeGenInput> inputs, List<TranslateError> allErrors) {
        ArrayList<IJava2JsCodeGenOutput> outputs = new ArrayList<IJava2JsCodeGenOutput>();
        for (TranslateError error : allErrors) {
            IJava2JsCodeGenInput input;
            if (error.getSrcName() == null || (input = this.findInput(error, inputs)) == null) continue;
            Java2JsCodeGenOutput out = new Java2JsCodeGenOutput();
            out.setInput((ICodeGeneratorInput)input);
            out.setUrl(input.getUrl());
            this.setMarkers(out.getMarkers(), error);
            outputs.add((IJava2JsCodeGenOutput)out);
        }
        return outputs;
    }

    private IJava2JsCodeGenInput findInput(TranslateError error, List<IJava2JsCodeGenInput> inputs) {
        for (IJava2JsCodeGenInput input : inputs) {
            String source = String.valueOf(error.getSrcName().replace('.', '/')) + JAVA_FILE_EXT;
            String url = input.getUrl().toExternalForm();
            if (!url.endsWith(source)) continue;
            return input;
        }
        return null;
    }

    private List<IJava2JsCodeGenInput> write(List<JstType> jstTypes, PluginCodeGenHelper helper, List<IJava2JsCodeGenOutput> output) throws MalformedURLException {
        ArrayList<IJava2JsCodeGenInput> inputs = new ArrayList<IJava2JsCodeGenInput>();
        for (JstType jst : jstTypes) {
            URL inputUrl = ICodeGenPathResolver.DEFAULT.getJavaFilePath(jst);
            Java2JsCodeGenInput input = new Java2JsCodeGenInput();
            input.setUrl(inputUrl);
            inputs.add((IJava2JsCodeGenInput)input);
            URL vjoFilePath = ICodeGenPathResolver.DEFAULT.getVjoFilePath(jst);
            VjoFiler.writeToFile((URL)vjoFilePath, (String)helper.toVjo(jst, CodeStyle.PRETTY));
            Java2JsCodeGenOutput out = new Java2JsCodeGenOutput();
            out.setUrl(vjoFilePath);
            out.setInput((ICodeGeneratorInput)input);
            output.add((IJava2JsCodeGenOutput)out);
            if (!helper.getConfig().shouldGenJsr()) continue;
            URL jsrFilePath = ICodeGenPathResolver.DEFAULT.getJsrFilePath(jst);
            VjoFiler.writeToFile((URL)jsrFilePath, (String)helper.toJsr(jst, CodeStyle.PRETTY, true));
            out = new Java2JsCodeGenOutput();
            out.setUrl(jsrFilePath);
            out.setInput((ICodeGeneratorInput)input);
            output.add((IJava2JsCodeGenOutput)out);
        }
        return inputs;
    }

    private void setMarkers(List<ICodeGeneratorMarker> markers, TranslateError error) {
        CodeGeneratorMarker status = new CodeGeneratorMarker();
        if (error.getLevel().equals((Object)LogLevel.ERROR)) {
            status.setStatus(StatusCode.Error);
        } else if (error.getLevel().equals((Object)LogLevel.WARN)) {
            status.setStatus(StatusCode.Warning);
        } else if (error.getLevel().equals((Object)LogLevel.FATAL)) {
            status.setStatus(StatusCode.FatalError);
        } else {
            return;
        }
        status.setMessage(error.getMsg());
        int line = (int)(error.getSrcLineNo() == 0L ? 1L : error.getSrcLineNo());
        status.setLineNumber(line);
        markers.add((ICodeGeneratorMarker)status);
    }
}

