/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.javatojs.ui.markers;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.vjet.core.codegen.bootstrap.ICodeGeneratorMarker;
import org.eclipse.vjet.core.codegen.bootstrap.IJava2JsCodeGenInput;
import org.eclipse.vjet.core.codegen.bootstrap.IJava2JsCodeGenOutput;
import org.eclipse.vjet.core.codegen.bootstrap.StatusCode;
import org.eclipse.vjet.eclipse.javatojs.ui.Java2JsPlugin;

public class Java2JsMarker {
    public static void mark(IJava2JsCodeGenOutput output) {
        URI uri;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            uri = output.getUrl().toURI();
        }
        catch (URISyntaxException e) {
            Java2JsPlugin.logException(e);
            return;
        }
        IFile[] files = root.findFilesForLocationURI(uri);
        if (files != null && files.length > 0 && files[0].exists()) {
            IFile file = files[0];
            Java2JsMarker.clearMarkers((IResource)file);
            for (ICodeGeneratorMarker marker : output.getMarkers()) {
                try {
                    IMarker mark = file.createMarker("org.eclipse.vjet.eclipse.javatojs.ui.codeGenProblemMarker");
                    mark.setAttributes(Java2JsMarker.createAttributes(marker));
                }
                catch (CoreException e) {
                    Java2JsPlugin.logException((Exception)((Object)e));
                }
            }
        }
    }

    public static void clearMarkers(IResource file) {
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = file.findMarkers("org.eclipse.vjet.eclipse.javatojs.ui.codeGenProblemMarker", true, 2);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker mark = iMarkerArray[n2];
                mark.delete();
                ++n2;
            }
        }
        catch (CoreException e) {
            Java2JsPlugin.logException((Exception)((Object)e));
        }
    }

    public static void clearMarkers(IJava2JsCodeGenOutput output) {
        if (output instanceof IAdaptable) {
            IResource resource = (IResource)((IAdaptable)output).getAdapter(IResource.class);
            Java2JsMarker.clearMarkers(resource);
        }
    }

    public static void clearMarkers(IJava2JsCodeGenInput input) {
        if (input instanceof IAdaptable) {
            IResource resource = (IResource)((IAdaptable)input).getAdapter(IResource.class);
            Java2JsMarker.clearMarkers(resource);
        }
    }

    public static Map<String, Object> createAttributes(ICodeGeneratorMarker marker) {
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("lineNumber", new Integer(marker.getLineNumber()));
        if (marker.getStartChar() != -1) {
            map.put("charStart", new Integer(marker.getStartChar()));
        }
        if (marker.getEndChar() != -1) {
            map.put("charEnd", new Integer(marker.getEndChar()));
        }
        map.put("severity", Java2JsMarker.getMarkerSeverity(marker.getStatus()));
        map.put("message", marker.getMessage());
        map.put("priority", 1);
        return map;
    }

    public static Integer getMarkerSeverity(StatusCode status) {
        switch (status) {
            case Success: {
                return 0;
            }
            case Warning: {
                return 1;
            }
            case Error: {
                return 2;
            }
            case FatalError: {
                return 2;
            }
        }
        return 0;
    }
}

