/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.launching;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.sourcelookup.IPersistableSourceLocator2;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputer;
import org.eclipse.dltk.mod.internal.debug.core.model.ScriptStackFrame;
import org.eclipse.vjet.vjo.tool.codecompletion.StringUtils;

public class SourceLocatorProxy
implements ISourceLookupDirector {
    private ISourceLocator m_js;
    private boolean m_jsIsDirector;
    private boolean m_jsIsPersistable;
    private boolean m_jsIsPersistable2;
    private ISourceLocator m_orig;
    private boolean m_origIsDirector;
    private boolean m_origIsPersistable;
    private boolean m_origIsPersistable2;

    public SourceLocatorProxy(ISourceLocator orig, ISourceLocator delegate) {
        this.m_orig = orig;
        this.m_js = delegate;
        this.m_origIsDirector = this.m_orig instanceof ISourceLookupDirector;
        this.m_jsIsDirector = this.m_js instanceof ISourceLookupDirector;
        this.m_origIsPersistable2 = this.m_orig instanceof IPersistableSourceLocator2;
        this.m_jsIsPersistable2 = this.m_js instanceof IPersistableSourceLocator2;
        this.m_origIsPersistable = this.m_orig instanceof IPersistableSourceLocator;
        this.m_jsIsPersistable = this.m_js instanceof IPersistableSourceLocator;
    }

    public void addParticipants(ISourceLookupParticipant[] participants) {
        if (this.m_origIsDirector) {
            this.getOriginalDirector().addParticipants(participants);
        }
        if (this.m_jsIsDirector) {
            this.getJsDirector().addParticipants(participants);
        }
    }

    public void clearSourceElements(Object element) {
        if (this.m_origIsDirector) {
            this.getOriginalDirector().clearSourceElements(element);
        }
        if (this.m_jsIsDirector) {
            this.getJsDirector().clearSourceElements(element);
        }
    }

    public void dispose() {
        if (this.m_origIsPersistable2) {
            this.getOriginalPersistable2().dispose();
        }
        if (this.m_jsIsPersistable2) {
            this.getJsPersistable2().dispose();
        }
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        HashSet<Object> elements = new HashSet<Object>(0);
        if (this.m_origIsDirector) {
            elements.addAll(Arrays.asList(this.getOriginalDirector().findSourceElements(object)));
        }
        if (this.m_jsIsDirector) {
            elements.addAll(Arrays.asList(this.getJsDirector().findSourceElements(object)));
        }
        return elements.toArray();
    }

    public String getId() {
        String id = null;
        if (this.m_origIsDirector) {
            id = this.getOriginalDirector().getId();
        }
        if (StringUtils.isBlankOrEmpty(id) && this.m_jsIsDirector) {
            id = this.getJsDirector().getId();
        }
        return id;
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        ILaunchConfiguration config = null;
        if (this.m_origIsDirector) {
            config = this.getOriginalDirector().getLaunchConfiguration();
        }
        if (config == null && this.m_jsIsDirector) {
            config = this.getJsDirector().getLaunchConfiguration();
        }
        return config;
    }

    public String getMemento() throws CoreException {
        String memento = null;
        if (this.m_origIsPersistable) {
            memento = this.getOriginalPersistable().getMemento();
        }
        if (StringUtils.isBlankOrEmpty(memento) && this.m_jsIsPersistable) {
            memento = this.getJsPersistable().getMemento();
        }
        return memento;
    }

    public ISourceLookupParticipant[] getParticipants() {
        HashSet<ISourceLookupParticipant> participants = new HashSet<ISourceLookupParticipant>(0);
        if (this.m_origIsDirector) {
            participants.addAll(Arrays.asList(this.getOriginalDirector().getParticipants()));
        }
        if (this.m_jsIsDirector) {
            participants.addAll(Arrays.asList(this.getJsDirector().getParticipants()));
        }
        return participants.toArray(new ISourceLookupParticipant[participants.size()]);
    }

    public ISourceContainer[] getSourceContainers() {
        HashSet<ISourceContainer> containers = new HashSet<ISourceContainer>(0);
        if (this.m_origIsDirector) {
            containers.addAll(Arrays.asList(this.getOriginalDirector().getSourceContainers()));
        }
        if (this.m_jsIsDirector) {
            containers.addAll(Arrays.asList(this.getJsDirector().getSourceContainers()));
        }
        return containers.toArray(new ISourceContainer[containers.size()]);
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        if (stackFrame instanceof ScriptStackFrame) {
            return this.m_js.getSourceElement(stackFrame);
        }
        return this.m_orig.getSourceElement(stackFrame);
    }

    public Object getSourceElement(Object element) {
        Object sourceElement = null;
        if (this.m_origIsDirector) {
            sourceElement = this.getOriginalDirector().getSourceElement(element);
        }
        if (sourceElement == null && this.m_jsIsDirector) {
            sourceElement = this.getJsDirector().getSourceElement(element);
        }
        return sourceElement;
    }

    public ISourcePathComputer getSourcePathComputer() {
        ISourcePathComputer computer = null;
        if (this.m_origIsDirector) {
            computer = this.getOriginalDirector().getSourcePathComputer();
        }
        if (computer == null && this.m_jsIsDirector) {
            computer = this.getJsDirector().getSourcePathComputer();
        }
        return computer;
    }

    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
        if (this.m_origIsPersistable) {
            this.getOriginalDirector().initializeDefaults(configuration);
        }
        if (this.m_jsIsPersistable) {
            this.getJsDirector().initializeDefaults(configuration);
        }
    }

    public void initializeFromMemento(String memento) throws CoreException {
        if (this.m_origIsPersistable) {
            this.getOriginalDirector().initializeFromMemento(memento);
        }
        if (this.m_jsIsPersistable) {
            this.getJsDirector().initializeFromMemento(memento);
        }
    }

    public void initializeFromMemento(String memento, ILaunchConfiguration configuration) throws CoreException {
        if (this.m_origIsPersistable) {
            this.getOriginalDirector().initializeFromMemento(memento, configuration);
        }
        if (this.m_jsIsPersistable) {
            this.getJsDirector().initializeFromMemento(memento, configuration);
        }
    }

    public void initializeParticipants() {
        if (this.m_origIsDirector) {
            this.getOriginalDirector().initializeParticipants();
        }
        if (this.m_jsIsDirector) {
            this.getJsDirector().initializeParticipants();
        }
    }

    public boolean isFindDuplicates() {
        boolean duplicates = false;
        if (this.m_origIsDirector) {
            duplicates = this.getOriginalDirector().isFindDuplicates();
        }
        if (!duplicates && this.m_jsIsDirector) {
            duplicates = this.getJsDirector().isFindDuplicates();
        }
        return duplicates;
    }

    public void removeParticipants(ISourceLookupParticipant[] participants) {
        if (this.m_origIsDirector) {
            this.getOriginalDirector().removeParticipants(participants);
        }
        if (this.m_jsIsDirector) {
            this.getJsDirector().removeParticipants(participants);
        }
    }

    public void setFindDuplicates(boolean findDuplicates) {
        if (this.m_origIsDirector) {
            this.getOriginalDirector().setFindDuplicates(findDuplicates);
        }
        if (this.m_jsIsDirector) {
            this.getJsDirector().setFindDuplicates(findDuplicates);
        }
    }

    public void setSourceContainers(ISourceContainer[] containers) {
        if (this.m_origIsDirector) {
            this.getOriginalDirector().setSourceContainers(containers);
        }
        if (this.m_jsIsDirector) {
            this.getJsDirector().setSourceContainers(containers);
        }
    }

    public void setSourcePathComputer(ISourcePathComputer computer) {
        if (this.m_origIsDirector) {
            this.getOriginalDirector().setSourceContainers(this.getSourceContainers());
        }
        if (this.m_jsIsDirector) {
            this.getJsDirector().setSourceContainers(this.getSourceContainers());
        }
    }

    public boolean supportsSourceContainerType(ISourceContainerType type) {
        boolean support = false;
        if (this.m_origIsDirector) {
            support = this.getOriginalDirector().supportsSourceContainerType(type);
        }
        if (!support && this.m_jsIsDirector) {
            support = this.getJsDirector().supportsSourceContainerType(type);
        }
        return support;
    }

    private ISourceLookupDirector getJsDirector() {
        return (ISourceLookupDirector)this.m_js;
    }

    private IPersistableSourceLocator getJsPersistable() {
        return (IPersistableSourceLocator)this.m_js;
    }

    private IPersistableSourceLocator2 getJsPersistable2() {
        return (IPersistableSourceLocator2)this.m_js;
    }

    private ISourceLookupDirector getOriginalDirector() {
        return (ISourceLookupDirector)this.m_orig;
    }

    private IPersistableSourceLocator getOriginalPersistable() {
        return (IPersistableSourceLocator)this.m_orig;
    }

    private IPersistableSourceLocator2 getOriginalPersistable2() {
        return (IPersistableSourceLocator2)this.m_orig;
    }
}

