/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.ModelElement;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.internal.core.builder.StandardScriptBuilder;
import org.eclipse.dltk.mod.internal.corext.util.Messages;
import org.eclipse.dltk.mod.internal.ui.DLTKUIMessages;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.vjo.tool.typespace.SourceTypeName;

public class VjoValidationAction
implements IExecutableExtension,
IObjectActionDelegate {
    private static final String VJOSUBFIX = ".js";
    ISelection selection;
    private List<IProject> m_project;

    public void run(IAction action) {
        if (!(this.selection instanceof IStructuredSelection)) {
            return;
        }
        ScriptProject sProject = null;
        for (IProject project : this.m_project) {
            sProject = CodeassistUtils.getScriptProject((String)project.getName());
            if (sProject == null) {
                return;
            }
            ArrayList<ISourceModule> selectedSourceModules = new ArrayList<ISourceModule>();
            IStructuredSelection structuredSelection = (IStructuredSelection)this.selection;
            Object[] selectionElements = structuredSelection.toArray();
            int i = 0;
            while (i < selectionElements.length) {
                Object selectionElement = selectionElements[i];
                if (selectionElement instanceof IFile) {
                    this.addSourceModules(selectedSourceModules, (IResource)selectionElement, sProject);
                } else if (selectionElement instanceof IFolder) {
                    this.getFilesFromFolder(selectedSourceModules, (IFolder)selectionElement, sProject);
                } else {
                    this.getAllFilesFromProject(selectedSourceModules, sProject);
                }
                ++i;
            }
            new VJetValidateBuildJob(DLTKUIMessages.CoreUtility_job_title, project, selectedSourceModules).schedule();
        }
    }

    private SourceTypeName getFileQulifieName(IResource resource) {
        if (resource instanceof IFile && resource.getLocationURI().getPath().endsWith(VJOSUBFIX)) {
            return CodeassistUtils.getTypeName((IResource)resource);
        }
        return null;
    }

    private void getAllFiles(ArrayList<ISourceModule> resourceList, IFolder folder, ScriptProject sProject) {
        try {
            IResource[] memebrs;
            IResource[] iResourceArray = memebrs = folder.members();
            int n = memebrs.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    if (file.getLocation().toOSString().endsWith(VJOSUBFIX)) {
                        this.addSourceModules(resourceList, (IResource)file, sProject);
                    }
                } else if (resource instanceof IFolder) {
                    IFolder resourceFolder = (IFolder)resource;
                    this.getAllFiles(resourceList, resourceFolder, sProject);
                }
                ++n2;
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }

    private void getFilesFromFolder(ArrayList<ISourceModule> selectedSourceModules, IFolder folder, ScriptProject sProject) {
        this.getAllFiles(selectedSourceModules, folder, sProject);
    }

    private void getChildrenFromFragment(ArrayList<ISourceModule> resourceList, IModelElement[] element, ScriptProject sProject) throws ModelException {
        IResource resource = null;
        IModelElement[] iModelElementArray = element;
        int n = element.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElement[] elements;
            IModelElement pf = iModelElementArray[n2];
            IModelElement[] iModelElementArray2 = elements = ((ModelElement)pf).getChildren();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IModelElement[] files;
                IModelElement modelElement = iModelElementArray2[n4];
                IModelElement[] iModelElementArray3 = files = ((ModelElement)modelElement).getChildren();
                int n5 = files.length;
                int n6 = 0;
                while (n6 < n5) {
                    IModelElement file = iModelElementArray3[n6];
                    if (file.getElementType() == 5 && (resource = file.getResource()) != null && resource.getLocationURI().getPath().endsWith(VJOSUBFIX)) {
                        this.addSourceModules(resourceList, resource, sProject);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void getAllFilesFromProject(ArrayList<ISourceModule> selectedSourceModules, ScriptProject sp) {
        try {
            IModelElement[] frags = sp.getChildren();
            this.getChildrenFromFragment(selectedSourceModules, frags, sp);
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
    }

    private void addSourceModules(List<ISourceModule> selectedSourceModules, IResource selectionElement, ScriptProject sProject) {
        ISourceModule module = null;
        if (!selectedSourceModules.contains(selectionElement) && (module = this.getModuleFromResource(selectionElement, sProject)) != null && module.getElementType() == 5) {
            selectedSourceModules.add(module);
        }
    }

    private ISourceModule getModuleFromResource(IResource selectionElement, ScriptProject sProject) {
        SourceTypeName typeName = null;
        ISourceModule module = null;
        IType type = null;
        typeName = this.getFileQulifieName(selectionElement);
        if (typeName != null && (type = CodeassistUtils.findType((ScriptProject)sProject, (String)typeName.typeName())) != null) {
            module = type.getSourceModule();
        }
        return module;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        this.m_project = new ArrayList<IProject>();
        IStructuredSelection selections = (IStructuredSelection)selection;
        for (IAdaptable adaptable : selections) {
            if (adaptable == null) {
                return;
            }
            IResource resource = (IResource)adaptable.getAdapter(IResource.class);
            IProject project = resource.getProject();
            if (project == null) {
                return;
            }
            this.m_project.add(project);
            boolean hasVJONature = this.hasVJONature(project);
            boolean hasVJOBuilder = this.hasVJOBuilder(project);
            if (hasVJONature && hasVJOBuilder) {
                action.setEnabled(true);
                continue;
            }
            action.setEnabled(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasVJONature(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            ICommand[] buildCommands = description.getBuildSpec();
            int i = 0;
            while (true) {
                if (i >= buildCommands.length) {
                    return false;
                }
                if ("org.eclipse.vjet.eclipse.core.builder".equals(buildCommands[i].getBuilderName())) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean hasVJOBuilder(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            return description.hasNature("org.eclipse.vjet.core.nature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public List<IProject> getM_project() {
        return this.m_project;
    }

    private static final class VJetValidateBuildJob
    extends Job {
        private final IProject fProject;
        private ArrayList<ISourceModule> selectedSourceModules = null;

        private VJetValidateBuildJob(String name, IProject project, ArrayList<ISourceModule> selectedSourceModules) {
            super(name);
            this.fProject = project;
            this.selectedSourceModules = selectedSourceModules;
        }

        public boolean isCoveredBy(VJetValidateBuildJob other) {
            if (other.fProject == null) {
                return true;
            }
            return this.fProject != null && this.fProject.equals((Object)other.fProject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            synchronized (clazz) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Job[] buildJobs = Job.getJobManager().find(ResourcesPlugin.FAMILY_MANUAL_BUILD);
                int i = 0;
                while (i < buildJobs.length) {
                    VJetValidateBuildJob job;
                    Job curr = buildJobs[i];
                    if (curr != this && curr instanceof VJetValidateBuildJob && (job = (VJetValidateBuildJob)curr).isCoveredBy(this)) {
                        curr.cancel();
                    }
                    ++i;
                }
            }
            try {
                IStatus iStatus;
                try {
                    if (this.fProject != null) {
                        monitor.beginTask(Messages.format((String)DLTKUIMessages.CoreUtility_buildproject_taskname, (Object)this.fProject.getName()), 2);
                        StandardScriptBuilder sb = new StandardScriptBuilder();
                        ScriptProject sProject = CodeassistUtils.getScriptProject((String)this.fProject.getName());
                        sb.initialize((IScriptProject)sProject);
                        sb.buildModelElements((IScriptProject)sProject, this.selectedSourceModules, (IProgressMonitor)new SubProgressMonitor(monitor, 1), 1);
                        DLTKUIPlugin.getWorkspace().build(10, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                }
                catch (CoreException e) {
                    iStatus = e.getStatus();
                    monitor.done();
                    return iStatus;
                }
                catch (OperationCanceledException operationCanceledException) {
                    iStatus = Status.CANCEL_STATUS;
                    monitor.done();
                    return iStatus;
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
        }
    }
}

