/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.preferences.codestyle;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.mod.internal.ui.preferences.ScriptSourcePreviewerUpdater;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.dltk.mod.ui.DLTKUILanguageManager;
import org.eclipse.dltk.mod.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.mod.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.mod.ui.text.ScriptTextTools;
import org.eclipse.dltk.mod.ui.util.PixelConverter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.vjet.eclipse.internal.ui.preferences.codestyle.ProjectTemplateStore;
import org.eclipse.vjet.eclipse.internal.ui.preferences.codestyle.TemplateVariableProcessor;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;

public class CodeTemplateBlock {
    private static final int IDX_EDIT = 0;
    private static final int IDX_IMPORT = 2;
    private static final int IDX_EXPORT = 3;
    private static final int IDX_EXPORTALL = 4;
    protected static final Object COMMENT_NODE = "Comment";
    private TreeListDialogField fCodeTemplateTree;
    protected ProjectTemplateStore fTemplateStore;
    private PixelConverter fPixelConverter;
    private SourceViewer fPatternViewer;
    private Control fSWTWidget;
    private TemplateVariableProcessor fTemplateProcessor;
    private final IProject fProject;

    public CodeTemplateBlock(IProject project) {
        this.fProject = project;
        this.fTemplateStore = new ProjectTemplateStore(project);
        try {
            this.fTemplateStore.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.fTemplateProcessor = new TemplateVariableProcessor();
        CodeTemplateAdapter adapter = new CodeTemplateAdapter();
        String[] stringArray = new String[5];
        stringArray[0] = "Edit";
        stringArray[2] = "Import";
        stringArray[3] = "Export";
        stringArray[4] = "Export All";
        String[] buttonLabels = stringArray;
        this.fCodeTemplateTree = new TreeListDialogField((ITreeListAdapter)adapter, buttonLabels, (ILabelProvider)new CodeTemplateLabelProvider());
        this.fCodeTemplateTree.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fCodeTemplateTree.setLabelText("Code Template Block");
        this.fCodeTemplateTree.setViewerSorter((ViewerSorter)adapter);
        this.fCodeTemplateTree.enableButton(3, false);
        this.fCodeTemplateTree.enableButton(0, false);
        this.fCodeTemplateTree.addElement(COMMENT_NODE);
        this.fCodeTemplateTree.selectFirstElement();
    }

    public void postSetSelection(Object element) {
        this.fCodeTemplateTree.postSetSelection((ISelection)new StructuredSelection(element));
    }

    public boolean hasProjectSpecificOptions(IProject project) {
        if (project != null) {
            return ProjectTemplateStore.hasProjectSpecificTempates(project);
        }
        return false;
    }

    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.fSWTWidget = parent;
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.fCodeTemplateTree.doFillIntoGrid(composite, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fCodeTemplateTree.getLabelControl(null), (int)2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fCodeTemplateTree.getTreeControl(null));
        this.fPatternViewer = this.createViewer(composite, 2);
        return composite;
    }

    private Shell getShell() {
        if (this.fSWTWidget != null) {
            return this.fSWTWidget.getShell();
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private SourceViewer createViewer(Composite parent, int nColumns) {
        Label label = new Label(parent, 0);
        label.setText("pattern");
        GridData data = new GridData();
        data.horizontalSpan = nColumns;
        label.setLayoutData((Object)data);
        Document document = new Document();
        IDLTKUILanguageToolkit toolkit = DLTKUILanguageManager.getLanguageToolkit((String)"org.eclipse.vjet.core.nature");
        ScriptTextTools textTools = toolkit.getTextTools();
        textTools.setupDocumentPartitioner((IDocument)document, toolkit.getPartitioningId());
        IPreferenceStore store = toolkit.getPreferenceStore();
        ScriptSourceViewer viewer = new ScriptSourceViewer(parent, null, null, false, 2816, store);
        ScriptSourceViewerConfiguration configuration = toolkit.createSourceViewerConfiguration();
        viewer.configure((SourceViewerConfiguration)configuration);
        viewer.setEditable(false);
        viewer.setDocument((IDocument)document);
        new ScriptSourcePreviewerUpdater((SourceViewer)viewer, configuration, store);
        Control control = viewer.getControl();
        data = new GridData(1296);
        data.horizontalSpan = nColumns;
        data.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)data);
        return viewer;
    }

    protected TemplatePersistenceData[] getTemplateOfCategory(boolean isComment) {
        ArrayList<TemplatePersistenceData> res = new ArrayList<TemplatePersistenceData>();
        TemplatePersistenceData[] templates = this.fTemplateStore.getTemplateData();
        int i = 0;
        while (i < templates.length) {
            TemplatePersistenceData curr = templates[i];
            if (isComment == curr.getTemplate().getName().endsWith("comment")) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray(new TemplatePersistenceData[res.size()]);
    }

    protected static boolean canEdit(List selected) {
        return selected.size() == 1 && selected.get(0) instanceof TemplatePersistenceData;
    }

    protected void updateSourceViewerInput(List selection) {
        if (this.fPatternViewer == null || this.fPatternViewer.getTextWidget().isDisposed()) {
            return;
        }
        if (selection.size() == 1 && selection.get(0) instanceof TemplatePersistenceData) {
            TemplatePersistenceData data = (TemplatePersistenceData)selection.get(0);
            Template template = data.getTemplate();
            TemplateContextType type = VjetUIPlugin.getDefault().getCodeTemplateContextRegistry().getContextType(template.getContextTypeId());
            this.fTemplateProcessor.setContextType(type);
            this.fPatternViewer.getDocument().set(template.getPattern());
        } else {
            this.fPatternViewer.getDocument().set("");
        }
    }

    protected void doButtonPressed(int buttonIndex, List selected) {
        if (buttonIndex == 0) {
            this.edit((TemplatePersistenceData)selected.get(0));
        } else if (buttonIndex == 3) {
            this.export(selected);
        } else if (buttonIndex == 4) {
            this.exportAll();
        } else if (buttonIndex == 2) {
            this.import_();
        }
    }

    private void edit(TemplatePersistenceData data) {
    }

    private void import_() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText("Import Template");
        String path = dialog.open();
        if (path == null) {
            return;
        }
        try {
            TemplateReaderWriter reader = new TemplateReaderWriter();
            File file = new File(path);
            if (file.exists()) {
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
                try {
                    TemplatePersistenceData[] datas = reader.read((InputStream)input, null);
                    int i = 0;
                    while (i < datas.length) {
                        this.updateTemplate(datas[i]);
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    ((InputStream)input).close();
                }
                catch (IOException iOException) {}
            }
            this.fCodeTemplateTree.refresh();
            this.updateSourceViewerInput(this.fCodeTemplateTree.getSelectedElements());
        }
        catch (FileNotFoundException e) {
            this.openReadErrorDialog(e);
        }
        catch (IOException e) {
            this.openReadErrorDialog(e);
        }
    }

    private void updateTemplate(TemplatePersistenceData data) {
        TemplatePersistenceData[] datas = this.fTemplateStore.getTemplateData();
        int i = 0;
        while (i < datas.length) {
            String id = datas[i].getId();
            if (id != null && id.equals(data.getId())) {
                datas[i].setTemplate(data.getTemplate());
                break;
            }
            ++i;
        }
    }

    private void exportAll() {
        this.export(this.fTemplateStore.getTemplateData());
    }

    private void export(List selected) {
        HashSet datas = new HashSet();
        int i = 0;
        while (i < selected.size()) {
            Object curr = selected.get(i);
            if (curr instanceof TemplatePersistenceData) {
                datas.add(curr);
            } else {
                TemplatePersistenceData[] cat = this.getTemplateOfCategory(curr == COMMENT_NODE);
                datas.addAll(Arrays.asList(cat));
            }
            ++i;
        }
        this.export(datas.toArray(new TemplatePersistenceData[datas.size()]));
    }

    private void export(TemplatePersistenceData[] templates) {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText("Export Template");
        dialog.setFileName("template.xml");
        String path = dialog.open();
        if (path == null) {
            return;
        }
        File file = new File(path);
        if (file.isHidden()) {
            String title = "Export failed";
            String message = "Export failed";
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        if (file.exists() && !file.canWrite()) {
            String title = "Export Failed";
            String message = "file is readonly";
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        if (!file.exists() || this.confirmOverwrite(file)) {
            OutputStream output = null;
            try {
                output = new BufferedOutputStream(new FileOutputStream(file));
                TemplateReaderWriter writer = new TemplateReaderWriter();
                writer.save(templates, output);
                output.close();
            }
            catch (IOException e) {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
                this.openWriteErrorDialog(e);
            }
        }
    }

    private boolean confirmOverwrite(File file) {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)"Already exists, overwrite?", (String)"Already exsits");
    }

    public void performDefaults() {
        this.fTemplateStore.restoreDefaults();
        this.fCodeTemplateTree.refresh();
        this.updateSourceViewerInput(this.fCodeTemplateTree.getSelectedElements());
    }

    public boolean performOk(boolean enabled) {
        if (this.fProject != null) {
            TemplatePersistenceData[] templateData = this.fTemplateStore.getTemplateData();
            int i = 0;
            while (i < templateData.length) {
                this.fTemplateStore.setProjectSpecific(templateData[i].getId(), enabled);
                ++i;
            }
        }
        try {
            this.fTemplateStore.save();
        }
        catch (IOException e) {
            this.openWriteErrorDialog(e);
        }
        return true;
    }

    public void performCancel() {
        try {
            this.fTemplateStore.revertChanges();
        }
        catch (IOException e) {
            this.openReadErrorDialog(e);
        }
    }

    private void openReadErrorDialog(Exception e) {
        String title = "read error";
        String message = e.getLocalizedMessage();
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    private void openWriteErrorDialog(Exception e) {
        String title = "write error";
        String message = "write error";
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    private class CodeTemplateAdapter
    extends ViewerSorter
    implements ITreeListAdapter,
    IDialogFieldListener {
        private final Object[] NO_CHILDREN = new Object[0];

        private CodeTemplateAdapter() {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            CodeTemplateBlock.this.doButtonPressed(index, field.getSelectedElements());
        }

        public void selectionChanged(TreeListDialogField field) {
            List selected = field.getSelectedElements();
            field.enableButton(0, CodeTemplateBlock.canEdit(selected));
            field.enableButton(3, !selected.isEmpty());
            CodeTemplateBlock.this.updateSourceViewerInput(selected);
        }

        public void doubleClicked(TreeListDialogField field) {
            List selected = field.getSelectedElements();
            if (CodeTemplateBlock.canEdit(selected)) {
                CodeTemplateBlock.this.doButtonPressed(0, selected);
            }
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element == COMMENT_NODE) {
                return CodeTemplateBlock.this.getTemplateOfCategory(element == COMMENT_NODE);
            }
            return this.NO_CHILDREN;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            TemplatePersistenceData data;
            if (element instanceof TemplatePersistenceData && (data = (TemplatePersistenceData)element).getTemplate().getName().endsWith("comment")) {
                return COMMENT_NODE;
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return element == COMMENT_NODE;
        }

        public void dialogFieldChanged(DialogField field) {
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
        }

        public int category(Object element) {
            if (element == COMMENT_NODE) {
                return 1;
            }
            TemplatePersistenceData data = (TemplatePersistenceData)element;
            String id = data.getId();
            if ("org.eclipse.vjet.eclipse.ui.text.codetemplates.Ctype".equals(id)) {
                return 101;
            }
            if ("org.eclipse.vjet.eclipse.ui.text.codetemplates.Interface".equals(id)) {
                return 101;
            }
            return 1000;
        }
    }

    private static class CodeTemplateLabelProvider
    extends LabelProvider {
        private CodeTemplateLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element == COMMENT_NODE) {
                return (String)element;
            }
            TemplatePersistenceData data = (TemplatePersistenceData)element;
            String id = data.getId();
            if ("org.eclipse.vjet.eclipse.ui.text.codetemplates.Ctype".equals(id)) {
                return "Ctype";
            }
            if ("org.eclipse.vjet.eclipse.ui.text.codetemplates.Interface".equals(id)) {
                return "Interface";
            }
            return data.getTemplate().getDescription();
        }
    }
}

