/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.refactoring.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.corext.refactoring.Checks;
import org.eclipse.dltk.mod.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.vjet.eclipse.internal.ui.refactoring.core.SearchResultGroup;

public class VjoChecks {
    private VjoChecks() {
    }

    public static SearchResultGroup[] excludeSourceModules(SearchResultGroup[] grouped, RefactoringStatus status) throws ModelException {
        ArrayList<SearchResultGroup> result = new ArrayList<SearchResultGroup>();
        boolean wasEmpty = grouped.length == 0;
        int i = 0;
        while (i < grouped.length) {
            IResource resource = grouped[i].getResource();
            IModelElement element = DLTKCore.create((IResource)resource);
            if (element instanceof ISourceModule) {
                ISourceModule cu = (ISourceModule)DLTKCore.create((IResource)resource);
                if (!cu.isStructureKnown()) {
                    String path = Checks.getFullPath((ISourceModule)cu);
                    status.addError(MessageFormat.format(RefactoringCoreMessages.Checks_cannot_be_parsed, path));
                } else {
                    result.add(grouped[i]);
                }
            }
            ++i;
        }
        if (!wasEmpty && result.isEmpty()) {
            status.addFatalError(RefactoringCoreMessages.Checks_all_excluded);
        }
        return result.toArray(new SearchResultGroup[result.size()]);
    }

    public static RefactoringStatus checkCompileErrorsInAffectedFile(SearchResultGroup[] grouped) throws ModelException {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < grouped.length) {
            Checks.checkCompileErrorsInAffectedFile((RefactoringStatus)result, (IResource)grouped[i].getResource());
            ++i;
        }
        return result;
    }
}

