/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate.config;

import java.io.FileFilter;
import java.util.Properties;
import org.eclipse.vjet.dsf.javatojs.control.BuildFileFilter;
import org.eclipse.vjet.dsf.javatojs.control.DefaultTranslationInitializer;
import org.eclipse.vjet.dsf.javatojs.control.IBuildResourceFilter;
import org.eclipse.vjet.dsf.javatojs.control.ITranslationInitializer;

public class CodeGenConfig {
    public static final String GLOBAL_CODE_GEN_PROP = "java2js.codegen.prop.file";
    public static final String PROP_FILE_NAME = "java2js.properties";
    private static final String TRANSLATION_MODE = "translationMode";
    private static final String TRACE = "traceEnabled";
    private static final String GEN_JSR = "genJsr";
    private static final String INCLUDE_CHILD_PKGS = "includeChildPkgs";
    private static final String VERBOSE = "verbose";
    private static final String PARALLEL_ENABLED = "parallelEnabled";
    private static final String CONFIG_INITIALIZER = "configInitializer";
    private static final String FILE_FILTER = "fileFilter";
    private static final String GEN_PKG_NAMES = "genPkgNames";
    private TranslationMode m_mode = TranslationMode.TARGETED;
    private boolean m_traceEnabled = false;
    private boolean m_genJsr = true;
    private boolean m_includeChildPkgs = true;
    private boolean m_verbose = false;
    private boolean m_parallelEnabled = false;
    private String m_genPkgNames = "j2j";
    private Class m_configInitializer = DefaultTranslationInitializer.class;
    private Class m_fileFilter = BuildFileFilter.class;

    public CodeGenConfig() {
    }

    public CodeGenConfig(Properties prop) {
        String fileFilter;
        String configInitializer;
        if (prop.getProperty(TRANSLATION_MODE) != null) {
            this.m_mode = TranslationMode.valueOf(prop.getProperty(TRANSLATION_MODE));
        }
        if (prop.getProperty(TRACE) != null) {
            this.m_traceEnabled = Boolean.parseBoolean(prop.getProperty(TRACE));
        }
        if (prop.getProperty(GEN_JSR) != null) {
            this.m_genJsr = Boolean.parseBoolean(prop.getProperty(GEN_JSR));
        }
        if (prop.getProperty(INCLUDE_CHILD_PKGS) != null) {
            this.m_includeChildPkgs = Boolean.parseBoolean(prop.getProperty(INCLUDE_CHILD_PKGS));
        }
        if (prop.getProperty(VERBOSE) != null) {
            this.m_verbose = Boolean.parseBoolean(prop.getProperty(VERBOSE));
        }
        if (prop.getProperty(PARALLEL_ENABLED) != null) {
            this.m_parallelEnabled = Boolean.parseBoolean(prop.getProperty(PARALLEL_ENABLED));
        }
        if (prop.getProperty(GEN_PKG_NAMES) != null) {
            this.m_genPkgNames = prop.getProperty(GEN_PKG_NAMES);
        }
        if ((configInitializer = prop.getProperty(CONFIG_INITIALIZER)) != null) {
            try {
                this.m_configInitializer = Class.forName(configInitializer);
                if (!ITranslationInitializer.class.isAssignableFrom(this.m_configInitializer)) {
                    throw new RuntimeException(String.valueOf(configInitializer) + " class is not assignable from " + ITranslationInitializer.class.getName());
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not found specified configInitializer class " + configInitializer, e);
            }
        }
        if ((fileFilter = prop.getProperty(FILE_FILTER)) != null) {
            try {
                this.m_fileFilter = Class.forName(fileFilter);
                if (!IBuildResourceFilter.class.isAssignableFrom(this.m_fileFilter)) {
                    throw new RuntimeException(String.valueOf(fileFilter) + " class is not assignable from " + FileFilter.class.getName());
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not found specified fileFilter class " + fileFilter, e);
            }
        }
    }

    public TranslationMode getMode() {
        return this.m_mode;
    }

    public void setMode(TranslationMode mode) {
        this.m_mode = mode;
    }

    public boolean isTraceEnabled() {
        return this.m_traceEnabled;
    }

    public void setTraceEnabled(boolean enabled) {
        this.m_traceEnabled = enabled;
    }

    public boolean shouldGenJsr() {
        return this.m_genJsr;
    }

    public void setGenJsr(boolean value) {
        this.m_genJsr = value;
    }

    public boolean shouldIncludeChildPkgs() {
        return this.m_includeChildPkgs;
    }

    public void setIncludeChildPkgs(boolean value) {
        this.m_includeChildPkgs = value;
    }

    public boolean isVerbose() {
        return this.m_verbose;
    }

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public Class getConfigInitializer() {
        return this.m_configInitializer;
    }

    public void setConfigInitializer(Class initializer) {
        this.m_configInitializer = initializer;
    }

    public Class getFileFilter() {
        return this.m_fileFilter;
    }

    public void setFileFilter(Class filter) {
        this.m_fileFilter = filter;
    }

    public boolean isParallelEnabled() {
        return this.m_parallelEnabled;
    }

    public void setParallelEnabled(boolean enabled) {
        this.m_parallelEnabled = enabled;
    }

    public String getGenPkgNames() {
        return this.m_genPkgNames;
    }

    public void setGenPkgNames(String pkgNames) {
        this.m_genPkgNames = pkgNames;
    }

    public static enum TranslationMode {
        ONDEMAND,
        TARGETED;

    }
}

