/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.dom.html;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlFactory;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlType;
import org.eclipse.vjet.dsf.active.dom.html.ANode;
import org.eclipse.vjet.dsf.active.dom.html.AText;
import org.eclipse.vjet.dsf.jsnative.HtmlDocument;
import org.eclipse.vjet.dsf.jsnative.HtmlElement;
import org.eclipse.vjet.dsf.jsnative.HtmlHtml;
import org.eclipse.vjet.dsf.jsnative.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class AHtmlBuilder
implements ContentHandler,
LexicalHandler {
    protected AHtmlDocument m_document;
    protected Stack<HtmlElement> m_current = new Stack();
    private boolean m_ignoreWhitespace = true;
    private boolean m_done = true;
    private boolean m_fixDuplicateIds = false;
    private int m_sequence = 0;
    private List<String> m_ids = new ArrayList<String>();
    protected Vector m_preRootNodes;
    private Locator m_locator;

    public AHtmlBuilder(AHtmlDocument document) {
        this.m_document = document;
    }

    public AHtmlBuilder() {
        this.m_document = new AHtmlDocument();
    }

    @Override
    public void startDocument() throws SAXException {
        if (!this.m_done) {
            throw new SAXException("startDocument already called.");
        }
        this.m_done = false;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.getCurrentElement() != null) {
            throw new SAXException("Document ended before end of document element.");
        }
        this.m_done = true;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (localName == null) {
            throw new SAXException("Tag name is null.");
        }
        if (this.getCurrentElement() == null) {
            HtmlHtml html = this.m_document.createElement(AHtmlType.HTML);
            this.m_document.appendChild((Node)html);
            this.m_current.push((HtmlElement)html);
        } else {
            AHtmlElement node = (AHtmlElement)AHtmlFactory.createElement((HtmlDocument)this.m_document, localName);
            this.getCurrentElement().appendChild((Node)node);
            this.m_current.push(node);
        }
        if (atts != null) {
            int i = 0;
            while (i < atts.getLength()) {
                String name = atts.getLocalName(i);
                String value = atts.getValue(i);
                if ("id".equalsIgnoreCase(name) && this.shouldFixDuplicateIds()) {
                    if (this.m_ids.contains(value)) {
                        value = String.valueOf(value) + "_" + this.m_sequence++;
                    } else {
                        this.m_ids.add(value);
                    }
                }
                this.getCurrentElement().setAttribute(name, value);
                ++i;
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.getCurrentElement() == null) {
            throw new SAXException("endElement called with no current node.");
        }
        if (!this.getCurrentElement().getNodeName().equalsIgnoreCase(localName)) {
            throw new SAXException("mismatch in closing tag name " + localName + "\n" + localName);
        }
        this.m_current.pop();
    }

    public void characters(String text) throws SAXException {
        this.addText(text);
    }

    @Override
    public void characters(char[] text, int start, int length) throws SAXException {
        this.addText(new String(text, start, length));
    }

    @Override
    public void ignorableWhitespace(char[] text, int start, int length) throws SAXException {
        if (!this.m_ignoreWhitespace) {
            this.addText(new String(text, start, length));
        }
    }

    private void addText(String text) throws SAXException {
        if (this.getCurrentElement() == null) {
            throw new SAXException("character data found outside of element.");
        }
        ANode child = (ANode)this.getCurrentElement().getLastChild();
        if (child instanceof AText) {
            ((AText)child).appendData(text);
        } else {
            this.getCurrentElement().appendChild((Node)this.m_document.createTextNode(text));
        }
    }

    @Override
    public void processingInstruction(String target, String instruction) throws SAXException {
    }

    public HtmlDocument getHtmlDocument() {
        return this.m_document;
    }

    public HtmlElement getCurrentElement() {
        if (this.m_current.empty()) {
            return null;
        }
        return this.m_current.peek();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.m_locator = locator;
    }

    public Locator getDocumentLocator() {
        return this.m_locator;
    }

    @Override
    public void startPrefixMapping(String prefix, String uti) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void comment(char[] text, int start, int length) throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    public boolean shouldFixDuplicateIds() {
        return this.m_fixDuplicateIds;
    }

    public void setFixDuplicateIds(boolean value) {
        this.m_fixDuplicateIds = value;
    }
}

