/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.cnr;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.xml.IIndenter;
import org.eclipse.vjet.dsf.common.xml.XmlStreamWriter;
import org.eclipse.vjet.dsf.dap.cnr.DapCaptureData;
import org.eclipse.vjet.dsf.dap.cnr.DomChangeMessageFormater;
import org.eclipse.vjet.dsf.dap.cnr.IDapCaptureSerializer;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.DapHttpRequest;
import org.eclipse.vjet.dsf.dap.rt.DapHttpResponse;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.liveconnect.client.DLCEvent;
import org.eclipse.vjet.dsf.liveconnect.client.IDLCClient;
import org.eclipse.vjet.dsf.liveconnect.client.simple.SimpleDLCClient;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DapCaptureXmlSerializer
implements IDapCaptureSerializer {
    private IIndenter m_indenter;
    private static final String ATTRNAME_ALT = "alt";
    private static final String ATTRNAME_ASYNC = "async";
    private static final String ATTRNAME_CTRL = "ctrl";
    private static final String ATTRNAME_ID = "id";
    private static final String ATTRNAME_INTERVAL = "interval";
    private static final String ATTRNAME_KEY = "key";
    private static final String ATTRNAME_META = "meta";
    private static final String ATTRNAME_METHOD = "method";
    private static final String ATTRNAME_MSG = "msg";
    private static final String ATTRNAME_NAME = "name";
    private static final String ATTRNAME_PATH = "path";
    private static final String ATTRNAME_SHIFT = "shift";
    private static final String ATTRNAME_TIME = "time";
    private static final String ATTRNAME_TYPE = "type";
    private static final String ATTRNAME_URL = "url";
    private static final String ATTRNAME_VALUE = "value";
    private static final String ATTRNAME_VER = "ver";
    private static final String ATTRNAME_X = "x";
    private static final String ATTRNAME_Y = "y";
    private static final String ATTR_NAME_ENCODING = "encoding";
    private static final String CLZNAME_DAP_CAPTURE_DATA = "DapCaptureData";
    private static final String CLZNAME_DAP_HTTP_REQUEST = "DapHttpRequest";
    private static final String CLZNAME_DAP_HTTP_RESPONSE = "DapHttpResponse";
    private static final String CLZNAME_DLC_RNR = "DlcRnR";
    private static final String CLZNAME_DLC_SEND = "DlcSend";
    private static final String CLZNAME_DLCEVENT = "DLCEvent";
    private static final String CLZNAME_EVENT_CAPTURE = "EventCapture";
    private static final String CLZNAME_HTTP_REQ = "HttpReq";
    private static final String CLZNAME_HTTP_RESP = "HttpResp";
    private static final String CLZNAME_KEY_INFO = "KeyInfo";
    private static final String CLZNAME_NODE_APPEND = "NodeAppend";
    private static final String CLZNAME_NODE_ATTR_UPDATE = "NodeAttrUpdate";
    private static final String CLZNAME_NODE_INSERT = "NodeInsert";
    private static final String CLZNAME_NODE_REMOVE = "NodeRemove";
    private static final String CLZNAME_NODE_UPDATE = "NodeUpdate";
    private static final String CLZNAME_NODE_VALUE_UPDATE = "NodeValueUpdate";
    private static final String CLZNAME_TASK_CAPTURE = "TaskCapture";
    private static final String CLZNAME_VIEW_CAPTURE = "ViewCapture";
    private static final String DOT = ".";
    private static final String M_ = "m_";
    private static final String ENCODING_UTF_8 = "UTF-8";
    private static final String FLDNAME_ACTIONS = "m_actions";
    private static final String FLDNAME_ASYNC = "m_async";
    private static final String FLDNAME_BUTTON = "m_button";
    private static final String FLDNAME_CANCEL_BUBBLE = "m_cancelBubble";
    private static final String FLDNAME_CANCELABLE = "m_cancelable";
    private static final String FLDNAME_CHAR_CODE = "m_charCode";
    private static final String FLDNAME_CLIENT_X = "m_clientX";
    private static final String FLDNAME_CLIENT_Y = "m_clientY";
    private static final String FLDNAME_DETAIL = "m_detail";
    private static final String FLDNAME_EVENT = "m_event";
    private static final String FLDNAME_EVENT_TIME_INTERVAL = "m_eventTimeInterval";
    private static final String FLDNAME_HOST = "m_host";
    private static final String FLDNAME_HTTP_CALLS = "m_httpCalls";
    private static final String FLDNAME_ID = "m_id";
    private static final String FLDNAME_IEVENT_CAPTURES = "m_IEventCaptures";
    private static final String FLDNAME_INIT_EVENT_CAPTURE = "m_initEventCapture";
    private static final String FLDNAME_INSERT_BEFORE = "m_insertBefore";
    private static final String FLDNAME_KEY_CODE = "m_keyCode";
    private static final String FLDNAME_KEY_IDENTIFIER = "m_keyIdentifier";
    private static final String FLDNAME_KEY_INFO = "m_keyInfo";
    private static final String FLDNAME_KEY_LOCATION = "m_keyLocation";
    private static final String FLDNAME_MESSAGE = "m_message";
    private static final String FLDNAME_MSG = "m_msg";
    private static final String FLDNAME_METHOD = "m_method";
    private static final String FLDNAME_MODIFIER_STATE = "m_modifierState";
    private static final String FLDNAME_MOUSE_X = "m_mouseX";
    private static final String FLDNAME_MOUSE_Y = "m_mouseY";
    private static final String FLDNAME_NAME = "m_name";
    private static final String FLDNAME_NODE_HTML = "m_nodeHtml";
    private static final String FLDNAME_PAGE_X = "m_pageX";
    private static final String FLDNAME_PAGE_Y = "m_pageY";
    private static final String FLDNAME_PARENT_PATH = "m_parentPath";
    private static final String FLDNAME_PATH = "m_path";
    private static final String FLDNAME_PAYLOAD = "m_payload";
    private static final String FLDNAME_POSITION = "m_position";
    private static final String FLDNAME_RAW_DATA = "m_rawData";
    private static final String FLDNAME_REF_PATH = "m_refPath";
    private static final String FLDNAME_RELATED_TARGET = "m_relatedTarget";
    private static final String FLDNAME_RELATED_TARGET_ID = "m_relatedTargetId";
    private static final String FLDNAME_REQUEST = "m_request";
    private static final String FLDNAME_REQUEST_HEADERS = "m_requestHeaders";
    private static final String FLDNAME_RESPONSE = "m_response";
    private static final String FLDNAME_RESPONSE_HEADERS = "m_responseHeaders";
    private static final String FLDNAME_RESPONSE_TEXT = "m_responseText";
    private static final String FLDNAME_SCREEN_X = "m_screenX";
    private static final String FLDNAME_SCREEN_Y = "m_screenY";
    private static final String FLDNAME_STATUS_CODE = "m_statusCode";
    private static final String FLDNAME_STATUS_TEXT = "m_statusText";
    private static final String FLDNAME_TIME_STAMP = "m_timeStamp";
    private static final String FLDNAME_TIMEOUT = "m_timeout";
    private static final String FLDNAME_TYPE = "m_type";
    private static final String FLDNAME_URL = "m_url";
    private static final String FLDNAME_USER_AGENT = "m_userAgent";
    private static final String FLDNAME_VALUE = "m_value";
    private static final String FLDNAME_VERSION = "m_version";
    private static final String FLDNAME_VIEW_CAPTURES = "m_viewCaptures";
    private static final String FLDNAME_WHICH = "m_which";
    private static final String TAGNAME_BUTTON = "Button";
    private static final String TAGNAME_CANCEL_BUBBLE = "CancelBubble";
    private static final String TAGNAME_CANCELABLE = "Cancelable";
    private static final String TAGNAME_CHAR_CODE = "CharCode";
    private static final String TAGNAME_CLIENT = "Client";
    private static final String TAGNAME_DAP_CAPTURE_DATA = "DapCaptureData";
    private static final String TAGNAME_DETAIL = "Detail";
    private static final String TAGNAME_DLC_RNR = "DlcRnR";
    private static final String TAGNAME_DLC_SEND = "DlcSend";
    private static final String TAGNAME_ENTRY = "Entry";
    private static final String TAGNAME_EVENT = "Event";
    private static final String TAGNAME_EVENT_CAPTURE = "EventCapture";
    private static final String TAGNAME_EVENT_CAPTURE_GROUP = "EventCaptureGroup";
    private static final String TAGNAME_HOST = "Host";
    private static final String TAGNAME_HTTP_CALL = "HttpCall";
    private static final String TAGNAME_HTTP_REQ = "HttpReq";
    private static final String TAGNAME_HTTP_RESP = "HttpResp";
    private static final String TAGNAME_INSERT_BEFORE = "InsertBefore";
    private static final String TAGNAME_KEY_CODE = "KeyCode";
    private static final String TAGNAME_KEY_IDENTIFIER = "KeyIdentifier";
    private static final String TAGNAME_KEY_INFO = "KeyInfo";
    private static final String TAGNAME_KEY_LOCATION = "KeyLocation";
    private static final String TAGNAME_MESSAGE = "Message";
    private static final String TAGNAME_MODIFIER_STATE = "ModifierState";
    private static final String TAGNAME_MOUSE = "Mouse";
    private static final String TAGNAME_NAME = "Name";
    private static final String TAGNAME_NODE_APPEND = "NodeAppend";
    private static final String TAGNAME_NODE_ATTR_UPDATE = "NodeAttrUpdate";
    private static final String TAGNAME_NODE_HTML = "NodeHtml";
    private static final String TAGNAME_NODE_INSERT = "NodeInsert";
    private static final String TAGNAME_NODE_REMOVE = "NodeRemove";
    private static final String TAGNAME_NODE_UPDATE = "NodeUpdate";
    private static final String TAGNAME_NODE_VALUE_UPDATE = "NodeValueUpdate";
    private static final String TAGNAME_PAGE = "Page";
    private static final String TAGNAME_PARENT_PATH = "ParentPath";
    private static final String TAGNAME_PATH = "Path";
    private static final String TAGNAME_POSITION = "Position";
    private static final String TAGNAME_PROPERTY = "Property";
    private static final String TAGNAME_RAW_DATA = "RawData";
    private static final String TAGNAME_REF_PATH = "RefPath";
    private static final String TAGNAME_RELATED_TARGET = "RelatedTarget";
    private static final String TAGNAME_RELATED_TARGET_ID = "RelatedTargetId";
    private static final String TAGNAME_REQ = "Req";
    private static final String TAGNAME_REQUEST = "Request";
    private static final String TAGNAME_REQUEST_HEADERS = "RequestHeaders";
    private static final String TAGNAME_RESP = "Resp";
    private static final String TAGNAME_RESPONSE = "Response";
    private static final String TAGNAME_RESPONSE_HEADERS = "ResponseHeaders";
    private static final String TAGNAME_RESPONSE_TEXT = "ResponseText";
    private static final String TAGNAME_SCREEN = "Screen";
    private static final String TAGNAME_SRC = "Src";
    private static final String TAGNAME_STATUS_CODE = "StatusCode";
    private static final String TAGNAME_STATUS_TEXT = "StatusText";
    private static final String TAGNAME_TASK_CAPTURE = "TaskCapture";
    private static final String TAGNAME_TIME_STAMP = "TimeStamp";
    private static final String TAGNAME_TIMEOUT = "Timeout";
    private static final String TAGNAME_USER_AGENT = "UserAgent";
    private static final String TAGNAME_VALUE = "Value";
    private static final String TAGNAME_VIEW_CAPTURE = "ViewCapture";
    private static final String TAGNAME_WHICH = "Which";
    private static final Integer DEFAULT_INT = new Integer(0);
    private static final Integer INT_MINUS_1 = new Integer(-1);
    private static final Long DEFAULT_LONG = new Long(0L);
    private static final Double DEFAULT_DOUBLE = new Double(0.0);
    private static final Boolean DEFAULT_BOOLEAN = Boolean.FALSE;
    private static final Short DEFAULT_SHORT = new Short(0);
    private static final Short SHORT_MINUS_1 = new Short(-1);
    private static final Float DEFAULT_FLOAT = new Float(0.0f);
    private static final String EMPTY_STR = "";
    private static final String EMPTY_STR_WRAPPER = "@#$";
    private static final String BLANK_CHAR = " ";
    private static final String BLANK_CHAR_REPLACEMENT = ".@.";
    private static final int EMPTY_STR_WRAPPER_LENGTH = "@#$".length();
    private static final int EMPTY_STR_WRAPPER_LENGTH_DOUBLE = EMPTY_STR_WRAPPER_LENGTH * 2;

    public DapCaptureXmlSerializer() {
        this(null, null);
    }

    public DapCaptureXmlSerializer(IIndenter indenter) {
        this(null, indenter);
    }

    public DapCaptureXmlSerializer(IDLCClient dlcClient, IIndenter indenter) {
        this.m_indenter = indenter;
    }

    @Override
    public void serialize(DapCaptureData capture, OutputStream out) {
        try {
            OutputStreamWriter pw = new OutputStreamWriter(out, ENCODING_UTF_8);
            XmlStreamWriter writer = new XmlStreamWriter((Writer)pw, this.getIndenter());
            writer.writeStartDocument();
            new DapCaptureDataRootSerializer().serialize(capture, writer);
            writer.writeEndDocument();
            writer.flush();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DapCaptureData deserialize(InputStream in) {
        DapCaptureData data;
        block5: {
            data = null;
            if (in.available() != 0) break block5;
            return null;
        }
        try {
            DapCaptureDataRootHandler handler = new DapCaptureDataRootHandler();
            SAXParserFactory.newInstance().newSAXParser().parse(new InputSource(new InputStreamReader(in, ENCODING_UTF_8)), (DefaultHandler)handler);
            data = handler.getData();
        }
        catch (SAXException e) {
            throw new DsfRuntimeException((Throwable)e);
        }
        catch (IOException e) {
            throw new DsfRuntimeException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new DsfRuntimeException((Throwable)e);
        }
        return data;
    }

    public void setIndenter(IIndenter indenter) {
        this.m_indenter = indenter;
    }

    public IIndenter getIndenter() {
        if (this.m_indenter == null) {
            this.m_indenter = IIndenter.COMPACT;
        }
        return this.m_indenter;
    }

    private static String wrapEmptyString(String str) {
        String trim = str.trim();
        if (trim.length() != str.length() || trim.length() == 0) {
            return EMPTY_STR_WRAPPER + str.replaceAll(BLANK_CHAR, BLANK_CHAR_REPLACEMENT) + EMPTY_STR_WRAPPER;
        }
        return str;
    }

    private static String unwrapEmptyString(String str) {
        String unwrap = str.trim();
        if (unwrap.startsWith(EMPTY_STR_WRAPPER) && unwrap.endsWith(EMPTY_STR_WRAPPER)) {
            int strLength = unwrap.length();
            if (strLength == EMPTY_STR_WRAPPER_LENGTH_DOUBLE) {
                unwrap = EMPTY_STR;
            } else if (strLength > EMPTY_STR_WRAPPER_LENGTH_DOUBLE) {
                unwrap = unwrap.substring(EMPTY_STR_WRAPPER_LENGTH, strLength - EMPTY_STR_WRAPPER_LENGTH);
                unwrap = unwrap.replaceAll(BLANK_CHAR_REPLACEMENT, BLANK_CHAR);
            }
        }
        return unwrap;
    }

    private static void setFieldValue(Field field, Object bean, Object value) {
        if (value == null || field == null) {
            return;
        }
        try {
            boolean flg = field.isAccessible();
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            String simpleValue = null;
            if (String.class.equals(value.getClass())) {
                simpleValue = (String)value;
            }
            if (simpleValue != null) {
                if (Boolean.TYPE.equals(fieldType)) {
                    field.setBoolean(bean, Boolean.parseBoolean(simpleValue));
                } else if (Integer.TYPE.equals(fieldType)) {
                    field.setInt(bean, Integer.parseInt(simpleValue));
                } else if (Short.TYPE.equals(fieldType)) {
                    field.setShort(bean, Short.parseShort(simpleValue));
                } else if (Float.TYPE.equals(fieldType)) {
                    field.setFloat(bean, Float.parseFloat(simpleValue));
                } else if (Double.TYPE.equals(fieldType)) {
                    field.setDouble(bean, Double.parseDouble(simpleValue));
                } else if (Long.TYPE.equals(fieldType)) {
                    field.setLong(bean, Long.parseLong(simpleValue));
                } else if (String.class.equals(fieldType)) {
                    field.set(bean, simpleValue);
                }
            } else {
                field.set(bean, value);
            }
            field.setAccessible(flg);
        }
        catch (IllegalArgumentException e) {
            throw new DsfRuntimeException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new DsfRuntimeException((Throwable)e);
        }
    }

    private static Object getFieldValue(Field field, Object bean) {
        Object obj = null;
        try {
            boolean flg = field.isAccessible();
            field.setAccessible(true);
            obj = field.get(bean);
            field.setAccessible(flg);
        }
        catch (IllegalArgumentException e) {
            throw new DsfRuntimeException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new DsfRuntimeException((Throwable)e);
        }
        return obj;
    }

    private static Field getField(String fieldName, Class<?> clz) {
        Field field = null;
        try {
            field = clz.getDeclaredField(fieldName);
        }
        catch (SecurityException e) {
            throw new DsfRuntimeException((Throwable)e);
        }
        catch (NoSuchFieldException e) {
            throw new DsfRuntimeException((Throwable)e);
        }
        return field;
    }

    public static abstract class ActionInfoHandler
    extends DapCaptureDataSubHandler {
        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            DapCaptureData.IActionInfo action = this.constructAction(name);
            if (action == null) {
                return;
            }
            this.getObjStack().push(action);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            DapCaptureData.IActionInfo action = (DapCaptureData.IActionInfo)this.getObjStack().pop();
            DapCaptureData.IEventCapture ec = (DapCaptureData.IEventCapture)this.getObjStack().peek();
            this.addToEc(ec, action);
        }

        protected abstract void addToEc(DapCaptureData.IEventCapture var1, DapCaptureData.IActionInfo var2);

        protected abstract DapCaptureData.IActionInfo constructAction(String var1);
    }

    public static class CDataSerializer
    extends DapCaptureDataSubSerializer {
        @Override
        public void serialize(String currentPath, Object obj, XmlStreamWriter writer, String tagName) {
            if (tagName == null) {
                throw new DsfRuntimeException("CDataSerializer needs a tagName input!");
            }
            writer.writeStartElement(tagName);
            writer.writeCData(DapCaptureXmlSerializer.wrapEmptyString(obj.toString()));
            writer.writeEndElement();
        }
    }

    public static class CharactersSerializer
    extends DapCaptureDataSubSerializer {
        @Override
        public void serialize(String currentPath, Object obj, XmlStreamWriter writer, String tagName) {
            if (tagName == null) {
                throw new DsfRuntimeException("CharactersSerializer needs a tagName input!");
            }
            writer.writeStartElement(tagName);
            writer.writeCharacters(DapCaptureXmlSerializer.wrapEmptyString(obj.toString()));
            writer.writeEndElement();
        }
    }

    public static class CollectionSubSerializer
    extends DapCaptureDataSubSerializer {
        @Override
        public void serialize(String currentPath, Object obj, XmlStreamWriter writer, String tagName) {
            if (tagName == null) {
                throw new DsfRuntimeException("CollectionSubSerializer needs tagName input!");
            }
            if (obj == null) {
                return;
            }
            if (!(obj instanceof Collection)) {
                return;
            }
            Collection c = (Collection)obj;
            if (c.size() == 0) {
                return;
            }
            writer.writeStartElement(tagName);
            for (Object elm : c) {
                String clzName = elm.getClass().getSimpleName();
                DapCaptureDataSubSerializer subSerializer = this.getSubSerializer(clzName);
                if (subSerializer == null) continue;
                subSerializer.serialize(clzName, elm, writer, clzName);
            }
            writer.writeEndElement();
        }
    }

    public static class DLCEventHandler
    extends DapCaptureDataSubHandler {
        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            DLCEvent e = new DLCEvent(DapCaptureXmlSerializer.EMPTY_STR);
            e.setType(attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_TYPE));
            this.getObjStack().push(e);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            DLCEvent e = (DLCEvent)this.getObjStack().pop();
            String payload = SimpleDLCClient.getInstance().getPayload(e);
            DapCaptureXmlSerializer.setFieldValue(DapCaptureXmlSerializer.getField(DapCaptureXmlSerializer.FLDNAME_PAYLOAD, DLCEvent.class), e, payload);
            DapCaptureData.EventCapture ec = (DapCaptureData.EventCapture)this.getObjStack().peek();
            DapCaptureXmlSerializer.setFieldValue(DapCaptureXmlSerializer.getField(DapCaptureXmlSerializer.FLDNAME_EVENT, DapCaptureData.EventCapture.class), ec, e);
        }
    }

    public static class DLCEventPropertyHandler
    extends PrimitiveHandler {
        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            DLCEvent e = (DLCEvent)this.getObjStack().peek();
            e.setSrcProp(attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_NAME));
            super.startElement(uri, localName, name, attributes);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            ValueHolder valueHolder = (ValueHolder)this.getObjStack().pop();
            String value = DapCaptureXmlSerializer.unwrapEmptyString((String)valueHolder.getValue());
            DLCEvent e = (DLCEvent)this.getObjStack().peek();
            e.setValue(value);
        }
    }

    public static class DLCEventSerializer
    extends ObjectSubSerializer {
        @Override
        protected String[] getAttrFields() {
            return new String[]{DapCaptureXmlSerializer.FLDNAME_TYPE};
        }

        @Override
        protected String[] getNodeFields() {
            return new String[]{DapCaptureXmlSerializer.FLDNAME_POSITION, DapCaptureXmlSerializer.FLDNAME_KEY_INFO, DapCaptureXmlSerializer.FLDNAME_CANCEL_BUBBLE, DapCaptureXmlSerializer.FLDNAME_CANCELABLE, DapCaptureXmlSerializer.FLDNAME_BUTTON, DapCaptureXmlSerializer.FLDNAME_RELATED_TARGET, DapCaptureXmlSerializer.FLDNAME_RELATED_TARGET_ID, DapCaptureXmlSerializer.FLDNAME_MODIFIER_STATE, DapCaptureXmlSerializer.FLDNAME_TIME_STAMP, DapCaptureXmlSerializer.FLDNAME_DETAIL, DapCaptureXmlSerializer.FLDNAME_WHICH};
        }

        @Override
        protected void serializeNodes(Object obj, XmlStreamWriter writer, Class<?> ctnClz, String ctnClzName) {
            DLCEvent e = (DLCEvent)obj;
            if (!EventType.LOAD.getName().equals(e.getType())) {
                String id = e.getSrcId();
                String path = e.getSrcPath();
                if (id != null || path != null) {
                    writer.writeStartElement(DapCaptureXmlSerializer.TAGNAME_SRC);
                    if (id != null && path != null && path.startsWith("document.getElementById(")) {
                        writer.writeAttribute(DapCaptureXmlSerializer.ATTRNAME_ID, id);
                    } else if (path != null) {
                        writer.writeAttribute(DapCaptureXmlSerializer.ATTRNAME_PATH, path);
                    }
                    if (e.getSrcProp() != null) {
                        writer.writeStartElement(DapCaptureXmlSerializer.TAGNAME_PROPERTY);
                        writer.writeAttribute(DapCaptureXmlSerializer.ATTRNAME_NAME, e.getSrcProp());
                        writer.writeCharacters(DapCaptureXmlSerializer.wrapEmptyString(e.getValue()));
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                } else if (e.getValue() != null) {
                    writer.writeStartElement(DapCaptureXmlSerializer.TAGNAME_VALUE);
                    writer.writeCharacters(DapCaptureXmlSerializer.wrapEmptyString(e.getValue()));
                    writer.writeEndElement();
                }
            }
            super.serializeNodes(obj, writer, ctnClz, ctnClzName);
        }

        @Override
        protected boolean isDefaultValue(String fldName, Object fldValue) {
            boolean isDefault = super.isDefaultValue(fldName, fldValue);
            if (DapCaptureXmlSerializer.FLDNAME_BUTTON.equals(fldName)) {
                isDefault = SHORT_MINUS_1.equals(fldValue);
            } else if (DapCaptureXmlSerializer.FLDNAME_CANCELABLE.equals(fldName)) {
                isDefault = Boolean.TRUE.equals(fldValue);
            } else if (DapCaptureXmlSerializer.FLDNAME_WHICH.equals(fldName)) {
                isDefault = INT_MINUS_1.equals(fldValue);
            }
            return isDefault;
        }
    }

    public static class DLCEventSrcHandler
    extends DapCaptureDataSubHandler {
        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            String id = attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_ID);
            String path = attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_PATH);
            DLCEvent e = (DLCEvent)this.getObjStack().peek();
            if (path != null) {
                e.setSrcPath(path);
            } else if (id != null) {
                e.setSrcId(id);
                e.setSrcPath("document.getElementById(\"" + id + "\")");
            }
        }
    }

    public static class DapCaptureDataHandler
    extends DapCaptureDataSubHandler {
        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            DapCaptureData data = new DapCaptureData();
            data.setVersion(attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_VER));
            this.getHolder().setValue(data);
            this.getObjStack().push(data);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            this.getObjStack().pop();
        }
    }

    private static class DapCaptureDataRootHandler
    extends DefaultHandler {
        private ValueHolder<DapCaptureData> m_holder = new ValueHolder();
        private Stack<Object> m_objStack = new Stack();
        private Stack<String> m_tagStack = new Stack();
        private Stack<Boolean> m_skipStack = new Stack();
        private Map<String, DapCaptureDataSubHandler> m_handlerRegistry = this.initHandlerRegistry();

        private DapCaptureDataRootHandler() {
        }

        public DapCaptureData getData() {
            return this.m_holder.getValue();
        }

        private Map<String, DapCaptureDataSubHandler> initHandlerRegistry() {
            HashMap<String, Class<? extends DapCaptureDataSubHandler>> info = new HashMap<String, Class<? extends DapCaptureDataSubHandler>>();
            this.initStandardHandlers(info);
            info.putAll(DapCtx.ctx().getDapConfig().getDapCaptureDataDeserializerRegistry());
            HashMap<String, DapCaptureDataSubHandler> map = new HashMap<String, DapCaptureDataSubHandler>();
            for (Map.Entry entry : info.entrySet()) {
                DapCaptureDataSubHandler subHandler = null;
                try {
                    subHandler = (DapCaptureDataSubHandler)((Class)entry.getValue()).newInstance();
                }
                catch (IllegalAccessException e) {
                    throw new DsfRuntimeException((Throwable)e);
                }
                catch (InstantiationException e) {
                    throw new DsfRuntimeException((Throwable)e);
                }
                if (subHandler == null) continue;
                subHandler.initHandler(this.m_holder, this.m_objStack, map);
                map.put((String)entry.getKey(), subHandler);
            }
            return map;
        }

        private void initStandardHandlers(Map<String, Class<? extends DapCaptureDataSubHandler>> info) {
            info.put("DapCaptureData", DapCaptureDataHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_USER_AGENT, PrimitiveHandler.class);
            info.put("EventCapture", EventCaptureHandler.class);
            info.put("TaskCapture", TaskCaptureHandler.class);
            info.put("ViewCapture", ViewCaptureHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_EVENT_CAPTURE_GROUP, EventCaptureGroupHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_EVENT, DLCEventHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_CANCEL_BUBBLE, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_CANCELABLE, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_BUTTON, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_RELATED_TARGET, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_RELATED_TARGET_ID, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_MODIFIER_STATE, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_TIME_STAMP, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_DETAIL, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_WHICH, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_SRC, DLCEventSrcHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_PROPERTY, DLCEventPropertyHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_POSITION, PositionHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_CLIENT, PositionHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_MOUSE, PositionHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_PAGE, PositionHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_SCREEN, PositionHandler.class);
            info.put("KeyInfo", KeyInfoHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_CHAR_CODE, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_KEY_CODE, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_KEY_LOCATION, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_KEY_IDENTIFIER, PrimitiveHandler.class);
            info.put("DlcRnR", DlcMsgHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_REQUEST, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_RESPONSE, PrimitiveHandler.class);
            info.put("DlcSend", DlcSendHandler.class);
            info.put("NodeAppend", DomChangeHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_PARENT_PATH, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_NODE_HTML, PrimitiveHandler.class);
            info.put("NodeAttrUpdate", DomChangeHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_PATH, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_NAME, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_VALUE, PrimitiveHandler.class);
            info.put("NodeInsert", DomChangeHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_REF_PATH, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_NODE_HTML, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_INSERT_BEFORE, PrimitiveHandler.class);
            info.put("NodeRemove", DomChangeHandler.class);
            info.put("NodeUpdate", DomChangeHandler.class);
            info.put("NodeValueUpdate", DomChangeHandler.class);
            info.put("HttpReq", HttpCallsHandlerWrapper.class);
            info.put("HttpResp", HttpCallsHandlerWrapper.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_HTTP_CALL, HttpCallsHandlerWrapper.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_REQ, HttpCallsHandlerWrapper.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_HOST, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_TIMEOUT, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_RAW_DATA, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_REQUEST_HEADERS, HttpCallsHandlerWrapper.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_RESP, HttpCallsHandlerWrapper.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_STATUS_CODE, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_STATUS_TEXT, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_RESPONSE_TEXT, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_RAW_DATA, PrimitiveHandler.class);
            info.put(DapCaptureXmlSerializer.TAGNAME_RESPONSE_HEADERS, HttpCallsHandlerWrapper.class);
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.m_tagStack.push(name);
            DefaultHandler handler = this.m_handlerRegistry.get(name);
            if (handler == null) {
                this.m_skipStack.push(Boolean.TRUE);
            } else {
                this.m_skipStack.push(Boolean.FALSE);
                handler.startElement(uri, localName, name, attributes);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.m_skipStack.peek().booleanValue()) {
                return;
            }
            DefaultHandler handler = this.m_handlerRegistry.get(this.m_tagStack.peek());
            if (handler == null) {
                throw new DsfRuntimeException("Handler is null for '" + this.m_tagStack.peek() + "''s characters()");
            }
            handler.characters(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            String tagName = this.m_tagStack.pop();
            if (this.m_skipStack.pop().booleanValue()) {
                return;
            }
            if (!tagName.equals(name)) {
                throw new DsfRuntimeException("Tag name mismatched. Expecting '" + tagName + "' but got '" + name + "'");
            }
            DefaultHandler handler = this.m_handlerRegistry.get(name);
            if (handler == null) {
                throw new DsfRuntimeException("Handler is null for '" + name + "''s endElement()");
            }
            handler.endElement(uri, localName, name);
        }
    }

    private static class DapCaptureDataRootSerializer {
        private Map<String, DapCaptureDataSubSerializer> m_serializerRegistry = this.initSerializerRegistry();

        private DapCaptureDataRootSerializer() {
        }

        private Map<String, DapCaptureDataSubSerializer> initSerializerRegistry() {
            HashMap<String, Class<? extends DapCaptureDataSubSerializer>> info = new HashMap<String, Class<? extends DapCaptureDataSubSerializer>>();
            this.initStandardSubSerializer(info);
            info.putAll(DapCtx.ctx().getDapConfig().getDapCaptureDataSerializerRegistry());
            HashMap<String, DapCaptureDataSubSerializer> map = new HashMap<String, DapCaptureDataSubSerializer>();
            for (Map.Entry entry : info.entrySet()) {
                DapCaptureDataSubSerializer subSerializer = null;
                try {
                    subSerializer = (DapCaptureDataSubSerializer)((Class)entry.getValue()).newInstance();
                }
                catch (IllegalAccessException e) {
                    throw new DsfRuntimeException((Throwable)e);
                }
                catch (InstantiationException e) {
                    throw new DsfRuntimeException((Throwable)e);
                }
                if (subSerializer == null) continue;
                subSerializer.setRegistry(map);
                map.put((String)entry.getKey(), subSerializer);
            }
            return map;
        }

        private void initStandardSubSerializer(Map<String, Class<? extends DapCaptureDataSubSerializer>> info) {
            info.put("DapCaptureData", DapCaptureDataSerializer.class);
            info.put("DapCaptureData.m_userAgent", CharactersSerializer.class);
            info.put("DapCaptureData.m_initEventCapture", EventCaptureSerializer.class);
            info.put("DapCaptureData.m_viewCaptures", CollectionSubSerializer.class);
            info.put("DapCaptureData.m_httpCalls", HttpCallsSerializer.class);
            info.put("DapHttpRequest.m_host", CharactersSerializer.class);
            info.put("DapHttpRequest.m_rawData", CDataSerializer.class);
            info.put("DapHttpRequest.m_timeout", CharactersSerializer.class);
            info.put("DapHttpRequest.m_requestHeaders", HttpHeaderSerializer.class);
            info.put("DapHttpResponse.m_rawData", CDataSerializer.class);
            info.put("DapHttpResponse.m_responseText", CDataSerializer.class);
            info.put("DapHttpResponse.m_statusCode", CharactersSerializer.class);
            info.put("DapHttpResponse.m_statusText", CharactersSerializer.class);
            info.put("DapHttpResponse.m_responseHeaders", HttpHeaderSerializer.class);
            info.put("TaskCapture", TaskCaptureSerializer.class);
            info.put("TaskCapture.m_actions", CollectionSubSerializer.class);
            info.put("EventCapture", EventCaptureSerializer.class);
            info.put("EventCapture.m_actions", CollectionSubSerializer.class);
            info.put("EventCapture.m_event", DLCEventSerializer.class);
            info.put("DLCEvent.m_position", PositionSerializer.class);
            info.put("DLCEvent.m_cancelBubble", CharactersSerializer.class);
            info.put("DLCEvent.m_cancelable", CharactersSerializer.class);
            info.put("DLCEvent.m_button", CharactersSerializer.class);
            info.put("DLCEvent.m_relatedTarget", CharactersSerializer.class);
            info.put("DLCEvent.m_relatedTargetId", CharactersSerializer.class);
            info.put("DLCEvent.m_modifierState", CharactersSerializer.class);
            info.put("DLCEvent.m_timeStamp", CharactersSerializer.class);
            info.put("DLCEvent.m_detail", CharactersSerializer.class);
            info.put("DLCEvent.m_which", CharactersSerializer.class);
            info.put("DLCEvent.m_keyInfo", KeyInfoSerializer.class);
            info.put("KeyInfo.m_charCode", CharactersSerializer.class);
            info.put("KeyInfo.m_keyCode", CharactersSerializer.class);
            info.put("KeyInfo.m_keyLocation", CharactersSerializer.class);
            info.put("KeyInfo.m_keyIdentifier", CharactersSerializer.class);
            info.put("ViewCapture", ViewCaptureSerializer.class);
            info.put("ViewCapture.m_IEventCaptures", EventCaptureGroupSerializer.class);
            info.put("DlcRnR", DlcRnRSerializer.class);
            info.put("DlcRnR.m_request", CharactersSerializer.class);
            info.put("DlcRnR.m_response", CharactersSerializer.class);
            info.put("DlcSend", DlcSendSerializer.class);
            info.put("DlcSend.m_message", RawCDataSerializer.class);
            info.put("NodeAppend", NodeAppendSerializer.class);
            info.put("NodeAppend.m_parentPath", CharactersSerializer.class);
            info.put("NodeAppend.m_nodeHtml", CDataSerializer.class);
            info.put("NodeAttrUpdate", NodeAttrUpdateSerializer.class);
            info.put("NodeAttrUpdate.m_path", CharactersSerializer.class);
            info.put("NodeAttrUpdate.m_name", CharactersSerializer.class);
            info.put("NodeAttrUpdate.m_value", CharactersSerializer.class);
            info.put("NodeInsert", NodeInsertSerializer.class);
            info.put("NodeInsert.m_refPath", CharactersSerializer.class);
            info.put("NodeInsert.m_nodeHtml", CDataSerializer.class);
            info.put("NodeInsert.m_insertBefore", CharactersSerializer.class);
            info.put("NodeRemove", NodeRemoveSerializer.class);
            info.put("NodeRemove.m_path", CharactersSerializer.class);
            info.put("NodeRemove.m_nodeHtml", CDataSerializer.class);
            info.put("NodeUpdate", NodeUpdateSerializer.class);
            info.put("NodeUpdate.m_path", CharactersSerializer.class);
            info.put("NodeUpdate.m_nodeHtml", CDataSerializer.class);
            info.put("NodeValueUpdate", NodeValueUpdateSerializer.class);
            info.put("NodeValueUpdate.m_path", CharactersSerializer.class);
            info.put("NodeValueUpdate.m_value", CharactersSerializer.class);
            info.put("HttpReq", HttpMsgSerializer.class);
            info.put("HttpResp", HttpMsgSerializer.class);
        }

        public void serialize(DapCaptureData data, XmlStreamWriter writer) {
            if (data == null) {
                return;
            }
            String path = data.getClass().getSimpleName();
            DapCaptureDataSubSerializer subSerializer = this.m_serializerRegistry.get(path);
            if (subSerializer == null) {
                throw new DsfRuntimeException("No serializer defined for '" + path + "'");
            }
            subSerializer.serialize(path, data, writer, path);
        }
    }

    public static class DapCaptureDataSerializer
    extends ObjectSubSerializer {
        @Override
        protected String[] getAttrFields() {
            return new String[]{DapCaptureXmlSerializer.FLDNAME_VERSION};
        }

        @Override
        protected String[] getNodeFields() {
            return new String[]{DapCaptureXmlSerializer.FLDNAME_USER_AGENT, DapCaptureXmlSerializer.FLDNAME_INIT_EVENT_CAPTURE, DapCaptureXmlSerializer.FLDNAME_VIEW_CAPTURES, DapCaptureXmlSerializer.FLDNAME_HTTP_CALLS};
        }

        @Override
        protected String getDisplayName(String fldName, boolean capitalizeFirst) {
            if (DapCaptureXmlSerializer.FLDNAME_VERSION.equals(fldName)) {
                return DapCaptureXmlSerializer.ATTRNAME_VER;
            }
            if (DapCaptureXmlSerializer.FLDNAME_INIT_EVENT_CAPTURE.equals(fldName)) {
                return "EventCapture";
            }
            return super.getDisplayName(fldName, capitalizeFirst);
        }

        @Override
        protected void serializeAttrs(Object obj, XmlStreamWriter writer, Class<?> ctnClz) {
            writer.writeAttribute(DapCaptureXmlSerializer.ATTR_NAME_ENCODING, DapCaptureXmlSerializer.ENCODING_UTF_8);
            super.serializeAttrs(obj, writer, ctnClz);
        }
    }

    public static abstract class DapCaptureDataSubHandler
    extends DefaultHandler {
        private ValueHolder<DapCaptureData> m_holder;
        private Stack<Object> m_objStack;
        private Map<String, DapCaptureDataSubHandler> m_registry;

        protected ValueHolder<DapCaptureData> getHolder() {
            return this.m_holder;
        }

        protected Stack<Object> getObjStack() {
            return this.m_objStack;
        }

        public Map<String, DapCaptureDataSubHandler> getRegistry() {
            return this.m_registry;
        }

        public void initHandler(ValueHolder<DapCaptureData> holder, Stack<Object> objStack, Map<String, DapCaptureDataSubHandler> registry) {
            this.m_holder = holder;
            this.m_objStack = objStack;
            this.m_registry = registry;
        }
    }

    public static abstract class DapCaptureDataSubSerializer {
        private Map<String, DapCaptureDataSubSerializer> m_serializerRegistry;

        public void setRegistry(Map<String, DapCaptureDataSubSerializer> registry) {
            this.m_serializerRegistry = registry;
        }

        protected DapCaptureDataSubSerializer getSubSerializer(String path) {
            return this.m_serializerRegistry.get(path);
        }

        public abstract void serialize(String var1, Object var2, XmlStreamWriter var3, String var4);
    }

    public static class DapHttpRequestSerializer
    extends ObjectSubSerializer {
        @Override
        protected String[] getAttrFields() {
            return new String[]{DapCaptureXmlSerializer.FLDNAME_URL, DapCaptureXmlSerializer.FLDNAME_METHOD, DapCaptureXmlSerializer.FLDNAME_ASYNC};
        }

        @Override
        protected String[] getNodeFields() {
            return new String[]{DapCaptureXmlSerializer.FLDNAME_HOST, DapCaptureXmlSerializer.FLDNAME_TIMEOUT, DapCaptureXmlSerializer.FLDNAME_RAW_DATA, DapCaptureXmlSerializer.FLDNAME_REQUEST_HEADERS};
        }
    }

    public static class DapHttpResponseSerializer
    extends ObjectSubSerializer {
        private String m_respTime;

        @Override
        protected void serializeAttrs(Object obj, XmlStreamWriter writer, Class<?> ctnClz) {
            if (this.m_respTime != null) {
                writer.writeAttribute(DapCaptureXmlSerializer.ATTRNAME_TIME, this.m_respTime);
            }
            super.serializeAttrs(obj, writer, ctnClz);
        }

        @Override
        protected String[] getNodeFields() {
            return new String[]{DapCaptureXmlSerializer.FLDNAME_STATUS_CODE, DapCaptureXmlSerializer.FLDNAME_STATUS_TEXT, DapCaptureXmlSerializer.FLDNAME_RESPONSE_TEXT, DapCaptureXmlSerializer.FLDNAME_RESPONSE_HEADERS, DapCaptureXmlSerializer.FLDNAME_RAW_DATA};
        }
    }

    public static class DlcMsgHandler
    extends ActionInfoHandler {
        @Override
        protected void addToEc(DapCaptureData.IEventCapture ec, DapCaptureData.IActionInfo action) {
            if (action instanceof DapCaptureData.DlcRnR) {
                DapCaptureData.DlcRnR rnr = (DapCaptureData.DlcRnR)action;
                ec.addDlcRequest(rnr.getRequest());
                ec.addDlcResponse(rnr.getResponse());
            } else if (action instanceof DapCaptureData.DlcSend) {
                DapCaptureData.DlcSend send = (DapCaptureData.DlcSend)action;
                ec.addDlcSend(send.getMessage());
            }
        }

        @Override
        protected DapCaptureData.IActionInfo constructAction(String name) {
            DapCaptureData.IDlcMsg msg = null;
            if ("DlcRnR".equals(name)) {
                msg = new DapCaptureData.DlcRnR(DapCaptureXmlSerializer.EMPTY_STR);
            } else if ("DlcSend".equals(name)) {
                msg = new DapCaptureData.DlcSend(DapCaptureXmlSerializer.EMPTY_STR);
            }
            return msg;
        }
    }

    public static class DlcRnRSerializer
    extends ObjectSubSerializer {
        @Override
        protected String[] getNodeFields() {
            return new String[]{DapCaptureXmlSerializer.FLDNAME_REQUEST, DapCaptureXmlSerializer.FLDNAME_RESPONSE};
        }
    }

    public static class DlcSendHandler
    extends PrimitiveHandler {
        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            ValueHolder valueHolder = (ValueHolder)this.getObjStack().pop();
            String value = DapCaptureXmlSerializer.unwrapEmptyString((String)valueHolder.getValue());
            DapCaptureData.IEventCapture ec = (DapCaptureData.IEventCapture)this.getObjStack().peek();
            ec.addDlcSend(value);
        }
    }

    public static class DlcSendSerializer
    extends ObjectSubSerializer {
        @Override
        protected String[] getNodeFields() {
            return new String[]{DapCaptureXmlSerializer.FLDNAME_MESSAGE};
        }
    }

    public static class DomChangeHandler
    extends ActionInfoHandler {
        @Override
        protected void addToEc(DapCaptureData.IEventCapture ec, DapCaptureData.IActionInfo action) {
            ec.addDomChange((DapCaptureData.IDomChange)action);
        }

        @Override
        protected DapCaptureData.IActionInfo constructAction(String name) {
            DapCaptureData.IDomChange domChg = null;
            if ("NodeAppend".equals(name)) {
                domChg = new DomChangeMessageFormater.NodeAppend();
            } else if ("NodeAppend".equals(name)) {
                domChg = new DomChangeMessageFormater.NodeAppend();
            } else if ("NodeAttrUpdate".equals(name)) {
                domChg = new DomChangeMessageFormater.NodeAttrUpdate();
            } else if ("NodeInsert".equals(name)) {
                domChg = new DomChangeMessageFormater.NodeInsert();
            } else if ("NodeRemove".equals(name)) {
                domChg = new DomChangeMessageFormater.NodeRemove();
            } else if ("NodeUpdate".equals(name)) {
                domChg = new DomChangeMessageFormater.NodeUpdate();
            } else if ("NodeValueUpdate".equals(name)) {
                domChg = new DomChangeMessageFormater.NodeValueUpdate();
            }
            return domChg;
        }
    }

    public static class EventCaptureGroupHandler
    extends DapCaptureDataSubHandler {
        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            String key = attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_NAME);
            this.getObjStack().push(key);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            this.getObjStack().pop();
        }
    }

    public static class EventCaptureGroupSerializer
    extends DapCaptureDataSubSerializer {
        @Override
        public void serialize(String currentPath, Object obj, XmlStreamWriter writer, String tagName) {
            if (obj == null) {
                return;
            }
            Map groups = (Map)obj;
            if (groups.size() == 0) {
                return;
            }
            for (Map.Entry group : groups.entrySet()) {
                writer.writeStartElement(DapCaptureXmlSerializer.TAGNAME_EVENT_CAPTURE_GROUP);
                writer.writeAttribute(DapCaptureXmlSerializer.ATTRNAME_NAME, (String)group.getKey());
                List ecs = (List)group.getValue();
                for (DapCaptureData.IEventCapture ec : ecs) {
                    String clzName = ec.getClass().getSimpleName();
                    DapCaptureDataSubSerializer subSerializer = this.getSubSerializer(clzName);
                    if (subSerializer == null) continue;
                    subSerializer.serialize(clzName, ec, writer, clzName);
                }
                writer.writeEndElement();
            }
        }
    }

    public static class EventCaptureHandler
    extends DapCaptureDataSubHandler {
        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            DapCaptureData data = this.getHolder().getValue();
            String intStr = attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_INTERVAL);
            int intVal = 0;
            if (intStr != null) {
                intVal = Integer.parseInt(intStr);
            }
            DapCaptureData dapCaptureData = data;
            dapCaptureData.getClass();
            DapCaptureData.EventCapture ec = new DapCaptureData.EventCapture(dapCaptureData, null, intVal);
            this.getObjStack().push(ec);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            DapCaptureData.EventCapture ec = (DapCaptureData.EventCapture)this.getObjStack().pop();
            Object parent = this.getObjStack().peek();
            if (parent instanceof String) {
                String grpName = (String)parent;
                this.getObjStack().pop();
                DapCaptureData.ViewCapture vc = (DapCaptureData.ViewCapture)this.getObjStack().peek();
                this.getObjStack().push(grpName);
                vc.addEventCapture(grpName, ec);
            } else if (parent instanceof DapCaptureData) {
                DapCaptureData data = (DapCaptureData)parent;
                data.setInitEventCapture(ec);
            }
        }
    }

    public static class EventCaptureSerializer
    extends ObjectSubSerializer {
        @Override
        protected String getDisplayName(String fldName, boolean capitalizeFirst) {
            if (DapCaptureXmlSerializer.FLDNAME_EVENT_TIME_INTERVAL.equals(fldName)) {
                return DapCaptureXmlSerializer.ATTRNAME_INTERVAL;
            }
            return super.getDisplayName(fldName, capitalizeFirst);
        }

        @Override
        protected String[] getAttrFields() {
            return new String[]{DapCaptureXmlSerializer.FLDNAME_EVENT_TIME_INTERVAL};
        }

        @Override
        protected String[] getNodeFields() {
            return new String[]{DapCaptureXmlSerializer.FLDNAME_EVENT, DapCaptureXmlSerializer.FLDNAME_ACTIONS};
        }
    }

    public static class HttpCallsHandler
    extends DapCaptureDataSubHandler {
        private Map<String, DapCaptureData.EventCapture> m_reqId2EC = new HashMap<String, DapCaptureData.EventCapture>();
        private Map<String, DapCaptureData.EventCapture> m_respId2EC = new HashMap<String, DapCaptureData.EventCapture>();
        private Map<String, DapHttpRequest> m_reqId2Req = new HashMap<String, DapHttpRequest>();

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if ("HttpReq".equals(name)) {
                DapCaptureData.EventCapture ec = (DapCaptureData.EventCapture)this.getObjStack().peek();
                String id = attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_ID);
                this.m_reqId2EC.put(id, ec);
            } else if ("HttpResp".equals(name)) {
                DapCaptureData.EventCapture ec = (DapCaptureData.EventCapture)this.getObjStack().peek();
                String id = attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_ID);
                this.m_respId2EC.put(id, ec);
            } else if (DapCaptureXmlSerializer.TAGNAME_HTTP_CALL.equals(name)) {
                String id = attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_ID);
                if (id == null) {
                    throw new DsfRuntimeException("HttpCall's id could never be null!");
                }
                this.getObjStack().push(id);
            } else if (DapCaptureXmlSerializer.TAGNAME_REQ.equals(name)) {
                String url = attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_URL);
                String method = attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_METHOD);
                boolean isAsync = attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_ASYNC) != null;
                DapHttpRequest req = new DapHttpRequest(method, url, isAsync);
                this.getObjStack().push(req);
            } else if (DapCaptureXmlSerializer.TAGNAME_RESP.equals(name)) {
                this.getObjStack().push(attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_TIME));
                DapHttpResponse resp = new DapHttpResponse();
                this.getObjStack().push(resp);
            } else if (DapCaptureXmlSerializer.TAGNAME_REQUEST_HEADERS.equals(name)) {
                HttpHeaderEntryHandler handler = new HttpHeaderEntryHandler();
                handler.initHandler(this.getHolder(), this.getObjStack(), this.getRegistry());
                this.getRegistry().put(DapCaptureXmlSerializer.TAGNAME_ENTRY, handler);
            } else if (DapCaptureXmlSerializer.TAGNAME_RESPONSE_HEADERS.equals(name)) {
                HttpHeaderEntryHandler handler = new HttpHeaderEntryHandler();
                handler.initHandler(this.getHolder(), this.getObjStack(), this.getRegistry());
                this.getRegistry().put(DapCaptureXmlSerializer.TAGNAME_ENTRY, handler);
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (DapCaptureXmlSerializer.TAGNAME_HTTP_CALL.equals(name)) {
                this.getObjStack().pop();
            } else if (DapCaptureXmlSerializer.TAGNAME_REQ.equals(name)) {
                DapHttpRequest req = (DapHttpRequest)this.getObjStack().pop();
                String id = (String)this.getObjStack().peek();
                DapCaptureData.EventCapture ec = this.m_reqId2EC.get(id);
                ec.addHttpReq(req);
                this.m_reqId2Req.put(id, req);
            } else if (DapCaptureXmlSerializer.TAGNAME_RESP.equals(name)) {
                DapHttpResponse resp = (DapHttpResponse)this.getObjStack().pop();
                String timeStr = (String)this.getObjStack().pop();
                String id = (String)this.getObjStack().peek();
                DapCaptureData.EventCapture ec = this.m_respId2EC.get(id);
                DapHttpRequest req = this.m_reqId2Req.get(id);
                ec.addHttpResp(req, resp);
                Map httpCalls = (Map)DapCaptureXmlSerializer.getFieldValue(DapCaptureXmlSerializer.getField(DapCaptureXmlSerializer.FLDNAME_HTTP_CALLS, DapCaptureData.class), this.getHolder().getValue());
                DapCaptureData.DapHttpCall httpCall = (DapCaptureData.DapHttpCall)httpCalls.get(new Integer(id));
                if (httpCall == null) {
                    throw new DsfRuntimeException("Can't not found HttpCall with ID: '" + id + "'");
                }
                DapCaptureXmlSerializer.setFieldValue(DapCaptureXmlSerializer.getField("m_respTime", DapCaptureData.DapHttpCall.class), httpCall, Long.parseLong(timeStr));
            } else if (DapCaptureXmlSerializer.TAGNAME_REQUEST_HEADERS.equals(name)) {
                this.getRegistry().remove(DapCaptureXmlSerializer.TAGNAME_ENTRY);
            } else if (DapCaptureXmlSerializer.TAGNAME_RESPONSE_HEADERS.equals(name)) {
                this.getRegistry().remove(DapCaptureXmlSerializer.TAGNAME_ENTRY);
            }
        }
    }

    public static class HttpCallsHandlerWrapper
    extends DapCaptureDataSubHandler {
        private static ThreadLocal<HttpCallsHandler> m_handler = new ThreadLocal();

        private HttpCallsHandler getHandler() {
            if (m_handler.get() == null) {
                m_handler.set(new HttpCallsHandler());
            }
            HttpCallsHandler handler = m_handler.get();
            handler.initHandler(this.getHolder(), this.getObjStack(), this.getRegistry());
            return handler;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.getHandler().startElement(uri, localName, name, attributes);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            this.getHandler().endElement(uri, localName, name);
        }
    }

    public static class HttpCallsSerializer
    extends MapSubSerializer {
        private DapHttpRequestSerializer m_reqSerializer = new DapHttpRequestSerializer();
        private DapHttpResponseSerializer m_respSerializer = new DapHttpResponseSerializer();

        @Override
        public void setRegistry(Map<String, DapCaptureDataSubSerializer> registry) {
            super.setRegistry(registry);
            this.m_reqSerializer.setRegistry(registry);
            this.m_respSerializer.setRegistry(registry);
        }

        @Override
        protected void serializeEntry(Map.Entry<?, ?> entry, XmlStreamWriter writer) {
            Integer id = (Integer)entry.getKey();
            DapCaptureData.DapHttpCall call = (DapCaptureData.DapHttpCall)entry.getValue();
            writer.writeStartElement(DapCaptureXmlSerializer.TAGNAME_HTTP_CALL);
            writer.writeAttribute(DapCaptureXmlSerializer.ATTRNAME_ID, id.toString());
            this.m_reqSerializer.serialize(DapCaptureXmlSerializer.CLZNAME_DAP_HTTP_REQUEST, call.getRequest(), writer, DapCaptureXmlSerializer.TAGNAME_REQ);
            this.m_respSerializer.m_respTime = Long.toString(call.getResponseTime());
            this.m_respSerializer.serialize(DapCaptureXmlSerializer.CLZNAME_DAP_HTTP_RESPONSE, call.getResponse(), writer, DapCaptureXmlSerializer.TAGNAME_RESP);
            writer.writeEndElement();
        }
    }

    public static class HttpHeaderEntryHandler
    extends MapEntryHandler {
        @Override
        protected void onEntry(String key, String value) {
            Object obj = this.getObjStack().peek();
            if (obj instanceof DapHttpRequest) {
                DapHttpRequest req = (DapHttpRequest)obj;
                req.setRequestHeader(key, value);
            } else if (obj instanceof DapHttpResponse) {
                DapHttpResponse resp = (DapHttpResponse)obj;
                if (resp.getResponseHeaders() == null) {
                    resp.setResponseHeaders(new HashMap<String, String>());
                }
                resp.getResponseHeaders().put(key, value);
            }
        }
    }

    public static class HttpHeaderSerializer
    extends MapSubSerializer {
        @Override
        protected void serializeEntry(Map.Entry<?, ?> entry, XmlStreamWriter writer) {
            writer.writeStartElement(DapCaptureXmlSerializer.TAGNAME_ENTRY);
            writer.writeAttribute(DapCaptureXmlSerializer.ATTRNAME_KEY, entry.getKey().toString());
            writer.writeAttribute(DapCaptureXmlSerializer.ATTRNAME_VALUE, entry.getValue().toString());
            writer.writeEndElement();
        }
    }

    public static class HttpMsgSerializer
    extends ObjectSubSerializer {
        @Override
        protected String[] getAttrFields() {
            return new String[]{DapCaptureXmlSerializer.FLDNAME_ID};
        }
    }

    public static class KeyInfoHandler
    extends DapCaptureDataSubHandler {
        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            DLCEvent.KeyInfo ki = new DLCEvent.KeyInfo();
            DLCEvent e = (DLCEvent)this.getObjStack().peek();
            e.setKeyInfo(ki);
            if (attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_ALT) != null) {
                ki.setAltKey(true);
            }
            if (attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_CTRL) != null) {
                ki.setCtrlKey(true);
            }
            if (attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_META) != null) {
                ki.setMetaKey(true);
            }
            if (attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_SHIFT) != null) {
                ki.setShiftKey(true);
            }
            this.getObjStack().push(ki);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            this.getObjStack().pop();
        }
    }

    public static class KeyInfoSerializer
    extends ObjectSubSerializer {
        @Override
        protected void serializeAttrs(Object obj, XmlStreamWriter writer, Class<?> ctnClz) {
            DLCEvent.KeyInfo ki = (DLCEvent.KeyInfo)obj;
            if (ki.isAltKey()) {
                writer.writeAttribute(DapCaptureXmlSerializer.ATTRNAME_ALT, DapCaptureXmlSerializer.EMPTY_STR);
            }
            if (ki.isCtrlKey()) {
                writer.writeAttribute(DapCaptureXmlSerializer.ATTRNAME_CTRL, DapCaptureXmlSerializer.EMPTY_STR);
            }
            if (ki.isMetaKey()) {
                writer.writeAttribute(DapCaptureXmlSerializer.ATTRNAME_META, DapCaptureXmlSerializer.EMPTY_STR);
            }
            if (ki.isShiftKey()) {
                writer.writeAttribute(DapCaptureXmlSerializer.ATTRNAME_SHIFT, DapCaptureXmlSerializer.EMPTY_STR);
            }
        }

        @Override
        protected String[] getNodeFields() {
            return new String[]{DapCaptureXmlSerializer.FLDNAME_CHAR_CODE, DapCaptureXmlSerializer.FLDNAME_KEY_CODE, DapCaptureXmlSerializer.FLDNAME_KEY_LOCATION, DapCaptureXmlSerializer.FLDNAME_KEY_IDENTIFIER};
        }
    }

    public static abstract class MapEntryHandler
    extends DapCaptureDataSubHandler {
        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            String key = attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_KEY);
            String value = attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_VALUE);
            this.onEntry(key, value);
        }

        protected abstract void onEntry(String var1, String var2);
    }

    public static abstract class MapSubSerializer
    extends DapCaptureDataSubSerializer {
        @Override
        public void serialize(String currentPath, Object obj, XmlStreamWriter writer, String tagName) {
            if (tagName == null) {
                throw new DsfRuntimeException("MapSubSerializer needs tagName input!");
            }
            if (obj == null) {
                return;
            }
            if (!(obj instanceof Map)) {
                return;
            }
            Map map = (Map)obj;
            if (map.size() == 0) {
                return;
            }
            writer.writeStartElement(tagName);
            for (Map.Entry entry : map.entrySet()) {
                this.serializeEntry(entry, writer);
            }
            writer.writeEndElement();
        }

        protected abstract void serializeEntry(Map.Entry<?, ?> var1, XmlStreamWriter var2);
    }

    public static class NodeAppendSerializer
    extends ObjectSubSerializer {
        @Override
        protected String[] getNodeFields() {
            return new String[]{DapCaptureXmlSerializer.FLDNAME_PARENT_PATH, DapCaptureXmlSerializer.FLDNAME_NODE_HTML};
        }
    }

    public static class NodeAttrUpdateSerializer
    extends ObjectSubSerializer {
        @Override
        protected String[] getNodeFields() {
            return new String[]{DapCaptureXmlSerializer.FLDNAME_PATH, DapCaptureXmlSerializer.FLDNAME_NAME, DapCaptureXmlSerializer.FLDNAME_VALUE};
        }
    }

    public static class NodeInsertSerializer
    extends ObjectSubSerializer {
        @Override
        protected String[] getNodeFields() {
            return new String[]{DapCaptureXmlSerializer.FLDNAME_REF_PATH, DapCaptureXmlSerializer.FLDNAME_NODE_HTML, DapCaptureXmlSerializer.FLDNAME_INSERT_BEFORE};
        }
    }

    public static class NodeRemoveSerializer
    extends ObjectSubSerializer {
        @Override
        protected String[] getNodeFields() {
            return new String[]{DapCaptureXmlSerializer.FLDNAME_PATH, DapCaptureXmlSerializer.FLDNAME_NODE_HTML};
        }
    }

    public static class NodeUpdateSerializer
    extends ObjectSubSerializer {
        @Override
        protected String[] getNodeFields() {
            return new String[]{DapCaptureXmlSerializer.FLDNAME_PATH, DapCaptureXmlSerializer.FLDNAME_NODE_HTML};
        }
    }

    public static class NodeValueUpdateSerializer
    extends ObjectSubSerializer {
        @Override
        protected String[] getNodeFields() {
            return new String[]{DapCaptureXmlSerializer.FLDNAME_PATH, DapCaptureXmlSerializer.FLDNAME_VALUE};
        }
    }

    public static class ObjectSubSerializer
    extends DapCaptureDataSubSerializer {
        protected String getDefaultTagName(Object obj) {
            return obj.getClass().getSimpleName();
        }

        protected String[] getAttrFields() {
            return null;
        }

        protected String[] getNodeFields() {
            return null;
        }

        protected boolean isDefaultValue(String fldName, Object fldValue) {
            boolean isDefault = false;
            if (fldValue == null) {
                isDefault = true;
            } else {
                Class<?> fldClz = fldValue.getClass();
                if (String.class.isAssignableFrom(fldClz) && fldValue == null || Integer.class.isAssignableFrom(fldClz) && DEFAULT_INT.equals(fldValue) || Long.class.isAssignableFrom(fldClz) && DEFAULT_LONG.equals(fldValue) || Double.class.isAssignableFrom(fldClz) && DEFAULT_DOUBLE.equals(fldValue) || Boolean.class.isAssignableFrom(fldClz) && DEFAULT_BOOLEAN.equals(fldValue) || Short.class.isAssignableFrom(fldClz) && DEFAULT_SHORT.equals(fldValue) || Float.class.isAssignableFrom(fldClz) && DEFAULT_FLOAT.equals(fldValue) || Short.TYPE.equals(fldClz) && Short.parseShort(fldValue.toString()) == 0 || Integer.TYPE.equals(fldClz) && Integer.parseInt(fldValue.toString()) == 0 || Float.TYPE.equals(fldClz) && Float.parseFloat(fldValue.toString()) == 0.0f || Double.TYPE.equals(fldClz) && Double.parseDouble(fldValue.toString()) == 0.0 || Boolean.TYPE.equals(fldClz) && !Boolean.parseBoolean(fldValue.toString()) || Long.TYPE.equals(fldClz) && Long.parseLong(fldValue.toString()) == 0L) {
                    isDefault = true;
                }
            }
            return isDefault;
        }

        protected String getDisplayName(String fldName, boolean capitalizeFirst) {
            String dsplName = fldName;
            if (dsplName != null && dsplName.startsWith(DapCaptureXmlSerializer.M_)) {
                char first;
                dsplName = fldName.substring(2);
                if (capitalizeFirst && Character.isLowerCase(first = dsplName.charAt(0))) {
                    dsplName = dsplName.replaceFirst(String.valueOf(first), String.valueOf(Character.toUpperCase(first)));
                }
            }
            return dsplName;
        }

        @Override
        public void serialize(String currentPath, Object obj, XmlStreamWriter writer, String tagName) {
            if (obj == null) {
                return;
            }
            String dsplName = tagName;
            if (dsplName == null) {
                dsplName = this.getDefaultTagName(obj);
            }
            Class<?> ctnClz = obj.getClass();
            String ctnClzName = ctnClz.getSimpleName();
            writer.writeStartElement(dsplName);
            this.serializeAttrs(obj, writer, ctnClz);
            this.serializeNodes(obj, writer, ctnClz, ctnClzName);
            writer.writeEndElement();
        }

        protected void serializeNodes(Object obj, XmlStreamWriter writer, Class<?> ctnClz, String ctnClzName) {
            String[] nodeFlds = this.getNodeFields();
            if (nodeFlds != null) {
                String[] stringArray = nodeFlds;
                int n = nodeFlds.length;
                int n2 = 0;
                while (n2 < n) {
                    String path;
                    DapCaptureDataSubSerializer subSerializer;
                    String nodeFld = stringArray[n2];
                    Object value = DapCaptureXmlSerializer.getFieldValue(DapCaptureXmlSerializer.getField(nodeFld, ctnClz), obj);
                    if (!this.isDefaultValue(nodeFld, value) && (subSerializer = this.getSubSerializer(path = String.valueOf(ctnClzName) + DapCaptureXmlSerializer.DOT + nodeFld)) != null) {
                        subSerializer.serialize(path, value, writer, this.getDisplayName(nodeFld, true));
                    }
                    ++n2;
                }
            }
        }

        protected void serializeAttrs(Object obj, XmlStreamWriter writer, Class<?> ctnClz) {
            String[] attrFlds = this.getAttrFields();
            if (attrFlds != null) {
                String[] stringArray = attrFlds;
                int n = attrFlds.length;
                int n2 = 0;
                while (n2 < n) {
                    String attrFld = stringArray[n2];
                    Object value = DapCaptureXmlSerializer.getFieldValue(DapCaptureXmlSerializer.getField(attrFld, ctnClz), obj);
                    if (!this.isDefaultValue(attrFld, value)) {
                        writer.writeAttribute(this.getDisplayName(attrFld, false), value.toString());
                    }
                    ++n2;
                }
            }
        }
    }

    public static class PositionHandler
    extends DapCaptureDataSubHandler {
        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (DapCaptureXmlSerializer.TAGNAME_POSITION.equals(name)) {
                DLCEvent.Position pos = new DLCEvent.Position();
                DLCEvent e = (DLCEvent)this.getObjStack().peek();
                e.setPosition(pos);
                this.getObjStack().push(pos);
            } else if (DapCaptureXmlSerializer.TAGNAME_CLIENT.equals(name)) {
                this.parsePositionXY(attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_X), DapCaptureXmlSerializer.FLDNAME_CLIENT_X);
                this.parsePositionXY(attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_Y), DapCaptureXmlSerializer.FLDNAME_CLIENT_Y);
            } else if (DapCaptureXmlSerializer.TAGNAME_MOUSE.equals(name)) {
                this.parsePositionXY(attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_X), DapCaptureXmlSerializer.FLDNAME_MOUSE_X);
                this.parsePositionXY(attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_Y), DapCaptureXmlSerializer.FLDNAME_MOUSE_Y);
            } else if (DapCaptureXmlSerializer.TAGNAME_PAGE.equals(name)) {
                this.parsePositionXY(attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_X), DapCaptureXmlSerializer.FLDNAME_PAGE_X);
                this.parsePositionXY(attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_Y), DapCaptureXmlSerializer.FLDNAME_PAGE_Y);
            } else if (DapCaptureXmlSerializer.TAGNAME_SCREEN.equals(name)) {
                this.parsePositionXY(attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_X), DapCaptureXmlSerializer.FLDNAME_SCREEN_X);
                this.parsePositionXY(attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_Y), DapCaptureXmlSerializer.FLDNAME_SCREEN_Y);
            }
        }

        private void parsePositionXY(String y, String fldName) {
            if (y != null && !DapCaptureXmlSerializer.EMPTY_STR.equals(y)) {
                DapCaptureXmlSerializer.setFieldValue(DapCaptureXmlSerializer.getField(fldName, DLCEvent.Position.class), this.getObjStack().peek(), Integer.parseInt(y));
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (DapCaptureXmlSerializer.TAGNAME_POSITION.equals(name)) {
                this.getObjStack().pop();
            }
        }
    }

    public static class PositionSerializer
    extends ObjectSubSerializer {
        @Override
        protected void serializeNodes(Object obj, XmlStreamWriter writer, Class<?> ctnClz, String ctnClzName) {
            DLCEvent.Position pos = (DLCEvent.Position)obj;
            this.writePositionXY(writer, DapCaptureXmlSerializer.TAGNAME_CLIENT, pos.getClientX(), pos.getClientY());
            this.writePositionXY(writer, DapCaptureXmlSerializer.TAGNAME_MOUSE, pos.getMouseX(), pos.getMouseY());
            this.writePositionXY(writer, DapCaptureXmlSerializer.TAGNAME_PAGE, pos.getPageX(), pos.getPageY());
            this.writePositionXY(writer, DapCaptureXmlSerializer.TAGNAME_SCREEN, pos.getScreenX(), pos.getScreenY());
        }

        private void writePositionXY(XmlStreamWriter writer, String tagName, int x, int y) {
            boolean needY;
            boolean needX = !this.isDefaultValue(null, x);
            boolean bl = needY = !this.isDefaultValue(null, y);
            if (needX || needY) {
                writer.writeStartElement(tagName);
                if (needX) {
                    writer.writeAttribute(DapCaptureXmlSerializer.ATTRNAME_X, String.valueOf(x));
                }
                if (needY) {
                    writer.writeAttribute(DapCaptureXmlSerializer.ATTRNAME_Y, String.valueOf(y));
                }
                writer.writeEndElement();
            }
        }
    }

    public static class PrimitiveHandler
    extends DapCaptureDataSubHandler {
        private boolean m_newChar;

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.getObjStack().push(new ValueHolder());
            this.m_newChar = true;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String newChars = new String(ch, start, length);
            ValueHolder valueHolder = (ValueHolder)this.getObjStack().peek();
            if (this.m_newChar) {
                valueHolder.setValue(newChars);
                this.m_newChar = false;
            } else {
                String chars = (String)valueHolder.getValue();
                chars = String.valueOf(chars) + newChars;
                valueHolder.setValue(chars);
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            ValueHolder valueHolder = (ValueHolder)this.getObjStack().pop();
            String value = DapCaptureXmlSerializer.unwrapEmptyString((String)valueHolder.getValue());
            Object parentObj = this.getObjStack().peek();
            if (parentObj instanceof Collection) {
                Collection c = (Collection)parentObj;
                c.add(value);
            } else {
                DapCaptureXmlSerializer.setFieldValue(DapCaptureXmlSerializer.getField(this.getFldName(name), parentObj.getClass()), parentObj, value);
            }
        }

        protected String getFldName(String tagName) {
            String fldName = tagName;
            if (tagName != null) {
                char first = fldName.charAt(0);
                if (Character.isUpperCase(first)) {
                    fldName = fldName.replaceFirst(String.valueOf(first), String.valueOf(Character.toLowerCase(first)));
                }
                fldName = DapCaptureXmlSerializer.M_ + fldName;
            }
            return fldName;
        }
    }

    public static class RawCDataSerializer
    extends DapCaptureDataSubSerializer {
        @Override
        public void serialize(String currentPath, Object obj, XmlStreamWriter writer, String tagName) {
            writer.writeCData(DapCaptureXmlSerializer.wrapEmptyString(obj.toString()));
        }
    }

    public static class TaskCaptureHandler
    extends DapCaptureDataSubHandler {
        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            DapCaptureData data = this.getHolder().getValue();
            String msgStr = attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_MSG);
            DapCaptureData dapCaptureData = data;
            dapCaptureData.getClass();
            DapCaptureData.TaskCapture tc = new DapCaptureData.TaskCapture(dapCaptureData, msgStr);
            this.getObjStack().push(tc);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            DapCaptureData.TaskCapture tc = (DapCaptureData.TaskCapture)this.getObjStack().pop();
            Object parent = this.getObjStack().peek();
            if (parent instanceof String) {
                String grpName = (String)parent;
                this.getObjStack().pop();
                DapCaptureData.ViewCapture vc = (DapCaptureData.ViewCapture)this.getObjStack().peek();
                this.getObjStack().push(grpName);
                vc.addEventCapture(grpName, tc);
            }
        }
    }

    public static class TaskCaptureSerializer
    extends ObjectSubSerializer {
        @Override
        protected String getDisplayName(String fldName, boolean capitalizeFirst) {
            if (DapCaptureXmlSerializer.FLDNAME_MSG.equals(fldName)) {
                return DapCaptureXmlSerializer.ATTRNAME_MSG;
            }
            return super.getDisplayName(fldName, capitalizeFirst);
        }

        @Override
        protected String[] getAttrFields() {
            return new String[]{DapCaptureXmlSerializer.FLDNAME_MSG};
        }

        @Override
        protected String[] getNodeFields() {
            return new String[]{DapCaptureXmlSerializer.FLDNAME_ACTIONS};
        }
    }

    public static class ValueHolder<T> {
        private T m_value;

        public void setValue(T value) {
            this.m_value = value;
        }

        public T getValue() {
            return this.m_value;
        }
    }

    public static class ViewCaptureHandler
    extends DapCaptureDataSubHandler {
        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            DapCaptureData data;
            DapCaptureData dapCaptureData = data = this.getHolder().getValue();
            dapCaptureData.getClass();
            DapCaptureData.ViewCapture vc = new DapCaptureData.ViewCapture(dapCaptureData, attributes.getValue(DapCaptureXmlSerializer.ATTRNAME_URL));
            data.addViewCapture(vc);
            this.getObjStack().push(vc);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            this.getObjStack().pop();
        }
    }

    public static class ViewCaptureSerializer
    extends ObjectSubSerializer {
        @Override
        protected String[] getAttrFields() {
            return new String[]{DapCaptureXmlSerializer.FLDNAME_URL};
        }

        @Override
        protected String[] getNodeFields() {
            return new String[]{DapCaptureXmlSerializer.FLDNAME_IEVENT_CAPTURES};
        }
    }
}

