/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.js;

import java.util.Vector;
import org.eclipse.vjet.dsf.html.js.JSAction;
import org.eclipse.vjet.dsf.html.js.JSListener;

public class JSAnalysisListener
implements JSListener {
    private Vector m_actions = new Vector();

    @Override
    public void reset() {
        this.m_actions.removeAllElements();
    }

    @Override
    public String doAction(int actionType, String name, String value, String targetId) {
        String localValue = value;
        if (actionType == 1) {
            localValue = this.cookieAction(localValue);
        } else if (actionType == 9) {
            localValue = this.inputAction(name, targetId, localValue);
        } else if (actionType == 11) {
            localValue = this.inputCheckedAction(name, targetId, localValue);
        } else if (actionType == 13) {
            localValue = this.selectedIndexAction(name, targetId, localValue);
        } else if (actionType == 19) {
            localValue = this.textareaAction(name, targetId, localValue);
        }
        if (actionType != 1) {
            this.m_actions.add(new JSAction(actionType, name, localValue, targetId));
        }
        return value;
    }

    private String textareaAction(String name, String targetId, String value) {
        String localValue = value;
        int numActions = this.m_actions.size();
        int i = numActions - 1;
        while (i >= 0) {
            JSAction action = (JSAction)this.m_actions.get(i);
            if (action.m_actionType == 20 && action.m_actor.equals(name) && action.m_targetId.equals(targetId)) {
                localValue = action.m_value;
            }
            --i;
        }
        if (localValue == null || localValue.length() == 0) {
            localValue = "_dsf_" + name;
        }
        return localValue;
    }

    private String selectedIndexAction(String name, String targetId, String value) {
        String localValue = value;
        int numActions = this.m_actions.size();
        int i = numActions - 1;
        while (i >= 0) {
            JSAction action = (JSAction)this.m_actions.get(i);
            if (action.m_actionType == 14 && action.m_actor.equals(name) && action.m_targetId.equals(targetId)) {
                localValue = action.m_value;
            }
            --i;
        }
        return localValue;
    }

    private String inputCheckedAction(String name, String targetId, String value) {
        String localValue = value;
        int numActions = this.m_actions.size();
        int i = numActions - 1;
        while (i >= 0) {
            JSAction action = (JSAction)this.m_actions.get(i);
            if (action.m_actionType == 12 && action.m_actor.equals(name) && action.m_targetId.equals(targetId)) {
                localValue = action.m_value;
            }
            --i;
        }
        if (localValue == null || localValue.length() == 0) {
            localValue = "false";
        }
        return localValue;
    }

    private String inputAction(String name, String targetId, String value) {
        String localValue = value;
        int numActions = this.m_actions.size();
        int i = numActions - 1;
        while (i >= 0) {
            JSAction action = (JSAction)this.m_actions.get(i);
            if (action.m_actionType == 10 && action.m_actor.equals(name) && action.m_targetId.equals(targetId)) {
                localValue = action.m_value;
            }
            --i;
        }
        if (localValue == null || localValue.length() == 0) {
            localValue = "_dsf_" + name;
        }
        return localValue;
    }

    private String cookieAction(String value) {
        String localValue = value;
        int numActions = this.m_actions.size();
        int i = numActions - 1;
        while (i >= 0) {
            JSAction action = (JSAction)this.m_actions.get(i);
            if (action.m_actionType == 2) {
                localValue = action.m_value;
            }
            --i;
        }
        return localValue;
    }

    @Override
    public int getLength() {
        return this.m_actions.size();
    }

    @Override
    public JSAction get(int index) {
        if (index < 0 || index >= this.m_actions.size()) {
            return null;
        }
        return (JSAction)this.m_actions.get(index);
    }
}

