/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.js;

import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.html.dom.DForm;
import org.eclipse.vjet.dsf.html.dom.DHtmlCollection;
import org.eclipse.vjet.dsf.html.dom.DInput;
import org.eclipse.vjet.dsf.html.dom.DSelect;
import org.eclipse.vjet.dsf.html.dom.DTextArea;
import org.eclipse.vjet.dsf.html.js.JSDebug;
import org.eclipse.vjet.dsf.html.js.JSFormElementArray;
import org.eclipse.vjet.dsf.html.js.JSInput;
import org.eclipse.vjet.dsf.html.js.JSSelect;
import org.eclipse.vjet.dsf.html.js.JSTextArea;
import org.eclipse.vjet.dsf.html.js.JSWindow;
import org.eclipse.vjet.dsf.html.js.JsHackDetectionCtx;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;
import org.w3c.dom.Node;

public class JSForm
extends ScriptableObject {
    private JSWindow window = null;
    private DForm form = null;
    private JSFormElementArray elements = null;
    public String name = null;
    public String formId = null;

    private JSForm() {
    }

    public JSForm(JSWindow window, DForm form) {
        this.window = window;
        this.form = form;
        this.elements = new JSFormElementArray(window, form);
        this.name = form.getHtmlName();
        this.formId = form.getAttribute("form-id");
        String[] functions = new String[]{"submit", "reset"};
        this.defineFunctionProperties(functions, JSForm.class, 2);
        this.defineProperty("elements", JSForm.class, 1);
        this.defineProperty("action", JSForm.class, 2);
        this.defineProperty("id", JSForm.class, 2);
    }

    public JSForm(JSWindow window, String formId) {
        this.window = window;
        this.form = null;
        this.elements = new JSFormElementArray(window, this.form);
        this.name = "fake_form";
        this.formId = formId;
    }

    public String getClassName() {
        return "JSForm";
    }

    public void submit() {
        JsHackDetectionCtx.ctx().setLocationChange(this.form.getHtmlAction());
        if (this.window.windowState == JSWindow.IN_LOADING) {
            String method = this.form.getHtmlMethod();
            String url = this.form.getHtmlAction();
            String params = this.getFormParams();
            this.window.getJSListener().doAction(7, method, url, params);
        } else {
            this.window.getJSListener().doAction(7, this.name, null, this.formId);
        }
    }

    public void reset() {
        this.window.getJSListener().doAction(8, this.name, null, this.formId);
    }

    public Scriptable getElements() {
        return this.elements;
    }

    public int getLength() {
        return this.form.getHtmlLength();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.form.setHtmlName(name);
        this.name = name;
    }

    public String getAcceptCharset() {
        return this.form.getHtmlAcceptCharset();
    }

    public void setAcceptCharset(String acceptCharset) {
        this.form.setHtmlAcceptCharset(acceptCharset);
    }

    public String getAction() {
        return this.form.getHtmlAction();
    }

    public void setAction(String action) {
        if (this.window.windowState == JSWindow.IN_LOADING) {
            this.form.setHtmlAction(action);
        } else {
            this.window.getJSListener().doAction(21, this.name, action, this.formId);
        }
    }

    public String getId() {
        return this.form.getHtmlId();
    }

    public void setHtmlId(String id) {
        this.form.setHtmlId(id);
    }

    public String getEnctype() {
        return this.form.getHtmlEnctype();
    }

    public void setEnctype(String enctype) {
        this.form.setHtmlEnctype(enctype);
    }

    public String getMethod() {
        return this.form.getHtmlMethod();
    }

    public void setMethod(String method) {
        this.form.setHtmlMethod(method);
    }

    public String getTarget() {
        return this.form.getHtmlTarget();
    }

    public void setTarget(String target) {
        this.form.setHtmlTarget(target);
    }

    public void addJSFormChildElem(DElement formChildElem) {
        if (formChildElem instanceof DInput) {
            DInput input = (DInput)formChildElem;
            String name = input.getHtmlName();
            this.defineElement(name);
            this.elements.add((Object)new JSInput(this.window, input));
        } else if (formChildElem instanceof DSelect) {
            DSelect select = (DSelect)formChildElem;
            String name = select.getHtmlName();
            this.defineElement(name);
            this.elements.add((Object)new JSSelect(this.window, select));
        } else if (formChildElem instanceof DTextArea) {
            DTextArea textArea = (DTextArea)formChildElem;
            String name = textArea.getHtmlName();
            this.defineElement(name);
            this.elements.add((Object)new JSTextArea(this.window, textArea));
        }
    }

    public void defineElement(String name) {
        try {
            Class[] getArg = new Class[]{ScriptableObject.class};
            Class[] setArg = new Class[]{ScriptableObject.class, Object.class};
            this.defineProperty(name, (Object)this, ((Object)((Object)this)).getClass().getDeclaredMethod("getMyField", getArg), ((Object)((Object)this)).getClass().getDeclaredMethod("setMyField", setArg), 2);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }

    Object getMyField(ScriptableObject obj) {
        JSDebug.println("***getMyField : " + obj.toString());
        return null;
    }

    void setMyField(ScriptableObject obj, Object value) {
        JSDebug.println("***setMyField : " + obj.toString());
    }

    public Object get(String name, Scriptable start) {
        Object obj = null;
        obj = this.elements.findElemObject(name);
        if (obj != null) {
            return obj;
        }
        obj = super.get(name, start);
        if (obj == NOT_FOUND) {
            obj = this.window.get(name, start);
        }
        if (obj == NOT_FOUND) {
            obj = this.window.getDocument().get(name, start);
        }
        return obj;
    }

    public Object findElemObject(String name) {
        return this.elements.findElemObject(name);
    }

    public Object valueOf(String type) {
        if (type.equals("boolean")) {
            return Boolean.TRUE;
        }
        if (type.equals("string")) {
            return this.name;
        }
        if (type.equals("object")) {
            return this;
        }
        if (type.equals("number")) {
            return "0";
        }
        return null;
    }

    public String getFormParams() {
        StringBuffer params = new StringBuffer();
        DHtmlCollection elems = this.form.getHtmlElements();
        int size = elems.getLength();
        int i = 0;
        while (i < size) {
            Node fieldElem = elems.item(i);
            if (fieldElem instanceof DInput) {
                DInput input = (DInput)fieldElem;
                String name = input.getHtmlName();
                String value = input.getHtmlValue();
                if (name != null && value != null) {
                    if (params.length() != 0) {
                        params.append("&");
                    }
                    params.append(name).append("=").append(value);
                }
            }
            ++i;
        }
        return params.toString();
    }
}

