/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsrunner;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.vjet.dsf.active.client.AHtmlParser;
import org.eclipse.vjet.dsf.active.client.AWindow;
import org.eclipse.vjet.dsf.active.client.ScriptExecutor;
import org.eclipse.vjet.dsf.active.client.WindowFactory;
import org.eclipse.vjet.dsf.active.util.ScriptingSessionClassLoader;
import org.eclipse.vjet.dsf.active.util.VJContextFactory;
import org.eclipse.vjet.dsf.dap.proxy.ScriptEngineCtx;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.IBrowserEmulatorListener;
import org.eclipse.vjet.dsf.html.js.ActiveJsExecutionControlCtx;
import org.eclipse.vjet.dsf.jsdebugger.DebuggerAdapter;
import org.eclipse.vjet.dsf.jsdebugger.JsDebuggerEnabler;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.eclipse.vjet.dsf.json.JsonObject;
import org.eclipse.vjet.dsf.jsrunner.ActiveWeb;
import org.eclipse.vjet.dsf.jsrunner.BrowserRemoteLauncher;
import org.eclipse.vjet.dsf.jsrunner.IBrowserLauncher;
import org.eclipse.vjet.dsf.service.serializer.JsonSerializer;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.ContextFactory;
import org.mozilla.mod.javascript.IJsJavaProxy;
import org.mozilla.mod.javascript.Scriptable;

public class JsRunner {
    protected DebuggerAdapter m_dbg = null;
    protected AWindow m_window = null;
    protected Context m_cx;
    protected Scriptable m_scope;
    protected ActiveWeb m_activeWeb;
    protected ProgramInfo m_info;
    protected DapCtx.ExeMode m_mode = DapCtx.ExeMode.TRANSLATE;
    public static final String JS_OPTION_TOKEN = "-V";
    public static final String BROWSER_KEY = "browser";
    public static final String LOAD_JS_KEY = "loadJs";
    public static final String LOAD_HTML_KEY = "loadHtml";
    public static final String BROWSER_DISPLAY_KEY = "browserDisplay";
    public static final String BROWSER_SERVICE_URL_KEY = "browserServiceUrl";
    public static final String FILE_TYPE_KEY = "type";
    public static final String HTML_FILE_TYPE = "html";
    public static final String DAP_MODE_KEY = "dapMode";
    public static final String WAIT_TIMEOUT_KEY = "waitTimeout";
    public static final String A_MODE_VALUE = "A";
    public static final String W_MODE_VALUE = "W";
    public static final String LIST_SEPERATOR = ";";
    public static final String HTTP = "http://";
    private static final String TEST_HTML_PAGE = "<html><head><title>VJET TEST PAGE</title></head><body></body></html>";

    public static void main(String[] args) {
        try {
            ProgramInfo info = JsRunner.getProgramInfo(args);
            if (A_MODE_VALUE.equals(info.getOption(DAP_MODE_KEY))) {
                DapCtx.ctx().setExeMode(DapCtx.ExeMode.ACTIVE);
            }
            BrowserRemoteLauncher browserLauncher = null;
            String browserServiceUrl = info.getBrowserServiceUrl();
            if (browserServiceUrl != null) {
                browserLauncher = new BrowserRemoteLauncher(browserServiceUrl);
            }
            JsRunner runner = new JsRunner(info, JsRunner.needDebug(), browserLauncher);
            if (runner.m_activeWeb != null) {
                runner.m_activeWeb.waitForWindowLoaded();
                runner.m_activeWeb.waitForExit();
                runner.m_activeWeb.destroy();
                return;
            }
            runner.complete();
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Provided  JS File path is not correct : " + args[0]);
        }
    }

    public JsRunner(ProgramInfo info, boolean debug) {
        this(info, debug, null);
    }

    public JsRunner(ProgramInfo info, boolean debug, IBrowserLauncher launcher) {
        this.m_info = info;
        String modeValue = this.m_info.getOption(DAP_MODE_KEY);
        if (A_MODE_VALUE.equals(modeValue)) {
            this.m_mode = DapCtx.ExeMode.ACTIVE;
        } else if (W_MODE_VALUE.equals(modeValue)) {
            this.m_mode = DapCtx.ExeMode.WEB;
        }
        BrowserType type = this.m_info.getBrowserType();
        String htmlFile = this.m_info.getPreloadHtml();
        InputStream htmlInputStream = null;
        if (htmlFile != null) {
            try {
                htmlInputStream = JsRunner.toUrl(htmlFile).openConnection().getInputStream();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (htmlFile == null && (this.m_info.needBrowserDisplay() || this.m_mode == DapCtx.ExeMode.WEB)) {
            htmlInputStream = new ByteArrayInputStream(TEST_HTML_PAGE.getBytes());
        }
        if (htmlInputStream != null && (this.m_info.needBrowserDisplay() || this.m_mode == DapCtx.ExeMode.WEB)) {
            this.loadActiveWeb(htmlInputStream, launcher);
            if (this.m_mode == DapCtx.ExeMode.WEB) {
                this.preloadJs();
                this.m_activeWeb.loadJs(this.m_info.getFileName());
            } else {
                this.m_activeWeb.addListener(this.createWebListener(debug));
            }
            this.m_activeWeb.displayUrlInBrowser(type);
            return;
        }
        if (!ContextFactory.hasExplicitGlobal()) {
            ContextFactory.initGlobal((ContextFactory)new VJContextFactory());
        }
        if (debug) {
            this.initDebugger(type != null);
        }
        if (type != null) {
            ActiveJsExecutionControlCtx.ctx().setExecuteJavaScript(true);
            this.m_window = (AWindow)WindowFactory.createWindow(type);
            this.m_cx = this.m_window.getContext();
            this.m_scope = this.m_window;
            if (debug) {
                this.m_dbg = this.m_window.getDebugger();
            }
        } else {
            this.m_cx = ContextFactory.getGlobal().enterContext();
            if (DapCtx.ctx().isActiveMode()) {
                this.m_cx.setApplicationClassLoader((ClassLoader)new ScriptingSessionClassLoader());
            }
            this.m_cx.setLanguageVersion(150);
            this.m_cx.setOptimizationLevel(-1);
            this.m_scope = this.m_cx.initStandardObjects();
            if (DapCtx.ctx().isActiveMode()) {
                ScriptEngineCtx scriptEngineCtx = ScriptEngineCtx.ctx();
                scriptEngineCtx.setScriptContext(this.m_cx);
                scriptEngineCtx.setScope(this.m_scope);
            }
        }
    }

    public void complete() {
        if (this.m_activeWeb != null) {
            return;
        }
        if (this.m_dbg != null) {
            this.m_dbg.setBreak();
        }
        try {
            this.preload();
            if (this.m_info.isHtml()) {
                this.loadHtml(this.m_info.getFileName());
                this.execMain(this.m_info.getJsClassName(), this.m_info.getJsArgs());
            } else {
                this.exec(this.m_info.getFileName(), this.m_info.getJsClassName(), this.m_info.getJsArgs());
            }
        }
        catch (Throwable throwable) {
            String timeout = this.m_info.getOption(WAIT_TIMEOUT_KEY);
            this.finalize(timeout == null ? 1 : Integer.parseInt(timeout));
            throw throwable;
        }
        String timeout = this.m_info.getOption(WAIT_TIMEOUT_KEY);
        this.finalize(timeout == null ? 1 : Integer.parseInt(timeout));
    }

    public void preload() {
        this.preloadHtml();
        this.preloadJs();
    }

    public void preloadHtml() {
        String htmlFile = this.m_info.getPreloadHtml();
        if (htmlFile != null) {
            this.loadHtml(htmlFile);
        }
    }

    public void preloadJs() {
        List<String> ls = this.m_info.getPreloadJsList();
        if (ls == null) {
            return;
        }
        for (String jsFileName : ls) {
            if (this.m_mode == DapCtx.ExeMode.WEB) {
                this.m_activeWeb.loadJs(JsRunner.toUrl(jsFileName));
                continue;
            }
            this.runScript(JsRunner.toUrl(jsFileName));
        }
    }

    public void loadHtml(String htmlFile) {
        this.loadHtml(JsRunner.toUrl(htmlFile));
    }

    public void loadHtml(URL url) {
        if (this.m_window == null) {
            throw new RuntimeException("No window/browser specified");
        }
        AHtmlParser.parse(url, this.m_window);
    }

    public void loadHtmlSrc(String htmlSrc) {
        if (this.m_window == null) {
            throw new RuntimeException("No window/browser specified");
        }
        AHtmlParser.parse(htmlSrc, null, this.m_window);
    }

    public void loadActiveWeb(InputStream is, IBrowserLauncher launcher) {
        try {
            this.m_activeWeb = new ActiveWeb(is, launcher, this.m_mode);
            this.m_activeWeb.startWebServer();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object exec(URL jsFileName, String clzName, String[] jsArgs) {
        Object result = this.runScript(jsFileName);
        if (clzName != null) {
            result = this.execMain(clzName, jsArgs);
        }
        return result;
    }

    public Object execMain(String clzName, String[] jsArgs) {
        if (clzName != null) {
            if (DapCtx.ctx().isActiveMode() && JsRunner.isJ2JType(clzName)) {
                this.m_cx.evaluateString(this.m_scope, String.valueOf(clzName) + "=Packages." + clzName + LIST_SEPERATOR, clzName, 1, null);
                return this.runJavaMain(String.valueOf(clzName) + ".main", jsArgs);
            }
            return this.runMain(String.valueOf(clzName) + ".main", jsArgs);
        }
        return null;
    }

    public Object runScript(URL url) {
        try {
            return this.m_cx.evaluateReader(this.m_scope, (Reader)new InputStreamReader(url.openStream()), url.toExternalForm(), 1, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object runScript(String script, String sourceName) {
        try {
            return this.m_cx.evaluateString(this.m_scope, script, sourceName, 1, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object runScript(String script, Scriptable scope) {
        return ScriptExecutor.executeScript(script, scope, this.m_cx);
    }

    public Object runScript(String script, String sourceName, Scriptable scope) {
        try {
            return this.m_cx.evaluateString(scope, script, sourceName, 1, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object runScript(String script) {
        return ScriptExecutor.executeScript(script, this.m_scope, this.m_cx);
    }

    protected void cancelAllTimeouts() {
        if (this.m_window != null) {
            this.m_window.clearAll();
        }
    }

    public void finalize() {
        this.finalize(1);
    }

    public void finalize(int timeout) {
        if (this.m_window != null) {
            try {
                this.m_window.waitForAllJsExecutionDone(timeout);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.err.println("Use -VwaitTimeout=[msec] to specify a wait timeout.");
            }
            this.m_window.finialize();
            if (this.m_activeWeb != null) {
                this.m_activeWeb.destroy();
            }
        } else {
            Context.exit();
            if (this.m_dbg != null) {
                this.m_dbg.dispose();
            }
        }
    }

    protected Object runMain(String main, String[] args) {
        try {
            this.runScript(main, main);
        }
        catch (Exception exception) {
            return null;
        }
        StringBuilder mainExec = new StringBuilder();
        mainExec.append("if(").append(main).append(") {\n").append(main).append("(");
        int i = 0;
        if (args != null) {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if (i > 0) {
                    mainExec.append(",");
                }
                mainExec.append(JsonObject.quote((String)arg));
                ++i;
                ++n2;
            }
        }
        mainExec.append(");\n}");
        return this.runScript(mainExec.toString(), main);
    }

    protected Object runJavaMain(String main, String[] args) {
        StringBuilder mainExec = new StringBuilder();
        mainExec.append("if(").append(main).append(") {\n").append(main).append("(");
        try {
            mainExec.append(JsonSerializer.getInstance().serialize((Object)args));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        mainExec.append(");\n}");
        return this.runScript(mainExec.toString(), main);
    }

    public static ProgramInfo getProgramInfo(String[] args) throws MalformedURLException {
        ProgramInfo info = new ProgramInfo();
        int i = 0;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (!arg.startsWith(JS_OPTION_TOKEN)) break;
            JsRunner.addJsOption(arg.substring(JS_OPTION_TOKEN.length()), info);
            ++i;
            ++n2;
        }
        if (i == args.length) {
            throw new RuntimeException("missing argument for js file name");
        }
        String fileLocation = args[i++];
        try {
            info.m_fileName = new URL(fileLocation);
        }
        catch (MalformedURLException malformedURLException) {
            info.m_fileName = new File(fileLocation).toURI().toURL();
        }
        if (i < args.length) {
            info.m_jsClassName = args[i++];
            if (i < args.length) {
                info.m_jsArgs = new String[args.length - i];
                System.arraycopy(args, i, info.m_jsArgs, 0, info.m_jsArgs.length);
            }
        }
        if (info.isHtml() && info.getBrowserType() == null) {
            info.m_options.put(BROWSER_KEY, BrowserType.IE_6P.name());
        }
        return info;
    }

    public AWindow getWindow() {
        return this.m_window;
    }

    private static void addJsOption(String arg, ProgramInfo info) {
        int i = arg.indexOf("=");
        if (i > 0 && i < arg.length() - 1) {
            info.m_options.put(arg.substring(0, i), arg.substring(i + 1));
        }
    }

    protected static boolean needDebug() {
        RuntimeMXBean rtMxBean = ManagementFactory.getRuntimeMXBean();
        for (String arg : rtMxBean.getInputArguments()) {
            if (!arg.startsWith("-agentlib:jdwp")) continue;
            return true;
        }
        return false;
    }

    protected static URL toUrl(String fileName) {
        try {
            if (fileName.startsWith(HTTP)) {
                return new URL(fileName);
            }
            return new File(fileName).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private void initDebugger(boolean inBrowser) {
        ActiveJsExecutionControlCtx.ctx().setDebug(true);
        ActiveJsExecutionControlCtx.ctx().setUseSharedDebugClient(false);
        if (!JsDebuggerEnabler.useRemoteClient()) {
            JsDebuggerEnabler.enableDebuggerFileChooser();
        }
        if (!inBrowser) {
            String debuggerServiceIp = System.getProperty("VJETDebugHost");
            String debuggerServicePort = System.getProperty("VJETDebugPort");
            String debuggerServiceSessionID = System.getProperty("VJETDebugSessionID");
            if (debuggerServiceIp == null || debuggerServicePort == null || debuggerServiceSessionID == null) {
                this.m_dbg = JsDebuggerEnabler.enable();
            } else {
                org.eclipse.vjet.dsf.js.dbgp.JsDebuggerEnabler.enable();
            }
        }
    }

    private static boolean isJ2JType(String uri) {
        try {
            Class<?> clz = Class.forName(uri, false, JsRunner.class.getClassLoader());
            return !IJsJavaProxy.class.isAssignableFrom(clz);
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected ActiveWebListener createWebListener(boolean debugEnabled) {
        return new ActiveWebListener(debugEnabled);
    }

    protected class ActiveWebListener
    implements IBrowserEmulatorListener {
        protected boolean m_debugEnabled = false;

        public ActiveWebListener(boolean debugEnabled) {
            this.m_debugEnabled = debugEnabled;
        }

        @Override
        public void windowOnload() {
            this.init();
            this.execJs();
        }

        protected void init() {
            ActiveJsExecutionControlCtx.ctx().setExecuteJavaScript(true);
            JsRunner.this.m_window = DapCtx.ctx().getWindow();
            JsRunner.this.m_cx = JsRunner.this.m_window.getContext();
            JsRunner.this.m_scope = JsRunner.this.m_window;
            Context.enter();
            if (this.m_debugEnabled) {
                JsRunner.this.m_dbg = JsRunner.this.m_window.getDebugger();
            }
            if (JsRunner.this.m_dbg != null) {
                JsRunner.this.m_dbg.setBreak();
            }
        }

        protected void execJs() {
            JsRunner.this.preloadJs();
            JsRunner.this.exec(JsRunner.this.m_info.getFileName(), JsRunner.this.m_info.getJsClassName(), JsRunner.this.m_info.getJsArgs());
        }
    }

    public static class ProgramInfo {
        private URL m_fileName = null;
        private String m_jsClassName = null;
        private Map<String, String> m_options = new LinkedHashMap<String, String>();
        private String[] m_jsArgs = null;

        public URL getFileName() {
            return this.m_fileName;
        }

        public String getJsClassName() {
            return this.m_jsClassName;
        }

        public Map<String, String> getOptions() {
            return this.m_options;
        }

        public String getOption(String key) {
            return this.m_options.get(key);
        }

        public String[] getJsArgs() {
            return this.m_jsArgs;
        }

        public BrowserType getBrowserType() {
            String type = this.getOption(JsRunner.BROWSER_KEY);
            if (type == null) {
                return null;
            }
            return BrowserType.valueOf((String)type);
        }

        public boolean isHtml() {
            return JsRunner.HTML_FILE_TYPE.equalsIgnoreCase(this.getOption(JsRunner.FILE_TYPE_KEY));
        }

        public List<String> getPreloadJsList() {
            String type = this.getOption(JsRunner.LOAD_JS_KEY);
            if (type == null) {
                return null;
            }
            StringTokenizer st = new StringTokenizer(type, JsRunner.LIST_SEPERATOR);
            ArrayList<String> ls = new ArrayList<String>(2);
            while (st.hasMoreTokens()) {
                ls.add(st.nextToken());
            }
            return ls;
        }

        public String getPreloadHtml() {
            return this.getOption(JsRunner.LOAD_HTML_KEY);
        }

        public boolean needBrowserDisplay() {
            return "true".equalsIgnoreCase(this.getOption(JsRunner.BROWSER_DISPLAY_KEY));
        }

        public String getBrowserServiceUrl() {
            return this.getOption(JsRunner.BROWSER_SERVICE_URL_KEY);
        }
    }
}

