/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsdebugger.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class BreakpointCache {
    private static Map<String, Breakpoints> s_cache = new HashMap<String, Breakpoints>();

    static {
        BreakpointCache.sync();
    }

    BreakpointCache() {
    }

    static synchronized Breakpoints getBreakpoints(String url) {
        return s_cache.get(url);
    }

    static synchronized Breakpoints createBreakpoints(String url) {
        Breakpoints bp = BreakpointCache.getBreakpoints(url);
        if (bp == null) {
            bp = new Breakpoints(url);
            s_cache.put(url, bp);
        }
        return bp;
    }

    private static synchronized void persist() {
        block15: {
            File file = new File("JS_BreakpointCache");
            FileOutputStream fos = null;
            try {
                try {
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    fos = new FileOutputStream(file);
                    ObjectOutputStream oos = new ObjectOutputStream(fos);
                    oos.writeObject(s_cache);
                }
                catch (Exception exception) {
                    file.delete();
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static synchronized void sync() {
        block15: {
            File file = new File("JS_BreakpointCache");
            if (!file.exists()) {
                return;
            }
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(file);
                    ObjectInputStream ois = new ObjectInputStream(fis);
                    s_cache = (Map)ois.readObject();
                }
                catch (Exception exception) {
                    file.delete();
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static class Breakpoints
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String m_url;
        private Set<Integer> m_breakLines = new HashSet<Integer>();

        Breakpoints(String url) {
            this.m_url = url;
        }

        String getUrl() {
            return this.m_url;
        }

        void setBreakpoint(int lineNum, boolean set) {
            if (set) {
                this.m_breakLines.add(lineNum);
            } else {
                this.m_breakLines.remove(lineNum);
            }
            BreakpointCache.persist();
        }

        void removeAllBreakpoints() {
            this.m_breakLines.clear();
            BreakpointCache.persist();
        }

        int[] getBreakpoints() {
            if (this.m_breakLines.isEmpty()) {
                return null;
            }
            int[] breakPoints = new int[this.m_breakLines.size()];
            Iterator<Integer> itr = this.m_breakLines.iterator();
            int i = 0;
            while (itr.hasNext()) {
                breakPoints[i++] = itr.next();
            }
            return breakPoints;
        }
    }
}

