/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.json.serializer;

import java.lang.reflect.Array;
import org.eclipse.vjet.dsf.json.JsonArray;
import org.eclipse.vjet.dsf.json.serializer.AbstractSerializer;
import org.eclipse.vjet.dsf.json.serializer.ObjectMatch;
import org.eclipse.vjet.dsf.json.serializer.SerializationException;
import org.eclipse.vjet.dsf.json.serializer.SerializerState;

public class ArraySerializer
extends AbstractSerializer {
    private static Class[] s_serializableClasses = new Class[]{int[].class, short[].class, long[].class, float[].class, double[].class, boolean[].class, Integer[].class, Short[].class, Long[].class, Float[].class, Double[].class, Boolean[].class, String[].class};
    private static Class[] s_JSONClasses = new Class[]{JsonArray.class};

    public Class[] getSerializableClasses() {
        return s_serializableClasses;
    }

    public Class[] getJSONClasses() {
        return s_JSONClasses;
    }

    @Override
    public boolean canSerialize(Class clazz, Class jsonClazz) {
        Class<?> cc = clazz.getComponentType();
        return super.canSerialize(clazz, jsonClazz) || (jsonClazz == null || jsonClazz == JsonArray.class) && clazz.isArray() && !cc.isPrimitive();
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws SerializationException {
        JsonArray jso = (JsonArray)o;
        Class<?> cc = clazz.getComponentType();
        int i = 0;
        ObjectMatch m = new ObjectMatch(-1);
        try {
            while (i < jso.length()) {
                m = this.getOwner().tryUnmarshall(state, cc, jso.get(i)).max(m);
                ++i;
            }
        }
        catch (SerializationException e) {
            throw new SerializationException("element " + i + " " + e.getMessage());
        }
        return m;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object o) throws SerializationException {
        JsonArray jso = (JsonArray)o;
        Class<?> cc = clazz.getComponentType();
        int i = 0;
        try {
            if (clazz == int[].class) {
                int[] arr = new int[jso.length()];
                while (i < jso.length()) {
                    arr[i] = ((Number)this.getOwner().unmarshall(state, cc, jso.get(i))).intValue();
                    ++i;
                }
                return arr;
            }
            if (clazz == byte[].class) {
                byte[] arr = new byte[jso.length()];
                while (i < jso.length()) {
                    arr[i] = ((Number)this.getOwner().unmarshall(state, cc, jso.get(i))).byteValue();
                    ++i;
                }
                return arr;
            }
            if (clazz == short[].class) {
                short[] arr = new short[jso.length()];
                while (i < jso.length()) {
                    arr[i] = ((Number)this.getOwner().unmarshall(state, cc, jso.get(i))).shortValue();
                    ++i;
                }
                return arr;
            }
            if (clazz == long[].class) {
                long[] arr = new long[jso.length()];
                while (i < jso.length()) {
                    arr[i] = ((Number)this.getOwner().unmarshall(state, cc, jso.get(i))).longValue();
                    ++i;
                }
                return arr;
            }
            if (clazz == float[].class) {
                float[] arr = new float[jso.length()];
                while (i < jso.length()) {
                    arr[i] = ((Number)this.getOwner().unmarshall(state, cc, jso.get(i))).floatValue();
                    ++i;
                }
                return arr;
            }
            if (clazz == double[].class) {
                double[] arr = new double[jso.length()];
                while (i < jso.length()) {
                    arr[i] = ((Number)this.getOwner().unmarshall(state, cc, jso.get(i))).doubleValue();
                    ++i;
                }
                return arr;
            }
            if (clazz == char[].class) {
                char[] arr = new char[jso.length()];
                while (i < jso.length()) {
                    arr[i] = ((String)this.getOwner().unmarshall(state, cc, jso.get(i))).charAt(0);
                    ++i;
                }
                return arr;
            }
            if (clazz == boolean[].class) {
                boolean[] arr = new boolean[jso.length()];
                while (i < jso.length()) {
                    arr[i] = (Boolean)this.getOwner().unmarshall(state, cc, jso.get(i));
                    ++i;
                }
                return arr;
            }
            Object[] arr = (Object[])Array.newInstance(clazz.getComponentType(), jso.length());
            while (i < jso.length()) {
                arr[i] = this.getOwner().unmarshall(state, cc, jso.get(i));
                ++i;
            }
            return arr;
        }
        catch (SerializationException e) {
            throw new SerializationException("element " + i + " " + e.getMessage());
        }
    }

    @Override
    public Object marshall(SerializerState state, Object o) throws SerializationException {
        JsonArray arr;
        block10: {
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block9: {
                                            arr = new JsonArray();
                                            if (!(o instanceof int[])) break block9;
                                            int[] a = (int[])o;
                                            int i = 0;
                                            while (i < a.length) {
                                                arr.put(a[i]);
                                                ++i;
                                            }
                                            break block10;
                                        }
                                        if (!(o instanceof long[])) break block11;
                                        long[] a = (long[])o;
                                        int i = 0;
                                        while (i < a.length) {
                                            arr.put((double)a[i]);
                                            ++i;
                                        }
                                        break block10;
                                    }
                                    if (!(o instanceof short[])) break block12;
                                    short[] a = (short[])o;
                                    int i = 0;
                                    while (i < a.length) {
                                        arr.put((int)a[i]);
                                        ++i;
                                    }
                                    break block10;
                                }
                                if (!(o instanceof byte[])) break block13;
                                byte[] a = (byte[])o;
                                int i = 0;
                                while (i < a.length) {
                                    arr.put((int)a[i]);
                                    ++i;
                                }
                                break block10;
                            }
                            if (!(o instanceof float[])) break block14;
                            float[] a = (float[])o;
                            int i = 0;
                            while (i < a.length) {
                                arr.put((double)a[i]);
                                ++i;
                            }
                            break block10;
                        }
                        if (!(o instanceof double[])) break block15;
                        double[] a = (double[])o;
                        int i = 0;
                        while (i < a.length) {
                            arr.put(a[i]);
                            ++i;
                        }
                        break block10;
                    }
                    if (!(o instanceof char[])) break block16;
                    char[] a = (char[])o;
                    int i = 0;
                    while (i < a.length) {
                        arr.put((int)a[i]);
                        ++i;
                    }
                    break block10;
                }
                if (!(o instanceof boolean[])) break block17;
                boolean[] a = (boolean[])o;
                int i = 0;
                while (i < a.length) {
                    arr.put(a[i]);
                    ++i;
                }
                break block10;
            }
            if (!(o instanceof Object[])) break block10;
            Object[] a = (Object[])o;
            int i = 0;
            while (i < a.length) {
                arr.put(this.getOwner().marshall(state, a[i]));
                ++i;
            }
        }
        return arr;
    }
}

