/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.json.serializer;

import java.sql.Timestamp;
import java.util.Date;
import org.eclipse.vjet.dsf.json.JsonObject;
import org.eclipse.vjet.dsf.json.serializer.AbstractSerializer;
import org.eclipse.vjet.dsf.json.serializer.ObjectMatch;
import org.eclipse.vjet.dsf.json.serializer.SerializationException;
import org.eclipse.vjet.dsf.json.serializer.SerializerState;

public class DateSerializer
extends AbstractSerializer {
    private static Class[] s_serializableClasses = new Class[]{Date.class, Timestamp.class, java.sql.Date.class};
    private static Class[] s_JSONClasses = new Class[]{JsonObject.class};
    private String m_javaClass = "javaClass";

    public Class[] getSerializableClasses() {
        return s_serializableClasses;
    }

    public Class[] getJSONClasses() {
        return s_JSONClasses;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws SerializationException {
        JsonObject jso = (JsonObject)o;
        String java_class = jso.getString(this.m_javaClass);
        if (java_class == null) {
            throw new SerializationException("no type hint");
        }
        if (!java_class.equals("java.util.Date")) {
            throw new SerializationException("not a Date");
        }
        return ObjectMatch.OKAY;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object o) throws SerializationException {
        Class<?> cls = clazz;
        JsonObject jso = (JsonObject)o;
        long time = jso.getLong("time");
        if (jso.has(this.m_javaClass)) {
            try {
                cls = Class.forName(jso.getString(this.m_javaClass));
            }
            catch (ClassNotFoundException cnfe) {
                throw new SerializationException(cnfe.getMessage());
            }
        }
        if (Date.class.equals((Object)cls)) {
            return new Date(time);
        }
        if (Timestamp.class.equals(cls)) {
            return new Timestamp(time);
        }
        if (java.sql.Date.class.equals(cls)) {
            return new java.sql.Date(time);
        }
        throw new SerializationException("invalid class " + cls);
    }

    @Override
    public Object marshall(SerializerState state, Object o) throws SerializationException {
        if (!(o instanceof Date)) {
            throw new SerializationException("cannot marshall date using class " + o.getClass());
        }
        long time = ((Date)o).getTime();
        JsonObject obj = new JsonObject();
        if (this.isMarshallClassHints()) {
            obj.put(this.m_javaClass, (Object)o.getClass().getName());
        }
        obj.put("time", (double)time);
        return obj;
    }
}

