/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.service.serializer;

import java.io.UnsupportedEncodingException;
import org.eclipse.vjet.dsf.json.serializer.ArraySerializer;
import org.eclipse.vjet.dsf.json.serializer.BeanSerializer;
import org.eclipse.vjet.dsf.json.serializer.BooleanSerializer;
import org.eclipse.vjet.dsf.json.serializer.DateSerializer;
import org.eclipse.vjet.dsf.json.serializer.DictionarySerializer;
import org.eclipse.vjet.dsf.json.serializer.EnumSerializer;
import org.eclipse.vjet.dsf.json.serializer.JsonRpcSerializer;
import org.eclipse.vjet.dsf.json.serializer.ListSerializer;
import org.eclipse.vjet.dsf.json.serializer.MapSerializer;
import org.eclipse.vjet.dsf.json.serializer.NumberSerializer;
import org.eclipse.vjet.dsf.json.serializer.PrimitiveSerializer;
import org.eclipse.vjet.dsf.json.serializer.SerializationException;
import org.eclipse.vjet.dsf.json.serializer.SetSerializer;
import org.eclipse.vjet.dsf.json.serializer.StringSerializer;
import org.eclipse.vjet.dsf.service.serializer.ISerializer;
import org.eclipse.vjet.dsf.services.IRequestValidator;

public class JsonSerializer
implements ISerializer {
    private static JsonSerializer s_instance;
    private JsonRpcSerializer m_rpcSerializer;

    public static JsonSerializer getInstance() {
        if (s_instance == null) {
            s_instance = new JsonSerializer();
        }
        return s_instance;
    }

    private JsonSerializer() {
        try {
            this.m_rpcSerializer = new JsonRpcSerializer();
            this.m_rpcSerializer.registerSerializer(new ArraySerializer());
            this.m_rpcSerializer.registerSerializer(new DictionarySerializer());
            this.m_rpcSerializer.registerSerializer(new MapSerializer());
            this.m_rpcSerializer.registerSerializer(new SetSerializer());
            ListSerializer listSer = new ListSerializer();
            listSer.setMarshallClassHints(false);
            this.m_rpcSerializer.registerSerializer(listSer);
            this.m_rpcSerializer.registerSerializer(new DateSerializer());
            this.m_rpcSerializer.registerSerializer(new StringSerializer());
            this.m_rpcSerializer.registerSerializer(new NumberSerializer());
            this.m_rpcSerializer.registerSerializer(new BooleanSerializer());
            this.m_rpcSerializer.registerSerializer(new PrimitiveSerializer());
            this.m_rpcSerializer.registerSerializer(new EnumSerializer());
            BeanSerializer bSer = new BeanSerializer();
            bSer.setMarshallClassHints(false);
            this.m_rpcSerializer.registerSerializer(bSer);
        }
        catch (SerializationException serializationException) {}
    }

    public Object deserialize(String aContent, Class aClass, IRequestValidator validator) throws SerializationException {
        return this.m_rpcSerializer.fromJSON(aContent, aClass, validator);
    }

    public String serialize(Object aSource) throws SerializationException, UnsupportedEncodingException {
        String str = this.m_rpcSerializer.toJSON(aSource);
        return str;
    }

    public org.eclipse.vjet.dsf.json.serializer.ISerializer getSerializer(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.m_rpcSerializer.getSerializer(obj.getClass(), null);
    }
}

