/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.liveconnect;

import java.util.LinkedHashMap;
import java.util.Map;

public class DLCHttpResponse {
    private static final String HEADER_TOKEN = "\r\n";
    private static final String FIRST_LINE = "HTTP/1.1 200 OK\r\n";
    private final byte[] m_data;
    private Map<String, String> m_headers = new LinkedHashMap<String, String>();

    public DLCHttpResponse(String data) {
        this(data.getBytes());
    }

    public DLCHttpResponse(byte[] data) {
        this.m_data = data;
        this.m_headers.put("Content-Length", String.valueOf(this.m_data.length));
        this.m_headers.put("Cache-Control", "no-cache");
    }

    public DLCHttpResponse(boolean boolReturn) {
        this(String.valueOf(boolReturn));
    }

    public void addHeader(String name, String value) {
        this.m_headers.put(name, value);
    }

    public void setContentType(String type) {
        this.m_headers.put("Content-Type", type);
    }

    public byte[] getHttpPayload() {
        StringBuilder sb = new StringBuilder();
        sb.append(FIRST_LINE);
        this.processHeaders(sb);
        sb.append(HEADER_TOKEN);
        byte[] headerbytes = sb.toString().getBytes();
        byte[] payload = new byte[headerbytes.length + this.m_data.length];
        System.arraycopy(headerbytes, 0, payload, 0, headerbytes.length);
        System.arraycopy(this.m_data, 0, payload, headerbytes.length, this.m_data.length);
        return payload;
    }

    private void processHeaders(StringBuilder sb) {
        for (Map.Entry<String, String> entry : this.m_headers.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append(HEADER_TOKEN);
        }
    }
}

