/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.liveconnect;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.liveconnect.DLCFutureResult;
import org.eclipse.vjet.dsf.liveconnect.DLCFutureResultMgr;
import org.eclipse.vjet.dsf.liveconnect.DLCHttpRequest;
import org.eclipse.vjet.dsf.liveconnect.DLCHttpResponse;
import org.eclipse.vjet.dsf.liveconnect.DLCReceiverInvocator;
import org.eclipse.vjet.dsf.liveconnect.IDLCReceiver;
import org.eclipse.vjet.dsf.liveconnect.client.DLCClientHelper;
import org.eclipse.vjet.dsf.liveconnect.client.DLCHttpResource;
import org.eclipse.vjet.dsf.liveconnect.client.DLCResourceHolder;
import org.eclipse.vjet.dsf.liveconnect.client.IDLCClient;
import org.eclipse.vjet.dsf.liveconnect.client.IDLCJsProvider;

public class DLCServer
implements Runnable {
    private int m_port = 1028;
    private ServerSocketChannel m_serverChannel;
    private Selector m_selector;
    private ByteBuffer m_readBuffer = ByteBuffer.allocate(8192);
    private Map<SocketChannel, List<ByteBuffer>> m_pendingWrites = new HashMap<SocketChannel, List<ByteBuffer>>();
    private Map<SocketChannel, byte[]> m_partialReads = new HashMap<SocketChannel, byte[]>();
    private List<StateChange> m_pendingChanges = new ArrayList<StateChange>();
    private Set<SocketChannel> m_toBeClosed = new HashSet<SocketChannel>(2);
    private DLCFutureResultMgr m_futureResultMgr = new DLCFutureResultMgr();
    private final IDLCReceiver m_receiver;
    private IDLCClient m_dclClient = null;
    private IDLCJsProvider m_jsProvider = null;
    private DLCResourceHolder m_resourceHolder = null;
    private boolean m_shutdown = false;
    private static final String EOF = "\u0000";
    private static final String POLICY_REQUEST = "<policy-file-request/>";
    private static final String POLICY = "<?xml version=\"1.0\"?><cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"*\" /></cross-domain-policy>";
    private static final String CONNECTED = "DLC_CONNECTED";
    private static final String DLC_REQUEST = "DLC_REQUEST:";
    private static final String DLC_RESPONSE = "DLC_RESPONSE:";
    private static final byte[] DLC_HTTP_REQUEST = "POST / HTTP/".getBytes();
    private static final byte[] DLC_HTTP_GET_REQUEST = "GET /".getBytes();
    public static final String DLC_CLIENT_FILE_NAME = "DLC_CLIENT_JS.js";
    public static final String DLC_FILE_NAME = "DLC_JS.js";
    private static final byte[] DLC_JS_REQUEST = "GET /DLC_JS.js HTTP/".getBytes();
    private static final byte[] DLC_CLIENT_JS_REQUEST = "GET /DLC_CLIENT_JS.js HTTP/".getBytes();
    private static final byte[] DLC_SWF_REQUEST = "GET /SWF HTTP/".getBytes();

    public DLCServer(IDLCReceiver receiver, IDLCClient dlcClient) throws IOException {
        this(receiver, dlcClient, null, null, 1028, true);
    }

    public DLCServer(IDLCReceiver receiver, IDLCClient dlcClient, int preferredPort) throws IOException {
        this(receiver, dlcClient, null, null, preferredPort, true);
    }

    public DLCServer(IDLCReceiver receiver, IDLCClient dlcClient, IDLCJsProvider jsProvider, DLCResourceHolder holder) throws IOException {
        this(receiver, dlcClient, jsProvider, holder, 1028, true);
    }

    public DLCServer(IDLCReceiver receiver, IDLCClient dlcClient, IDLCJsProvider jsProvider, DLCResourceHolder holder, int preferredPort, boolean isDaemon) throws IOException {
        this.m_dclClient = dlcClient;
        this.m_jsProvider = jsProvider;
        this.m_resourceHolder = holder;
        this.m_port = preferredPort;
        this.m_receiver = new DLCReceiverInvocator(receiver, this.m_futureResultMgr);
        this.m_serverChannel = ServerSocketChannel.open();
        this.m_serverChannel.configureBlocking(false);
        while (this.m_port <= 65535) {
            try {
                this.m_serverChannel.socket().bind(new InetSocketAddress(this.m_port));
                break;
            }
            catch (IOException iOException) {
                System.out.println("There is already an existing server on port " + this.m_port + ".");
                ++this.m_port;
            }
        }
        this.m_selector = SelectorProvider.provider().openSelector();
        this.m_serverChannel.register(this.m_selector, 16);
        System.out.println("DLC Server started at port " + this.m_port);
        Thread t = new Thread(this);
        t.setDaemon(isDaemon);
        t.start();
    }

    public DLCResourceHolder getResourceHolder() {
        return this.m_resourceHolder;
    }

    public DLCFutureResult request(SocketChannel channel, String message) {
        DLCFutureResult result = this.m_futureResultMgr.create();
        this.send(channel, DLC_REQUEST + result.getRequestId() + ":" + message);
        return result;
    }

    public void send(SocketChannel channel, String message) {
        if (!message.endsWith(EOF)) {
            message = String.valueOf(message) + EOF;
        }
        this.send(channel, message.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(SocketChannel channel, byte[] data) {
        List<StateChange> list = this.m_pendingChanges;
        synchronized (list) {
            Map<SocketChannel, List<ByteBuffer>> map = this.m_pendingWrites;
            synchronized (map) {
                List<ByteBuffer> writeList = this.m_pendingWrites.get(channel);
                if (writeList == null) {
                    writeList = new ArrayList<ByteBuffer>();
                    this.m_pendingWrites.put(channel, writeList);
                }
                writeList.add(ByteBuffer.wrap(data));
            }
            this.m_pendingChanges.add(new StateChange(channel, 4));
            this.m_selector.wakeup();
        }
    }

    public int getPort() {
        return this.m_port;
    }

    public synchronized void shutdown() {
        this.m_shutdown = true;
        this.m_selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.m_shutdown) {
            try {
                List<StateChange> list = this.m_pendingChanges;
                synchronized (list) {
                    for (StateChange change : this.m_pendingChanges) {
                        SelectionKey key = change.m_channel.keyFor(this.m_selector);
                        if (key == null) continue;
                        key.interestOps(change.m_ops);
                    }
                    this.m_pendingChanges.clear();
                }
                this.m_selector.select();
                Iterator<SelectionKey> selectedKeys = this.m_selector.selectedKeys().iterator();
                while (selectedKeys.hasNext()) {
                    SelectionKey key = selectedKeys.next();
                    selectedKeys.remove();
                    if (!key.isValid()) continue;
                    if (key.isAcceptable()) {
                        this.accept(key);
                        continue;
                    }
                    if (key.isReadable()) {
                        this.read(key);
                        continue;
                    }
                    if (!key.isWritable()) continue;
                    this.write(key);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void accept(SelectionKey key) throws IOException {
        ServerSocketChannel serverChannel = (ServerSocketChannel)key.channel();
        SocketChannel socketChannel = serverChannel.accept();
        socketChannel.configureBlocking(false);
        socketChannel.register(this.m_selector, 1);
    }

    private void read(SelectionKey key) throws IOException {
        int numRead;
        SocketChannel socketChannel = (SocketChannel)key.channel();
        do {
            this.m_readBuffer.clear();
            try {
                numRead = socketChannel.read(this.m_readBuffer);
                if (numRead <= 0) continue;
                this.m_readBuffer.flip();
                this.processData(numRead, socketChannel);
            }
            catch (IOException iOException) {
                key.cancel();
                socketChannel.close();
                return;
            }
        } while (numRead > 0);
        if (numRead == -1) {
            socketChannel.close();
            key.cancel();
            this.m_receiver.closed(socketChannel);
            return;
        }
    }

    private void processData(int numRead, SocketChannel socketChannel) {
        int startIndex;
        int i = startIndex = 0;
        while (i < numRead) {
            if (this.m_readBuffer.get(i) == 0) {
                if (startIndex == 0 && i == numRead - 1) {
                    this.informReceiver(socketChannel, this.m_readBuffer.array(), numRead);
                } else {
                    byte[] data = new byte[i - startIndex + 1];
                    this.m_readBuffer.get(data, 0, data.length);
                    this.informReceiver(socketChannel, data, data.length);
                }
                startIndex = i + 1;
            }
            ++i;
        }
        if (startIndex < numRead) {
            byte[] data = new byte[numRead - startIndex];
            this.m_readBuffer.get(data, 0, data.length);
            if (DLCServer.isRequestOf(data, DLC_HTTP_REQUEST)) {
                DLCHttpResponse response = this.m_receiver.get(socketChannel, new DLCHttpRequest(new String(data)));
                this.m_toBeClosed.add(socketChannel);
                this.send(socketChannel, response.getHttpPayload());
            } else if (DLCServer.isRequestOf(data, DLC_JS_REQUEST)) {
                this.m_toBeClosed.add(socketChannel);
                this.send(socketChannel, this.getDlcJs().getHttpPayload());
            } else if (DLCServer.isRequestOf(data, DLC_CLIENT_JS_REQUEST)) {
                this.m_toBeClosed.add(socketChannel);
                this.send(socketChannel, this.getDlcClientJs().getHttpPayload());
            } else if (DLCServer.isRequestOf(data, DLC_SWF_REQUEST)) {
                this.m_toBeClosed.add(socketChannel);
                this.send(socketChannel, this.getDlcSwf().getHttpPayload());
            } else if (DLCServer.isRequestOf(data, DLC_HTTP_GET_REQUEST)) {
                DLCHttpRequest request = new DLCHttpRequest(new String(data));
                DLCHttpResponse response = this.m_receiver.get(socketChannel, request);
                if (response == null && this.m_resourceHolder != null) {
                    response = this.getDlcResource(request.getUri());
                }
                if (response != null) {
                    this.m_toBeClosed.add(socketChannel);
                    this.send(socketChannel, response.getHttpPayload());
                }
            } else {
                this.savePendingReads(socketChannel, data);
            }
        }
    }

    private static boolean isRequestOf(byte[] data, byte[] type) {
        if (data.length <= type.length) {
            return false;
        }
        int i = 0;
        while (i < type.length) {
            if (type[i] != data[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private DLCHttpResponse getDlcJs() {
        DLCHttpResponse response = new DLCHttpResponse(DLCClientHelper.DLC_JS);
        response.setContentType("application/javascript");
        return response;
    }

    private DLCHttpResponse getDlcClientJs() {
        StringBuffer clientJs = new StringBuffer(1024);
        if (this.m_dclClient != null) {
            clientJs.append(new String(this.m_dclClient.getClientJs()));
        }
        if (this.m_jsProvider != null) {
            clientJs.append(new String(this.m_jsProvider.getClientJs()));
        }
        DLCHttpResponse response = new DLCHttpResponse(clientJs.toString().getBytes());
        response.setContentType("application/javascript");
        return response;
    }

    private DLCHttpResponse getDlcSwf() {
        DLCHttpResponse response = new DLCHttpResponse(DLCClientHelper.DLC_SWF);
        response.setContentType("application/x-shockwave-flash");
        return response;
    }

    private DLCHttpResponse getDlcResource(String uri) {
        if (this.m_resourceHolder == null) {
            return null;
        }
        DLCHttpResource resource = this.m_resourceHolder.getResource(uri);
        DLCHttpResponse response = new DLCHttpResponse(resource.getContent());
        response.setContentType(resource.getMimeType());
        return response;
    }

    private void savePendingReads(SocketChannel socketChannel, byte[] data) {
        byte[] pendingData = this.m_partialReads.get(socketChannel);
        if (pendingData == null) {
            this.m_partialReads.put(socketChannel, data);
        } else {
            byte[] total = new byte[pendingData.length + data.length];
            System.arraycopy(pendingData, 0, total, 0, pendingData.length);
            System.arraycopy(data, 0, total, pendingData.length, data.length);
            this.m_partialReads.put(socketChannel, total);
        }
    }

    private void informReceiver(SocketChannel socketChannel, byte[] data, int size) {
        String message;
        byte[] total = data;
        byte[] pendingData = this.m_partialReads.get(socketChannel);
        if (pendingData != null) {
            total = new byte[pendingData.length + size];
            System.arraycopy(pendingData, 0, total, 0, pendingData.length);
            System.arraycopy(data, 0, total, pendingData.length, size);
            this.m_partialReads.put(socketChannel, null);
            size = total.length;
        }
        if (POLICY_REQUEST.equalsIgnoreCase(message = new String(total, 0, size - 1))) {
            this.send(socketChannel, POLICY);
        } else if (CONNECTED.equalsIgnoreCase(message)) {
            this.m_receiver.connected(socketChannel);
        } else if (message.startsWith(DLC_RESPONSE)) {
            int endIndex = message.indexOf(":", DLC_RESPONSE.length());
            String requestId = message.substring(DLC_RESPONSE.length(), endIndex);
            this.m_futureResultMgr.setResult(requestId, message.substring(endIndex + 1));
        } else {
            this.m_receiver.received(socketChannel, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(SelectionKey key) throws IOException {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        Map<SocketChannel, List<ByteBuffer>> map = this.m_pendingWrites;
        synchronized (map) {
            List<ByteBuffer> dataList = this.m_pendingWrites.get(socketChannel);
            while (!dataList.isEmpty()) {
                ByteBuffer buf = dataList.get(0);
                socketChannel.write(buf);
                if (buf.remaining() > 0) break;
                dataList.remove(0);
            }
            if (dataList.isEmpty()) {
                if (this.m_toBeClosed.contains(socketChannel)) {
                    this.m_toBeClosed.remove(socketChannel);
                    socketChannel.close();
                    key.cancel();
                } else {
                    key.interestOps(1);
                }
            }
        }
    }

    private static class StateChange {
        private final SocketChannel m_channel;
        private final int m_ops;

        private StateChange(SocketChannel channel, int ops) {
            this.m_channel = channel;
            this.m_ops = ops;
        }
    }
}

