/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.liveconnect.client;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.liveconnect.client.DLCHttpResource;
import org.eclipse.vjet.dsf.liveconnect.client.IDLCResourceProvider;

public class DLCResourceHolder {
    private Map<String, IDLCResourceProvider> m_providers = new HashMap<String, IDLCResourceProvider>();
    private Map<String, DLCHttpResource> m_cache = new HashMap<String, DLCHttpResource>();

    public void addProvider(IDLCResourceProvider provider) {
        this.m_providers.put(provider.getBaseUrl(), provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLCHttpResource getResource(String url) {
        DLCHttpResource resource = this.m_cache.get(url);
        if (resource == null) {
            int ind = url.lastIndexOf(47);
            if (ind == -1) {
                throw new IllegalArgumentException("Malformed url: " + url);
            }
            if (ind == url.length() - 1) {
                throw new IllegalArgumentException("Listing directory are forbidden: " + url);
            }
            String baseUrl = url.substring(0, ind);
            String name = url.substring(ind + 1);
            Map<String, DLCHttpResource> map = this.m_cache;
            synchronized (map) {
                IDLCResourceProvider provider;
                resource = this.m_cache.get(url);
                if (resource == null && (provider = this.m_providers.get(baseUrl)) != null) {
                    resource = provider.getResource(name);
                    this.m_cache.put(url, resource);
                }
            }
        }
        return resource;
    }
}

