/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.coverage;

import java.util.HashMap;
import org.eclipse.vjet.vjo.coverage.JsCoverageFunction;

public class JsCoverageType {
    private String typeName;
    private HashMap<String, JsCoverageFunction> typeFunctionList = new HashMap();

    public JsCoverageType() {
    }

    public JsCoverageType(String name) {
        this.typeName = name;
    }

    public void addFunction(String funcName) {
        this.typeFunctionList.put(funcName, new JsCoverageFunction(funcName));
    }

    public boolean isFunction(String funcName) {
        return this.getFunction(funcName) != null;
    }

    public JsCoverageFunction getFunction(String funcName) {
        return this.typeFunctionList.get(funcName);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public boolean hasCoverage() {
        for (JsCoverageFunction func : this.typeFunctionList.values()) {
            if (!func.isCovered()) continue;
            return true;
        }
        return false;
    }

    public int getTypeCoverageLineCount() {
        int count = 0;
        for (JsCoverageFunction func : this.typeFunctionList.values()) {
            count += func.getCurLineCovCount();
        }
        return count;
    }

    public int getTypeLineCount() {
        int count = 0;
        for (JsCoverageFunction func : this.typeFunctionList.values()) {
            count += func.getTotalLines();
        }
        return count;
    }

    public int getNumberOfCoveredFunctions() {
        int count = 0;
        for (JsCoverageFunction func : this.typeFunctionList.values()) {
            if (!func.isCovered()) continue;
            ++count;
        }
        return count;
    }

    public int getNumberOfTotalFunctions() {
        return this.typeFunctionList.size();
    }

    public HashMap<String, JsCoverageFunction> getTypeFunctionList() {
        return this.typeFunctionList;
    }

    public void setTypeFunctionList(HashMap<String, JsCoverageFunction> funcList) {
        this.typeFunctionList = funcList;
    }
}

